// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by lister-gen. DO NOT EDIT.

package v2

import (
	v2 "github.com/apache/apisix-ingress-controller/pkg/kube/apisix/apis/config/v2"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ApisixGlobalRuleLister helps list ApisixGlobalRules.
// All objects returned here must be treated as read-only.
type ApisixGlobalRuleLister interface {
	// List lists all ApisixGlobalRules in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2.ApisixGlobalRule, err error)
	// ApisixGlobalRules returns an object that can list and get ApisixGlobalRules.
	ApisixGlobalRules(namespace string) ApisixGlobalRuleNamespaceLister
	ApisixGlobalRuleListerExpansion
}

// apisixGlobalRuleLister implements the ApisixGlobalRuleLister interface.
type apisixGlobalRuleLister struct {
	indexer cache.Indexer
}

// NewApisixGlobalRuleLister returns a new ApisixGlobalRuleLister.
func NewApisixGlobalRuleLister(indexer cache.Indexer) ApisixGlobalRuleLister {
	return &apisixGlobalRuleLister{indexer: indexer}
}

// List lists all ApisixGlobalRules in the indexer.
func (s *apisixGlobalRuleLister) List(selector labels.Selector) (ret []*v2.ApisixGlobalRule, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v2.ApisixGlobalRule))
	})
	return ret, err
}

// ApisixGlobalRules returns an object that can list and get ApisixGlobalRules.
func (s *apisixGlobalRuleLister) ApisixGlobalRules(namespace string) ApisixGlobalRuleNamespaceLister {
	return apisixGlobalRuleNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ApisixGlobalRuleNamespaceLister helps list and get ApisixGlobalRules.
// All objects returned here must be treated as read-only.
type ApisixGlobalRuleNamespaceLister interface {
	// List lists all ApisixGlobalRules in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v2.ApisixGlobalRule, err error)
	// Get retrieves the ApisixGlobalRule from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v2.ApisixGlobalRule, error)
	ApisixGlobalRuleNamespaceListerExpansion
}

// apisixGlobalRuleNamespaceLister implements the ApisixGlobalRuleNamespaceLister
// interface.
type apisixGlobalRuleNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ApisixGlobalRules in the indexer for a given namespace.
func (s apisixGlobalRuleNamespaceLister) List(selector labels.Selector) (ret []*v2.ApisixGlobalRule, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v2.ApisixGlobalRule))
	})
	return ret, err
}

// Get retrieves the ApisixGlobalRule from the indexer for a given namespace and name.
func (s apisixGlobalRuleNamespaceLister) Get(name string) (*v2.ApisixGlobalRule, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v2.Resource("apisixglobalrule"), name)
	}
	return obj.(*v2.ApisixGlobalRule), nil
}
