/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.Collection;
import java.util.function.Consumer;
import org.apache.aries.component.dsl.CachingServiceReference;

public class PropertyWrapper {
    private CachingServiceReference<OpenAPI> cachingServiceReference;

    public PropertyWrapper(CachingServiceReference<OpenAPI> cachingServiceReference) {
        this.cachingServiceReference = cachingServiceReference;
    }

    public void applyBoolean(String property, Consumer<Boolean> consumer) {
        Object value = this.cachingServiceReference.getProperty(property);
        if (value instanceof Boolean) {
            consumer.accept((Boolean)value);
        }
        if (value instanceof String) {
            consumer.accept(Boolean.parseBoolean((String)value));
        }
    }

    public void applyString(String property, Consumer<String> consumer) {
        Object value = this.cachingServiceReference.getProperty(property);
        if (value != null) {
            consumer.accept(value.toString());
        }
    }

    public <T extends Collection<String>> void applyStringCollection(String property, Consumer<T> consumer) {
        Object value = this.cachingServiceReference.getProperty(property);
        if (value instanceof Collection) {
            consumer.accept((Collection)value);
        }
    }

    public void applyLong(String property, Consumer<Long> consumer) {
        Object value = this.cachingServiceReference.getProperty(property);
        if (value instanceof Long) {
            consumer.accept((Long)value);
        }
        if (value instanceof String) {
            consumer.accept(Long.parseLong((String)value));
        }
    }
}

