/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.ClauseTokenizer;
import org.apache.aries.subsystem.core.archive.DeployedContentRequirement;
import org.apache.aries.subsystem.core.archive.DeployedVersionAttribute;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.ParameterFactory;
import org.apache.aries.subsystem.core.archive.ReferenceDirective;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.apache.aries.subsystem.core.archive.StartOrderDirective;
import org.apache.aries.subsystem.core.archive.TypeAttribute;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.apache.aries.subsystem.core.internal.Utils;
import org.osgi.framework.Version;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class DeployedContentHeader
implements RequirementHeader<Clause> {
    public static final String NAME = "Deployed-Content";
    private final Set<Clause> clauses;

    public static DeployedContentHeader newInstance(Collection<Resource> resources) {
        StringBuilder builder = new StringBuilder();
        for (Resource resource : resources) {
            DeployedContentHeader.appendResource(resource, builder, true);
            builder.append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return new DeployedContentHeader(builder.toString());
    }

    private static StringBuilder appendResource(Resource resource, StringBuilder builder, boolean referenced) {
        String symbolicName = ResourceHelper.getSymbolicNameAttribute(resource);
        Version version = ResourceHelper.getVersionAttribute(resource);
        String type = ResourceHelper.getTypeAttribute(resource);
        builder.append(symbolicName).append(';').append("deployed-version").append('=').append(version.toString()).append(';').append("type").append('=').append(type).append(';').append("resourceId").append('=').append(Utils.getId(resource)).append(';').append("reference").append(":=").append(referenced);
        return builder;
    }

    private static Collection<Clause> processHeader(String value) {
        Collection<String> clauseStrs = new ClauseTokenizer(value).getClauses();
        HashSet<Clause> clauses = new HashSet<Clause>(clauseStrs.size());
        for (String clause : new ClauseTokenizer(value).getClauses()) {
            clauses.add(new Clause(clause));
        }
        return clauses;
    }

    public DeployedContentHeader(Collection<Clause> clauses) {
        if (clauses.isEmpty()) {
            throw new IllegalArgumentException("A Deployed-Content header must have at least one clause");
        }
        this.clauses = new HashSet<Clause>(clauses);
    }

    public DeployedContentHeader(String value) {
        this(DeployedContentHeader.processHeader(value));
    }

    public boolean contains(Resource resource) {
        for (Clause clause : this.getClauses()) {
            if (!clause.contains(resource)) continue;
            return true;
        }
        return false;
    }

    public Clause getClause(Resource resource) {
        String symbolicName = ResourceHelper.getSymbolicNameAttribute(resource);
        Version version = ResourceHelper.getVersionAttribute(resource);
        String type = ResourceHelper.getTypeAttribute(resource);
        for (Clause clause : this.clauses) {
            if (!symbolicName.equals(clause.getPath()) || !clause.getDeployedVersion().equals((Object)version) || !type.equals(clause.getType())) continue;
            return clause;
        }
        return null;
    }

    @Override
    public Collection<Clause> getClauses() {
        return Collections.unmodifiableSet(this.clauses);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    public boolean isReferenced(Resource resource) {
        Clause clause = this.getClause(resource);
        if (clause == null) {
            return false;
        }
        return clause.isReferenced();
    }

    @Override
    public List<Requirement> toRequirements(Resource resource) {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>(this.clauses.size());
        for (Clause clause : this.clauses) {
            requirements.add(clause.toRequirement(resource));
        }
        return requirements;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Clause clause : this.getClauses()) {
            builder.append(clause).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static class Clause
    implements org.apache.aries.subsystem.core.archive.Clause {
        public static final String ATTRIBUTE_DEPLOYEDVERSION = "deployed-version";
        public static final String ATTRIBUTE_RESOURCEID = "resourceId";
        public static final String ATTRIBUTE_TYPE = "type";
        public static final String DIRECTIVE_REFERENCE = "reference";
        public static final String DIRECTIVE_STARTORDER = "start-order";
        private static final Pattern PATTERN_SYMBOLICNAME = Pattern.compile("((?:[0-9]|[A-Za-z]|_|-)+(?:\\.(?:[0-9]|[A-Za-z]|_|-)+)*)(?=;|\\z)");
        private static final Pattern PATTERN_PARAMETER = Pattern.compile("((?:(?:[0-9]|[A-Za-z]|_|-|\\.)+:=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))|(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\")))(?=;|\\z)");
        private final String path;
        private final Map<String, Parameter> parameters = new HashMap<String, Parameter>();

        private static void fillInDefaults(Map<String, Parameter> parameters) {
            Parameter parameter = parameters.get(ATTRIBUTE_TYPE);
            if (parameter == null) {
                parameters.put(ATTRIBUTE_TYPE, TypeAttribute.DEFAULT);
            }
            if ((parameter = parameters.get(DIRECTIVE_REFERENCE)) == null) {
                parameters.put(DIRECTIVE_REFERENCE, ReferenceDirective.TRUE);
            }
        }

        public Clause(String clause) {
            Matcher matcher = PATTERN_SYMBOLICNAME.matcher(clause);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Missing symbolic name path: " + clause);
            }
            this.path = matcher.group();
            matcher.usePattern(PATTERN_PARAMETER);
            while (matcher.find()) {
                Parameter parameter = ParameterFactory.create(matcher.group());
                this.parameters.put(parameter.getName(), parameter);
            }
            Clause.fillInDefaults(this.parameters);
        }

        public Clause(Resource resource) {
            this(resource, true);
        }

        public Clause(Resource resource, boolean referenced) {
            this(DeployedContentHeader.appendResource(resource, new StringBuilder(), referenced).toString());
        }

        public boolean contains(Resource resource) {
            return this.getSymbolicName().equals(ResourceHelper.getSymbolicNameAttribute(resource)) && this.getDeployedVersion().equals((Object)ResourceHelper.getVersionAttribute(resource)) && this.getType().equals(ResourceHelper.getTypeAttribute(resource));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Clause)) {
                return false;
            }
            Clause that = (Clause)o;
            return this.getSymbolicName().equals(that.getSymbolicName()) && this.getDeployedVersion().equals((Object)that.getDeployedVersion()) && this.getType().equals(that.getType());
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.getSymbolicName().hashCode();
            result = 31 * result + this.getDeployedVersion().hashCode();
            result = 31 * result + this.getType().hashCode();
            return result;
        }

        @Override
        public Attribute getAttribute(String name) {
            Parameter result = this.parameters.get(name);
            if (result instanceof Attribute) {
                return (Attribute)result;
            }
            return null;
        }

        @Override
        public Collection<Attribute> getAttributes() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Attribute)) continue;
                attributes.add((Attribute)parameter);
            }
            attributes.trimToSize();
            return attributes;
        }

        public Version getDeployedVersion() {
            return ((DeployedVersionAttribute)this.getAttribute(ATTRIBUTE_DEPLOYEDVERSION)).getVersion();
        }

        @Override
        public Directive getDirective(String name) {
            Parameter result = this.parameters.get(name);
            if (result instanceof Directive) {
                return (Directive)result;
            }
            return null;
        }

        @Override
        public Collection<Directive> getDirectives() {
            ArrayList<Directive> directives = new ArrayList<Directive>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Directive)) continue;
                directives.add((Directive)parameter);
            }
            directives.trimToSize();
            return directives;
        }

        @Override
        public Parameter getParameter(String name) {
            return this.parameters.get(name);
        }

        @Override
        public Collection<Parameter> getParameters() {
            return Collections.unmodifiableCollection(this.parameters.values());
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public String getSymbolicName() {
            return this.path;
        }

        public int getStartOrder() {
            return ((StartOrderDirective)((Object)this.getAttribute(DIRECTIVE_STARTORDER))).getStartOrder();
        }

        public String getType() {
            return ((TypeAttribute)this.getAttribute(ATTRIBUTE_TYPE)).getType();
        }

        public boolean isReferenced() {
            return ((ReferenceDirective)this.getDirective(DIRECTIVE_REFERENCE)).isReferenced();
        }

        public DeployedContentRequirement toRequirement(Resource resource) {
            return new DeployedContentRequirement(this, resource);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.getPath());
            for (Parameter parameter : this.getParameters()) {
                builder.append(';').append(parameter);
            }
            return builder.toString();
        }
    }
}

