/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.ClauseTokenizer;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.ImportPackageRequirement;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.ParameterFactory;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.apache.aries.subsystem.core.archive.VersionAttribute;
import org.apache.aries.subsystem.core.archive.VersionRangeAttribute;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class ImportPackageHeader
implements RequirementHeader<Clause> {
    public static final String ATTRIBUTE_BUNDLE_SYMBOLICNAME = "bundle-symbolic-name";
    public static final String ATTRIBUTE_BUNDLE_VERSION = "bundle-version";
    public static final String ATTRIBUTE_VERSION = "version";
    public static final String NAME = "Import-Package";
    public static final String DIRECTIVE_RESOLUTION = "resolution";
    public static final String RESOLUTION_MANDATORY = "mandatory";
    public static final String RESOLUTION_OPTIONAL = "optional";
    private final Set<Clause> clauses;

    private static Collection<Clause> processHeader(String header) {
        HashSet<Clause> clauses = new HashSet<Clause>();
        for (String clause : new ClauseTokenizer(header).getClauses()) {
            clauses.add(new Clause(clause));
        }
        return clauses;
    }

    public ImportPackageHeader(Collection<Clause> clauses) {
        if (clauses.isEmpty()) {
            throw new IllegalArgumentException("An Import-Package header must have at least one clause");
        }
        this.clauses = new HashSet<Clause>(clauses);
    }

    public ImportPackageHeader(String header) {
        this(ImportPackageHeader.processHeader(header));
    }

    @Override
    public Collection<Clause> getClauses() {
        return Collections.unmodifiableSet(this.clauses);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<ImportPackageRequirement> toRequirements(Resource resource) {
        Collection<Clause> clauses = this.getClauses();
        ArrayList<ImportPackageRequirement> result = new ArrayList<ImportPackageRequirement>(clauses.size());
        for (Clause clause : clauses) {
            result.add(clause.toRequirement(resource));
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Clause clause : this.getClauses()) {
            builder.append(clause).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static class Clause
    implements org.apache.aries.subsystem.core.archive.Clause {
        private static final String REGEX = "\\((osgi.wiring.package)(=)([^\\)]+)\\)";
        private static final String REGEX1 = "(\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*(?:\\.\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*)*\\s*(?:\\;\\s*\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*(?:\\.\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*)*)*)(?=;|\\z)";
        private static final String REGEX2 = "((?:(?:[0-9]|[A-Za-z]|_|-|\\.)+:=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))|(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\")))(?=;|\\z)";
        private static final Pattern PATTERN = Pattern.compile("\\((osgi.wiring.package)(=)([^\\)]+)\\)");
        private static final Pattern PATTERN1 = Pattern.compile("(\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*(?:\\.\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*)*\\s*(?:\\;\\s*\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*(?:\\.\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*)*)*)(?=;|\\z)");
        private static final Pattern PATTERN2 = Pattern.compile("((?:(?:[0-9]|[A-Za-z]|_|-|\\.)+:=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))|(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\")))(?=;|\\z)");
        private final Map<String, Parameter> myParameters = new HashMap<String, Parameter>();
        private final String myPath;

        private static void fillInDefaults(Map<String, Parameter> parameters) {
            Parameter parameter = parameters.get(ImportPackageHeader.ATTRIBUTE_VERSION);
            if (parameter == null) {
                parameters.put(ImportPackageHeader.ATTRIBUTE_VERSION, new VersionRangeAttribute());
            }
        }

        public Clause(Requirement requirement) {
            if (!"osgi.wiring.package".equals(requirement.getNamespace())) {
                throw new IllegalArgumentException("Requirement must be in the 'osgi.wiring.package' namespace");
            }
            String filter = (String)requirement.getDirectives().get("filter");
            String packageName = null;
            Matcher matcher = PATTERN.matcher(filter);
            while (matcher.find()) {
                String name = matcher.group(1);
                String operator = matcher.group(2);
                String value = matcher.group(3);
                if ("osgi.wiring.package".equals(name)) {
                    packageName = value;
                    continue;
                }
                if (!ImportPackageHeader.ATTRIBUTE_VERSION.equals(name)) continue;
            }
            if (packageName == null) {
                throw new IllegalArgumentException("Missing filter key: osgi.wiring.package");
            }
            this.myPath = packageName;
        }

        public Clause(String clause) {
            Matcher matcher = PATTERN1.matcher(clause);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Invalid Import-Package header clause: " + clause);
            }
            this.myPath = matcher.group().replaceAll("\\s", "");
            matcher.usePattern(PATTERN2);
            while (matcher.find()) {
                Parameter parameter = ParameterFactory.create(matcher.group());
                if (parameter instanceof VersionAttribute) {
                    parameter = new VersionRangeAttribute(String.valueOf(parameter.getValue()));
                }
                this.myParameters.put(parameter.getName(), parameter);
            }
            Clause.fillInDefaults(this.myParameters);
        }

        @Override
        public Attribute getAttribute(String name) {
            Parameter result = this.myParameters.get(name);
            if (result instanceof Attribute) {
                return (Attribute)result;
            }
            return null;
        }

        @Override
        public Collection<Attribute> getAttributes() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.myParameters.size());
            for (Parameter parameter : this.myParameters.values()) {
                if (!(parameter instanceof Attribute)) continue;
                attributes.add((Attribute)parameter);
            }
            attributes.trimToSize();
            return attributes;
        }

        @Override
        public Directive getDirective(String name) {
            Parameter result = this.myParameters.get(name);
            if (result instanceof Directive) {
                return (Directive)result;
            }
            return null;
        }

        @Override
        public Collection<Directive> getDirectives() {
            ArrayList<Directive> directives = new ArrayList<Directive>(this.myParameters.size());
            for (Parameter parameter : this.myParameters.values()) {
                if (!(parameter instanceof Directive)) continue;
                directives.add((Directive)parameter);
            }
            directives.trimToSize();
            return directives;
        }

        public Collection<String> getPackageNames() {
            return Arrays.asList(this.myPath.split(";"));
        }

        @Override
        public Parameter getParameter(String name) {
            return this.myParameters.get(name);
        }

        @Override
        public Collection<Parameter> getParameters() {
            return Collections.unmodifiableCollection(this.myParameters.values());
        }

        @Override
        public String getPath() {
            return this.myPath;
        }

        public VersionRangeAttribute getVersionRangeAttribute() {
            return (VersionRangeAttribute)this.myParameters.get(ImportPackageHeader.ATTRIBUTE_VERSION);
        }

        public ImportPackageRequirement toRequirement(Resource resource) {
            return new ImportPackageRequirement(this, resource);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.getPath());
            for (Parameter parameter : this.getParameters()) {
                builder.append(';').append(parameter);
            }
            return builder.toString();
        }
    }
}

