/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import java.lang.reflect.Method;
import java.util.Optional;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.aries.blueprint.Interceptor;
import org.apache.aries.transaction.ComponentTxData;
import org.apache.aries.transaction.TransactionAttribute;
import org.apache.aries.transaction.TransactionToken;
import org.apache.aries.transaction.TransactionalAnnotationAttributes;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Coordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxInterceptorImpl
implements Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxInterceptorImpl.class);
    private TransactionManager tm;
    private Coordinator coordinator;
    private ComponentTxData txData;

    public TxInterceptorImpl(TransactionManager tm, Coordinator coordinator, ComponentTxData txData) {
        this.tm = tm;
        this.coordinator = coordinator;
        this.txData = txData;
    }

    public int getRank() {
        return 1;
    }

    public Object preCall(ComponentMetadata cm, Method m, Object ... parameters) throws Throwable {
        Optional<TransactionalAnnotationAttributes> type = this.txData.getEffectiveType(m);
        if (!type.isPresent()) {
            return null;
        }
        TransactionAttribute txAttribute = TransactionAttribute.fromValue(type.get().getTxType());
        LOGGER.debug("PreCall for bean {}, method {} with tx strategy {}.", new Object[]{TxInterceptorImpl.getCmId(cm), m.getName(), txAttribute});
        TransactionToken token = txAttribute.begin(this.tm);
        boolean requiresNewCoordination = token.requiresNewCoordination();
        if (!requiresNewCoordination && !this.transactionExists(this.coordinator) && token.getActiveTransaction() != null && this.tm.getStatus() == 0) {
            requiresNewCoordination = true;
        }
        if (requiresNewCoordination) {
            String coordName = "txInterceptor." + m.getDeclaringClass().getName() + "." + m.getName();
            Coordination coord = this.coordinator.begin(coordName, 0L);
            coord.getVariables().put(Transaction.class, txAttribute.name());
            token.setCoordination(coord);
        }
        return token;
    }

    private boolean transactionExists(Coordinator coordinator) {
        boolean exists = false;
        for (Coordination coord = coordinator.peek(); coord != null; coord = coord.getEnclosingCoordination()) {
            if (!coord.getVariables().containsKey(Transaction.class)) continue;
            return true;
        }
        return exists;
    }

    public void postCallWithException(ComponentMetadata cm, Method m, Throwable ex, Object preCallToken) {
        if (!(preCallToken instanceof TransactionToken)) {
            return;
        }
        LOGGER.debug("PostCallWithException for bean {}, method {}.", new Object[]{TxInterceptorImpl.getCmId(cm), m.getName(), ex});
        TransactionToken token = (TransactionToken)preCallToken;
        this.safeEndCoordination(token);
        try {
            Transaction tran = token.getActiveTransaction();
            if (tran != null && this.isRollBackException(ex, m)) {
                tran.setRollbackOnly();
                LOGGER.debug("Setting transaction to rollback only because of exception ", ex);
            }
            token.getTransactionAttribute().finish(this.tm, token);
        }
        catch (Exception e) {
            LOGGER.warn("Exception during transaction cleanup", (Throwable)e);
        }
    }

    public void postCallWithReturn(ComponentMetadata cm, Method m, Object returnType, Object preCallToken) throws Exception {
        LOGGER.debug("PostCallWithReturn for bean {}, method {}.", (Object)TxInterceptorImpl.getCmId(cm), (Object)m);
        if (preCallToken == null) {
            return;
        }
        if (!(preCallToken instanceof TransactionToken)) {
            throw new IllegalStateException("Expected a TransactionToken from preCall but got " + preCallToken);
        }
        TransactionToken token = (TransactionToken)preCallToken;
        this.safeEndCoordination(token);
        try {
            token.getTransactionAttribute().finish(this.tm, token);
        }
        catch (Exception e) {
            LOGGER.debug("Exception while completing transaction.", (Throwable)e);
            RollbackException rbe = new RollbackException();
            rbe.addSuppressed((Throwable)e);
            throw rbe;
        }
    }

    private void safeEndCoordination(TransactionToken token) {
        try {
            if (token != null && token.getCoordination() != null) {
                token.getCoordination().end();
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    private static String getCmId(ComponentMetadata cm) {
        return cm == null ? null : cm.getId();
    }

    private boolean isRollBackException(Throwable ex, Method m) {
        if (m != null) {
            Optional<TransactionalAnnotationAttributes> effectiveType = this.txData.getEffectiveType(m);
            if (!effectiveType.isPresent()) {
                return TxInterceptorImpl.isUncheckedException(ex);
            }
            for (Class dontRollbackClass : effectiveType.get().getDontRollbackOn()) {
                if (!dontRollbackClass.isInstance(ex)) continue;
                LOGGER.debug("Current exception {} found in element dontRollbackOn.", ex.getClass());
                return false;
            }
            if (TxInterceptorImpl.isUncheckedException(ex)) {
                return true;
            }
            for (Class rollbackExceptionClass : effectiveType.get().getRollbackOn()) {
                if (!rollbackExceptionClass.isInstance(ex)) continue;
                LOGGER.debug("Current exception {} found in element rollbackOn.", ex.getClass());
                return true;
            }
        } else {
            return TxInterceptorImpl.isUncheckedException(ex);
        }
        return false;
    }

    private static boolean isUncheckedException(Throwable ex) {
        return ex instanceof RuntimeException || ex instanceof Error;
    }
}

