/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ReplicationException;
import org.apache.asterix.common.replication.IPartitionReplica;
import org.apache.asterix.common.storage.ReplicaIdentifier;
import org.apache.asterix.replication.management.NetworkingUtil;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.asterix.replication.sync.ReplicaSynchronizer;
import org.apache.hyracks.api.network.ISocketChannel;
import org.apache.hyracks.util.NetworkUtil;
import org.apache.hyracks.util.StorageUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartitionReplica
implements IPartitionReplica {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int INITIAL_BUFFER_SIZE = StorageUtil.getIntSizeInBytes((int)4, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE);
    private final INcApplicationContext appCtx;
    private final ReplicaIdentifier id;
    private ByteBuffer reusbaleBuf;
    private IPartitionReplica.PartitionReplicaStatus status = IPartitionReplica.PartitionReplicaStatus.DISCONNECTED;
    private ISocketChannel sc;

    public PartitionReplica(ReplicaIdentifier id, INcApplicationContext appCtx) {
        this.id = id;
        this.appCtx = appCtx;
    }

    public synchronized IPartitionReplica.PartitionReplicaStatus getStatus() {
        return this.status;
    }

    public ReplicaIdentifier getIdentifier() {
        return this.id;
    }

    public synchronized void notifyFailure(Exception failure) {
        this.setStatus(IPartitionReplica.PartitionReplicaStatus.DISCONNECTED);
    }

    public synchronized void sync() {
        if (this.status == IPartitionReplica.PartitionReplicaStatus.IN_SYNC || this.status == IPartitionReplica.PartitionReplicaStatus.CATCHING_UP) {
            return;
        }
        this.setStatus(IPartitionReplica.PartitionReplicaStatus.CATCHING_UP);
        this.appCtx.getThreadExecutor().execute(() -> {
            try {
                new ReplicaSynchronizer(this.appCtx, this).sync();
                this.setStatus(IPartitionReplica.PartitionReplicaStatus.IN_SYNC);
            }
            catch (Exception e) {
                LOGGER.error(() -> "Failed to sync replica " + this, (Throwable)e);
                this.notifyFailure(e);
            }
            finally {
                this.close();
            }
        });
    }

    public synchronized ISocketChannel getChannel() {
        try {
            if (!NetworkingUtil.isHealthy(this.sc)) {
                this.establishReplicaConnection();
            }
            return this.sc;
        }
        catch (IOException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    private void establishReplicaConnection() throws IOException {
        this.sc = ReplicationProtocol.establishReplicaConnection(this.appCtx, this.id.refreshLocation());
    }

    public synchronized void close() {
        try {
            if (NetworkingUtil.isHealthy(this.sc)) {
                this.sendGoodBye();
            }
            NetworkUtil.closeQuietly((Closeable)this.sc);
        }
        finally {
            this.sc = null;
        }
    }

    public synchronized ByteBuffer getReusableBuffer() {
        if (this.reusbaleBuf == null) {
            this.reusbaleBuf = ByteBuffer.allocate(INITIAL_BUFFER_SIZE);
        }
        return this.reusbaleBuf;
    }

    private JsonNode asJson() {
        ObjectNode json = OBJECT_MAPPER.createObjectNode();
        json.put("id", this.id.toString());
        json.put("status", this.status.name());
        return json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionReplica that = (PartitionReplica)o;
        return this.id.equals((Object)that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this.asJson());
        }
        catch (JsonProcessingException e) {
            throw new ReplicationException((Throwable)e);
        }
    }

    private synchronized void setStatus(IPartitionReplica.PartitionReplicaStatus status) {
        if (this.status == status) {
            return;
        }
        LOGGER.info(() -> "Replica " + this + " status changing: " + this.status + " -> " + status);
        this.status = status;
    }

    private void sendGoodBye() {
        try {
            ReplicationProtocol.sendGoodbye(this.sc);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to send good bye to {}", (Object)this, (Object)e);
        }
    }
}

