/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADate;
import org.apache.asterix.om.base.AMutableDate;
import org.apache.asterix.om.base.temporal.ADateParserFactory;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class ADateConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new ADateConstructorDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable inputArg = new VoidPointable();
                    private IScalarEvaluator eval;
                    private AMutableDate aDate;
                    private ISerializerDeserializer<ADate> dateSerde;
                    private final UTF8StringPointable utf8Ptr;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.aDate = new AMutableDate(0);
                        this.dateSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATE);
                        this.utf8Ptr = new UTF8StringPointable();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        block9: {
                            try {
                                this.resultStorage.reset();
                                this.eval.evaluate(tuple, this.inputArg);
                                if (PointableHelper.checkAndSetMissingOrNull(result, this.inputArg)) {
                                    return;
                                }
                                byte[] serString = this.inputArg.getByteArray();
                                int offset = this.inputArg.getStartOffset();
                                int len = this.inputArg.getLength();
                                byte tt = serString[offset];
                                if (tt == ATypeTag.SERIALIZED_DATE_TYPE_TAG) {
                                    result.set((IValueReference)this.inputArg);
                                    break block9;
                                }
                                if (tt == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                    this.utf8Ptr.set(serString, offset + 1, len - 1);
                                    int stringLength = this.utf8Ptr.getUTF8Length();
                                    if (stringLength < 8) {
                                        throw new InvalidDataFormatException(ADateConstructorDescriptor.this.sourceLoc, ADateConstructorDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_DATE_TYPE_TAG);
                                    }
                                    int startOffset = this.utf8Ptr.getCharStartOffset();
                                    while (serString[startOffset] == 32) {
                                        ++startOffset;
                                    }
                                    int endOffset = startOffset + stringLength - 1;
                                    while (serString[endOffset] == 32) {
                                        --endOffset;
                                    }
                                    long chrononTimeInMs = ADateParserFactory.parseDatePart((byte[])serString, (int)startOffset, (int)(endOffset - startOffset + 1));
                                    int temp = 0;
                                    if (chrononTimeInMs < 0L && chrononTimeInMs % 86400000L != 0L) {
                                        temp = 1;
                                    }
                                    this.aDate.setValue((int)(chrononTimeInMs / 86400000L) - temp);
                                    this.dateSerde.serialize((Object)this.aDate, this.out);
                                    result.set((IValueReference)this.resultStorage);
                                    break block9;
                                }
                                throw new TypeMismatchException(ADateConstructorDescriptor.this.sourceLoc, ADateConstructorDescriptor.this.getIdentifier(), 0, tt, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            }
                            catch (IOException e) {
                                throw new InvalidDataFormatException(ADateConstructorDescriptor.this.sourceLoc, ADateConstructorDescriptor.this.getIdentifier(), e, ATypeTag.SERIALIZED_DATE_TYPE_TAG);
                            }
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.DATE_CONSTRUCTOR;
    }
}

