/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.APointSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutablePoint;
import org.apache.asterix.om.base.AMutableRectangle;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.base.ARectangle;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class SpatialCellDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new SpatialCellDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IPointable inputArg0 = new VoidPointable();
                    private final IPointable inputArg1 = new VoidPointable();
                    private final IPointable inputArg2 = new VoidPointable();
                    private final IPointable inputArg3 = new VoidPointable();
                    private final IScalarEvaluator eval0;
                    private final IScalarEvaluator eval1;
                    private final IScalarEvaluator eval2;
                    private final IScalarEvaluator eval3;
                    private final AMutableRectangle aRectangle;
                    private final AMutablePoint[] aPoint;
                    private final ISerializerDeserializer<ARectangle> rectangleSerde;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.eval1 = args[1].createScalarEvaluator(ctx);
                        this.eval2 = args[2].createScalarEvaluator(ctx);
                        this.eval3 = args[3].createScalarEvaluator(ctx);
                        this.aRectangle = new AMutableRectangle(null, null);
                        this.aPoint = new AMutablePoint[]{new AMutablePoint(0.0, 0.0), new AMutablePoint(0.0, 0.0)};
                        this.rectangleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ARECTANGLE);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.eval0.evaluate(tuple, this.inputArg0);
                        this.eval1.evaluate(tuple, this.inputArg1);
                        this.eval2.evaluate(tuple, this.inputArg2);
                        this.eval3.evaluate(tuple, this.inputArg3);
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.inputArg0, this.inputArg1, this.inputArg2, this.inputArg3)) {
                            return;
                        }
                        byte[] bytes0 = this.inputArg0.getByteArray();
                        byte[] bytes1 = this.inputArg1.getByteArray();
                        byte[] bytes2 = this.inputArg2.getByteArray();
                        byte[] bytes3 = this.inputArg3.getByteArray();
                        int offset0 = this.inputArg0.getStartOffset();
                        int offset1 = this.inputArg1.getStartOffset();
                        int offset2 = this.inputArg2.getStartOffset();
                        int offset3 = this.inputArg3.getStartOffset();
                        try {
                            byte tag0 = bytes0[offset0];
                            byte tag1 = bytes1[offset1];
                            byte tag2 = bytes2[offset2];
                            byte tag3 = bytes3[offset3];
                            if (tag0 == ATypeTag.SERIALIZED_POINT_TYPE_TAG && tag1 == ATypeTag.SERIALIZED_POINT_TYPE_TAG && tag2 == ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG && tag3 == ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG) {
                                double xLoc = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.X)));
                                double yLoc = ADoubleSerializerDeserializer.getDouble((byte[])bytes0, (int)(offset0 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.Y)));
                                double xOrigin = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.X)));
                                double yOrigin = ADoubleSerializerDeserializer.getDouble((byte[])bytes1, (int)(offset1 + 1 + APointSerializerDeserializer.getCoordinateOffset((Coordinate)Coordinate.Y)));
                                double xInc = ADoubleSerializerDeserializer.getDouble((byte[])bytes2, (int)(offset2 + 1));
                                double yInc = ADoubleSerializerDeserializer.getDouble((byte[])bytes3, (int)(offset3 + 1));
                                double x = xOrigin + Math.floor((xLoc - xOrigin) / xInc) * xInc;
                                double y = yOrigin + Math.floor((yLoc - yOrigin) / yInc) * yInc;
                                this.aPoint[0].setValue(x, y);
                                this.aPoint[1].setValue(x + xInc, y + yInc);
                                this.aRectangle.setValue((APoint)this.aPoint[0], (APoint)this.aPoint[1]);
                                this.rectangleSerde.serialize((Object)this.aRectangle, this.out);
                            } else {
                                if (tag0 != ATypeTag.SERIALIZED_POINT_TYPE_TAG) {
                                    throw new TypeMismatchException(SpatialCellDescriptor.this.sourceLoc, SpatialCellDescriptor.this.getIdentifier(), 0, tag0, ATypeTag.SERIALIZED_POINT_TYPE_TAG);
                                }
                                if (tag1 != ATypeTag.SERIALIZED_POINT_TYPE_TAG) {
                                    throw new TypeMismatchException(SpatialCellDescriptor.this.sourceLoc, SpatialCellDescriptor.this.getIdentifier(), 1, tag1, ATypeTag.SERIALIZED_POINT_TYPE_TAG);
                                }
                                if (tag2 != ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG) {
                                    throw new TypeMismatchException(SpatialCellDescriptor.this.sourceLoc, SpatialCellDescriptor.this.getIdentifier(), 2, tag2, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
                                }
                                if (tag3 != ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG) {
                                    throw new TypeMismatchException(SpatialCellDescriptor.this.sourceLoc, SpatialCellDescriptor.this.getIdentifier(), 3, tag3, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
                                }
                            }
                            result.set((IValueReference)this.resultStorage);
                        }
                        catch (IOException e1) {
                            throw HyracksDataException.create((Throwable)e1);
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.SPATIAL_CELL;
    }
}

