/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.AbstractBinaryStringEval;
import org.apache.asterix.runtime.evaluators.functions.utils.RegExpMatcher;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.data.std.util.UTF8StringBuilder;

@MissingNullInOutFunction
public class StringRegExpMatchesDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = StringRegExpMatchesDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new AbstractBinaryStringEval(ctx, args[0], args[1], StringRegExpMatchesDescriptor.this.getIdentifier(), StringRegExpMatchesDescriptor.this.sourceLoc){
                    private final RegExpMatcher matcher;
                    private final UTF8StringBuilder stringBuilder;
                    private final GrowableArray stringBuilderArray;
                    private final IAsterixListBuilder listBuilder;
                    private final AbstractCollectionType collectionType;
                    {
                        this.matcher = new RegExpMatcher();
                        this.stringBuilder = new UTF8StringBuilder();
                        this.stringBuilderArray = new GrowableArray();
                        this.listBuilder = new OrderedListBuilder();
                        this.collectionType = new AOrderedListType((IAType)BuiltinType.ASTRING, BuiltinType.ASTRING.getTypeName());
                    }

                    @Override
                    protected void process(UTF8StringPointable srcPtr, UTF8StringPointable patternPtr, IPointable result) throws HyracksDataException {
                        this.matcher.build(srcPtr, patternPtr);
                        this.listBuilder.reset(this.collectionType);
                        try {
                            while (this.matcher.find()) {
                                String match = this.matcher.group();
                                this.stringBuilderArray.reset();
                                this.stringBuilder.reset(this.stringBuilderArray, match.length() + 1);
                                this.stringBuilder.appendString((CharSequence)match);
                                this.stringBuilder.finish();
                                this.resultStorage.reset();
                                this.dataOutput.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                                this.dataOutput.write(this.stringBuilderArray.getByteArray(), 0, this.stringBuilderArray.getLength());
                                this.listBuilder.addItem((IValueReference)this.resultStorage);
                            }
                            this.resultStorage.reset();
                            this.listBuilder.write(this.dataOutput, true);
                            result.set((IValueReference)this.resultStorage);
                        }
                        catch (IOException ex) {
                            throw HyracksDataException.create((Throwable)ex);
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.STRING_REGEXP_MATCHES;
    }
}

