/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.parquet.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapacityByteArrayOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(CapacityByteArrayOutputStream.class);
    private static final byte[] EMPTY_SLAB = new byte[0];
    private int initialSlabSize;
    private final int maxCapacityHint;
    private final List<byte[]> slabs = new ArrayList<byte[]>();
    private byte[] currentSlab;
    private int currentSlabIndex;
    private int bytesAllocated = 0;
    private int bytesUsed = 0;

    public static int initialSlabSizeHeuristic(int minSlabSize, int targetCapacity, int targetNumSlabs) {
        return Math.max(minSlabSize, (int)((double)targetCapacity / Math.pow(2.0, targetNumSlabs)));
    }

    public static CapacityByteArrayOutputStream withTargetNumSlabs(int minSlabSize, int maxCapacityHint, int targetNumSlabs) {
        return new CapacityByteArrayOutputStream(CapacityByteArrayOutputStream.initialSlabSizeHeuristic(minSlabSize, maxCapacityHint, targetNumSlabs), maxCapacityHint);
    }

    @Deprecated
    public CapacityByteArrayOutputStream(int initialSlabSize) {
        this(initialSlabSize, 0x100000);
    }

    public CapacityByteArrayOutputStream(int initialSlabSize, int maxCapacityHint) {
        Preconditions.checkArgument((initialSlabSize > 0 ? 1 : 0) != 0, (String)"initialSlabSize must be > 0");
        Preconditions.checkArgument((maxCapacityHint > 0 ? 1 : 0) != 0, (String)"maxCapacityHint must be > 0");
        Preconditions.checkArgument((maxCapacityHint >= initialSlabSize ? 1 : 0) != 0, (String)String.format("maxCapacityHint can't be less than initialSlabSize %d %d", initialSlabSize, maxCapacityHint));
        this.initialSlabSize = initialSlabSize;
        this.maxCapacityHint = maxCapacityHint;
        this.reset();
    }

    private void addSlab(int minimumSize) {
        int nextSlabSize = this.bytesUsed == 0 ? this.initialSlabSize : (this.bytesUsed > this.maxCapacityHint / 5 ? this.maxCapacityHint / 5 : this.bytesUsed);
        if (nextSlabSize < minimumSize) {
            LOG.debug("slab size {} too small for value of size {}. Bumping up slab size", (Object)nextSlabSize, (Object)minimumSize);
            nextSlabSize = minimumSize;
        }
        LOG.debug("used {} slabs, adding new slab of size {}", (Object)this.slabs.size(), (Object)nextSlabSize);
        this.currentSlab = new byte[nextSlabSize];
        this.slabs.add(this.currentSlab);
        this.bytesAllocated += nextSlabSize;
        this.currentSlabIndex = 0;
    }

    @Override
    public void write(int b) {
        if (this.currentSlabIndex == this.currentSlab.length) {
            this.addSlab(1);
        }
        this.currentSlab[this.currentSlabIndex] = (byte)b;
        ++this.currentSlabIndex;
        ++this.bytesUsed;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException(String.format("Given byte array of size %d, with requested length(%d) and offset(%d)", b.length, len, off));
        }
        if (this.currentSlabIndex + len >= this.currentSlab.length) {
            int length1 = this.currentSlab.length - this.currentSlabIndex;
            System.arraycopy(b, off, this.currentSlab, this.currentSlabIndex, length1);
            int length2 = len - length1;
            this.addSlab(length2);
            System.arraycopy(b, off + length1, this.currentSlab, this.currentSlabIndex, length2);
            this.currentSlabIndex = length2;
        } else {
            System.arraycopy(b, off, this.currentSlab, this.currentSlabIndex, len);
            this.currentSlabIndex += len;
        }
        this.bytesUsed += len;
    }

    public void writeTo(OutputStream out) throws IOException {
        for (int i = 0; i < this.slabs.size() - 1; ++i) {
            byte[] slab = this.slabs.get(i);
            out.write(slab);
        }
        out.write(this.currentSlab, 0, this.currentSlabIndex);
    }

    public long size() {
        return this.bytesUsed;
    }

    public int getCapacity() {
        return this.bytesAllocated;
    }

    public void reset() {
        this.initialSlabSize = Math.max(this.bytesUsed / 7, this.initialSlabSize);
        LOG.debug("initial slab of size {}", (Object)this.initialSlabSize);
        this.slabs.clear();
        this.bytesAllocated = 0;
        this.bytesUsed = 0;
        this.currentSlab = EMPTY_SLAB;
        this.currentSlabIndex = 0;
    }

    public long getCurrentIndex() {
        Preconditions.checkArgument((this.bytesUsed > 0 ? 1 : 0) != 0, (String)"This is an empty stream");
        return this.bytesUsed - 1;
    }

    public void setByte(long index, byte value) {
        Preconditions.checkArgument((index < (long)this.bytesUsed ? 1 : 0) != 0, (String)("Index: " + index + " is >= the current size of: " + this.bytesUsed));
        long seen = 0L;
        for (int i = 0; i < this.slabs.size(); ++i) {
            byte[] slab = this.slabs.get(i);
            if (index < seen + (long)slab.length) {
                slab[(int)(index - seen)] = value;
                break;
            }
            seen += (long)slab.length;
        }
    }

    public String memUsageString(String prefix) {
        return String.format("%s %s %d slabs, %,d bytes", prefix, this.getClass().getSimpleName(), this.slabs.size(), this.getCapacity());
    }

    int getSlabCount() {
        return this.slabs.size();
    }
}

