/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorNodePushable;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;

abstract class AbstractLibraryOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    protected final DataverseName dataverseName;
    protected final String libraryName;

    public AbstractLibraryOperatorDescriptor(IOperatorDescriptorRegistry spec, DataverseName dataverseName, String libraryName) {
        super(spec, 0, 0);
        this.dataverseName = dataverseName;
        this.libraryName = libraryName;
    }

    protected abstract class AbstractLibraryNodePushable
    extends AbstractOperatorNodePushable {
        protected final IHyracksTaskContext ctx;
        protected IIOManager ioManager;
        protected ILibraryManager libraryManager;
        private FileReference libraryDir;

        protected AbstractLibraryNodePushable(IHyracksTaskContext ctx) {
            this.ctx = ctx;
        }

        protected abstract void execute() throws IOException;

        public final void initialize() throws HyracksDataException {
            INcApplicationContext runtimeCtx = (INcApplicationContext)this.ctx.getJobletContext().getServiceContext().getApplicationContext();
            this.ioManager = runtimeCtx.getIoManager();
            this.libraryManager = runtimeCtx.getLibraryManager();
            this.libraryDir = this.libraryManager.getLibraryDir(AbstractLibraryOperatorDescriptor.this.dataverseName, AbstractLibraryOperatorDescriptor.this.libraryName);
            try {
                this.execute();
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }

        protected FileReference getLibraryDir() {
            return this.libraryDir;
        }

        protected FileReference getRev0Dir() {
            return this.libraryDir.getChild("rev_0");
        }

        protected FileReference getRev1Dir() {
            return this.libraryDir.getChild("rev_1");
        }

        protected FileReference getStageDir() {
            return this.libraryDir.getChild("stage");
        }

        protected void dropIfExists(FileReference fileRef) throws HyracksDataException {
            if (fileRef.getFile().exists()) {
                this.libraryManager.dropLibraryPath(fileRef);
            }
        }

        protected void move(FileReference src, FileReference dest) throws IOException {
            this.dropIfExists(dest);
            Files.move(src.getFile().toPath(), dest.getFile().toPath(), StandardCopyOption.ATOMIC_MOVE);
        }

        protected void mkdir(FileReference dir) throws IOException {
            Files.createDirectory(dir.getFile().toPath(), new FileAttribute[0]);
        }

        protected void flushDirectory(FileReference dir) throws IOException {
            this.flushDirectory(dir.getFile());
        }

        protected void flushDirectory(File dir) throws IOException {
            IoUtil.flushDirectory((File)dir);
        }

        protected void flushDirectory(Path dir) throws IOException {
            IoUtil.flushDirectory((Path)dir);
        }

        protected void closeLibrary() throws HyracksDataException {
            this.libraryManager.closeLibrary(AbstractLibraryOperatorDescriptor.this.dataverseName, AbstractLibraryOperatorDescriptor.this.libraryName);
        }

        public final void deinitialize() {
        }

        public final int getInputArity() {
            return 0;
        }

        public final void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) {
        }

        public IFrameWriter getInputFrameWriter(int index) {
            return null;
        }
    }
}

