/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class ADayTimeDuration
implements IAObject {
    protected long chrononInMillisecond;

    public ADayTimeDuration(long millisecond) {
        this.chrononInMillisecond = millisecond;
    }

    public long getMilliseconds() {
        return this.chrononInMillisecond;
    }

    public String toString() {
        StringBuilder sbder = new StringBuilder();
        sbder.append("day_time_duration: {");
        GregorianCalendarSystem.getInstance().getDurationExtendStringRepWithTimezoneUntilField(this.chrononInMillisecond, 0, sbder);
        sbder.append(" }");
        return sbder.toString();
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        ObjectNode duration = om.createObjectNode();
        duration.put("milliseconds", this.chrononInMillisecond);
        json.set("ADuration", (JsonNode)duration);
        return json;
    }

    @Override
    public IAType getType() {
        return BuiltinType.ADAYTIMEDURATION;
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return this.equals(obj);
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ADayTimeDuration) {
            return ((ADayTimeDuration)o).chrononInMillisecond == this.chrononInMillisecond;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.chrononInMillisecond ^ this.chrononInMillisecond >>> 32);
    }
}

