/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.types;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.annotations.IRecordTypeAnnotation;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractComplexType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public class ARecordType
extends AbstractComplexType {
    private static final long serialVersionUID = 1L;
    private static final JavaType SET = OBJECT_MAPPER.getTypeFactory().constructCollectionType(Set.class, String.class);
    private static final String IS_OPEN = "isOpen";
    private static final String FIELD_NAMES = "fieldNames";
    private static final String FIELD_TYPES = "fieldTypes";
    private static final String ADDITIONAL_FIELDS = "additionalFieldNames";
    private final String[] fieldNames;
    private final IAType[] fieldTypes;
    private final Map<String, Integer> fieldNameToIndexMap = new HashMap<String, Integer>();
    private final boolean isOpen;
    private final transient List<IRecordTypeAnnotation> annotations = new ArrayList<IRecordTypeAnnotation>();
    private final Set<String> allPossibleAdditionalFieldNames;

    public ARecordType(String typeName, String[] fieldNames, IAType[] fieldTypes, boolean isOpen) {
        this(typeName, fieldNames, fieldTypes, isOpen, null);
    }

    public ARecordType(String typeName, String[] fieldNames, IAType[] fieldTypes, boolean isOpen, Set<String> allPossibleAdditionalFieldNames) {
        super(typeName);
        this.fieldNames = fieldNames;
        this.fieldTypes = fieldTypes;
        this.isOpen = isOpen;
        for (int index = 0; index < fieldNames.length; ++index) {
            this.fieldNameToIndexMap.put(fieldNames[index], index);
        }
        this.allPossibleAdditionalFieldNames = allPossibleAdditionalFieldNames;
    }

    public boolean canContainField(String fieldName) {
        if (this.isOpen && this.allPossibleAdditionalFieldNames == null) {
            return true;
        }
        if (this.isOpen) {
            return this.fieldNameToIndexMap.containsKey(fieldName) || this.allPossibleAdditionalFieldNames.contains(fieldName);
        }
        return this.fieldNameToIndexMap.containsKey(fieldName);
    }

    public boolean knowsAllPossibleAdditonalFieldNames() {
        return this.allPossibleAdditionalFieldNames != null;
    }

    public Set<String> getAllPossibleAdditonalFieldNames() {
        return this.allPossibleAdditionalFieldNames;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public IAType[] getFieldTypes() {
        return this.fieldTypes;
    }

    public List<IRecordTypeAnnotation> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return this.append(new StringBuilder()).toString();
    }

    private StringBuilder append(StringBuilder sb) {
        if (this.typeName != null) {
            sb.append(this.typeName).append(": ");
        }
        sb.append(this.isOpen ? "open" : "closed");
        sb.append(" {\n");
        int n = this.fieldNames.length;
        for (int i = 0; i < n; ++i) {
            sb.append("  ").append(this.fieldNames[i]).append(": ").append(this.fieldTypes[i]);
            sb.append(i < n - 1 ? ",\n" : "\n");
        }
        return sb.append("}\n");
    }

    @Override
    public ATypeTag getTypeTag() {
        return ATypeTag.OBJECT;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public int getFieldIndex(String fieldName) {
        if (this.fieldNames == null) {
            return -1;
        }
        Integer index = this.fieldNameToIndexMap.get(fieldName);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public IAType getSubFieldType(List<String> subFieldName, IAType parent) {
        ARecordType subRecordType = (ARecordType)parent;
        for (int i = 0; i < subFieldName.size() - 1; ++i) {
            subRecordType = (ARecordType)subRecordType.getFieldType(subFieldName.get(i));
        }
        return subRecordType.getFieldType(subFieldName.get(subFieldName.size() - 1));
    }

    public IAType getSubFieldType(List<String> subFieldName) throws AlgebricksException {
        IAType subRecordType = this.getFieldType(subFieldName.get(0));
        for (int i = 1; i < subFieldName.size(); ++i) {
            if (subRecordType == null) {
                return null;
            }
            if (subRecordType.getTypeTag().equals(ATypeTag.UNION) && (subRecordType = ((AUnionType)subRecordType).getActualType()).getTypeTag() != ATypeTag.OBJECT) {
                throw new AsterixException("Field accessor is not defined for values of type " + subRecordType.getTypeTag());
            }
            subRecordType = ((ARecordType)subRecordType).getFieldType(subFieldName.get(i));
        }
        return subRecordType;
    }

    public boolean isSubFieldNullable(List<String> subFieldName) throws AlgebricksException {
        IAType subRecordType = this.getFieldType(subFieldName.get(0));
        for (int i = 1; i < subFieldName.size(); ++i) {
            if (subRecordType == null) {
                return true;
            }
            if (subRecordType.getTypeTag().equals(ATypeTag.UNION)) {
                if (NonTaggedFormatUtil.isOptional(subRecordType)) {
                    return true;
                }
                if ((subRecordType = ((AUnionType)subRecordType).getActualType()).getTypeTag() != ATypeTag.OBJECT) {
                    throw new AsterixException("Field accessor is not defined for values of type " + subRecordType.getTypeTag());
                }
            }
            if (!(subRecordType instanceof ARecordType)) {
                throw CompilationException.create((ErrorCode)ErrorCode.COMPILATION_ILLEGAL_STATE, (Serializable[])new Serializable[]{"Illegal field type " + subRecordType.getTypeTag() + " when checking field nullability"});
            }
            subRecordType = ((ARecordType)subRecordType).getFieldType(subFieldName.get(i));
        }
        return subRecordType == null || NonTaggedFormatUtil.isOptional(subRecordType);
    }

    public IAType getFieldType(String fieldName) {
        int fieldPos = this.getFieldIndex(fieldName);
        if (fieldPos < 0 || fieldPos >= this.fieldTypes.length) {
            return null;
        }
        return this.fieldTypes[fieldPos];
    }

    public boolean isClosedField(String fieldName) {
        return this.getFieldIndex(fieldName) != -1;
    }

    public boolean doesFieldExist(String fieldName) {
        for (String f : this.fieldNames) {
            if (f.compareTo(fieldName) != 0) continue;
            return true;
        }
        return false;
    }

    public ARecordType deepCopy(ARecordType type) {
        IAType[] newTypes = new IAType[type.fieldNames.length];
        for (int i = 0; i < type.fieldTypes.length; ++i) {
            newTypes[i] = type.fieldTypes[i].getTypeTag() == ATypeTag.OBJECT ? this.deepCopy((ARecordType)type.fieldTypes[i]) : type.fieldTypes[i];
        }
        return new ARecordType(type.typeName, type.fieldNames, newTypes, type.isOpen);
    }

    @Override
    public String getDisplayName() {
        return "object";
    }

    @Override
    public IAType getType() {
        return BuiltinType.ALL_TYPE;
    }

    @Override
    public void generateNestedDerivedTypeNames() {
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            IAType fieldType = this.fieldTypes[i];
            if (!fieldType.getTypeTag().isDerivedType() || fieldType.getTypeName() != null) continue;
            AbstractComplexType nestedType = (AbstractComplexType)fieldType;
            nestedType.setTypeName(this.getTypeName() + "_" + this.fieldNames[i]);
            nestedType.generateNestedDerivedTypeNames();
        }
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        if (!(obj instanceof ARecordType)) {
            return false;
        }
        ARecordType rt = (ARecordType)obj;
        return this.isOpen == rt.isOpen && Arrays.deepEquals(this.fieldNames, rt.fieldNames) && Arrays.deepEquals(this.fieldTypes, rt.fieldTypes);
    }

    @Override
    public int hash() {
        int i;
        int h = 0;
        for (i = 0; i < this.fieldNames.length; ++i) {
            h += 31 * h + this.fieldNames[i].hashCode();
        }
        for (i = 0; i < this.fieldTypes.length; ++i) {
            h += 31 * h + this.fieldTypes[i].hashCode();
        }
        return h;
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode type = om.createObjectNode();
        type.put("type", ARecordType.class.getName());
        type.put("name", this.typeName);
        if (this.isOpen) {
            type.put("open", true);
        } else {
            type.put("open", false);
        }
        ArrayNode fields = om.createArrayNode();
        for (int i = 0; i < this.fieldNames.length; ++i) {
            ObjectNode field = om.createObjectNode();
            field.set(this.fieldNames[i], (JsonNode)this.fieldTypes[i].toJSON());
            fields.add((JsonNode)field);
        }
        type.set("fields", (JsonNode)fields);
        return type;
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode jsonObject = registry.getClassIdentifier(this.getClass(), 1L);
        this.addToJson(jsonObject);
        jsonObject.put(IS_OPEN, this.isOpen);
        jsonObject.putPOJO(FIELD_NAMES, (Object)this.fieldNames);
        jsonObject.putPOJO(ADDITIONAL_FIELDS, this.allPossibleAdditionalFieldNames);
        ArrayNode fieldTypesArray = OBJECT_MAPPER.createArrayNode();
        for (int i = 0; i < this.fieldTypes.length; ++i) {
            fieldTypesArray.add(this.fieldTypes[i].toJson(registry));
        }
        jsonObject.set(FIELD_TYPES, (JsonNode)fieldTypesArray);
        return jsonObject;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        String typeName = json.get("typeName").asText();
        boolean isOpen = json.get(IS_OPEN).asBoolean();
        String[] fieldNames = (String[])OBJECT_MAPPER.convertValue((Object)json.get(FIELD_NAMES), String[].class);
        Set additionalFields = (Set)OBJECT_MAPPER.convertValue((Object)json.get(ADDITIONAL_FIELDS), SET);
        ArrayNode fieldTypesNode = (ArrayNode)json.get(FIELD_TYPES);
        IAType[] fieldTypes = new IAType[fieldTypesNode.size()];
        for (int i = 0; i < fieldTypesNode.size(); ++i) {
            fieldTypes[i] = (IAType)registry.deserialize(fieldTypesNode.get(i));
        }
        return new ARecordType(typeName, fieldNames, fieldTypes, isOpen, additionalFields);
    }

    public List<IAType> getFieldTypes(List<List<String>> fields) throws AlgebricksException {
        ArrayList<IAType> typeList = new ArrayList<IAType>();
        for (List<String> field : fields) {
            typeList.add(this.getSubFieldType(field));
        }
        return typeList;
    }

    @Override
    public boolean containsType(IAType type) {
        for (IAType aType : this.fieldTypes) {
            if (!aType.getTypeName().equals(type.getTypeName())) continue;
            return true;
        }
        return false;
    }
}

