/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.buffermanager;

import org.apache.hyracks.dataflow.std.buffermanager.IFrameFreeSlotPolicy;
import org.apache.hyracks.dataflow.std.structures.IResetableComparable;
import org.apache.hyracks.dataflow.std.structures.IResetableComparableFactory;
import org.apache.hyracks.dataflow.std.structures.MaxHeap;

class FrameFreeSlotBiggestFirst
implements IFrameFreeSlotPolicy {
    private static final int INVALID = -1;
    private static final int INITIAL_FRAME_NUM = 10;
    private MaxHeap heap;
    private SpaceEntry tempEntry;

    public FrameFreeSlotBiggestFirst(int initialCapacity) {
        this.heap = new MaxHeap(new SpaceEntryFactory(), initialCapacity);
        this.tempEntry = new SpaceEntry();
    }

    public FrameFreeSlotBiggestFirst() {
        this(10);
    }

    @Override
    public int popBestFit(int tobeInsertedSize) {
        if (!this.heap.isEmpty()) {
            this.heap.peekMax(this.tempEntry);
            if (this.tempEntry.space >= tobeInsertedSize) {
                this.heap.getMax(this.tempEntry);
                return this.tempEntry.id;
            }
        }
        return -1;
    }

    @Override
    public void pushNewFrame(int frameID, int freeSpace) {
        this.tempEntry.reset(freeSpace, frameID);
        this.heap.insert(this.tempEntry);
    }

    @Override
    public void reset() {
        this.heap.reset();
    }

    @Override
    public void close() {
        this.heap.reset();
    }

    protected class SpaceEntry
    implements IResetableComparable<SpaceEntry> {
        private int space = -1;
        private int id = -1;

        SpaceEntry() {
        }

        @Override
        public int compareTo(SpaceEntry o) {
            if (o.space != this.space) {
                if (o.space == -1) {
                    return 1;
                }
                if (this.space == -1) {
                    return -1;
                }
                return this.space < o.space ? -1 : 1;
            }
            return 0;
        }

        @Override
        public void reset(SpaceEntry other) {
            this.space = other.space;
            this.id = other.id;
        }

        void reset(int space, int id) {
            this.space = space;
            this.id = id;
        }
    }

    protected class SpaceEntryFactory
    implements IResetableComparableFactory {
        protected SpaceEntryFactory() {
        }

        public IResetableComparable createResetableComparable() {
            return new SpaceEntry();
        }
    }
}

