/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class DistinctOperator
extends AbstractLogicalOperator {
    private final List<Mutable<ILogicalExpression>> expressions;

    public DistinctOperator(List<Mutable<ILogicalExpression>> expressions) {
        this.expressions = expressions;
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.DISTINCT;
    }

    public List<Mutable<ILogicalExpression>> getExpressions() {
        return this.expressions;
    }

    @Override
    public void recomputeSchema() {
        this.schema = new ArrayList();
        this.schema.addAll(this.getDistinctByVarList());
        List<LogicalVariable> inputSchema = ((ILogicalOperator)((Mutable)this.inputs.get(0)).getValue()).getSchema();
        for (LogicalVariable var : inputSchema) {
            if (this.schema.contains(var)) continue;
            this.schema.add(var);
        }
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return new VariablePropagationPolicy(){

            @Override
            public void propagateVariables(IOperatorSchema target, IOperatorSchema ... sources) {
                for (LogicalVariable keyVar : DistinctOperator.this.getDistinctByVarList()) {
                    target.addVariable(keyVar);
                }
                for (IOperatorSchema srcSchema : sources) {
                    for (LogicalVariable srcVar : srcSchema) {
                        if (target.findVariable(srcVar) >= 0) continue;
                        target.addVariable(srcVar);
                    }
                }
            }
        };
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor) throws AlgebricksException {
        boolean changed = false;
        for (Mutable<ILogicalExpression> e : this.expressions) {
            if (!visitor.transform(e)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitDistinctOperator(this, arg);
    }

    @Override
    public boolean isMap() {
        return false;
    }

    public List<LogicalVariable> getDistinctByVarList() {
        ArrayList<LogicalVariable> varList = new ArrayList<LogicalVariable>(this.expressions.size());
        for (Mutable<ILogicalExpression> eRef : this.expressions) {
            ILogicalExpression e = (ILogicalExpression)eRef.getValue();
            if (e.getExpressionTag() != LogicalExpressionTag.VARIABLE) continue;
            VariableReferenceExpression v = (VariableReferenceExpression)e;
            varList.add(v.getVariableReference());
        }
        return varList;
    }

    public boolean isDistinctByVar(LogicalVariable var) {
        for (Mutable<ILogicalExpression> eRef : this.expressions) {
            VariableReferenceExpression v;
            ILogicalExpression e = (ILogicalExpression)eRef.getValue();
            if (e.getExpressionTag() != LogicalExpressionTag.VARIABLE || !(v = (VariableReferenceExpression)e).getVariableReference().equals(var)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IVariableTypeEnvironment computeOutputTypeEnvironment(ITypingContext ctx) throws AlgebricksException {
        return this.createPropagatingAllInputsTypeEnvironment(ctx);
    }
}

