/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.abstracts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public abstract class AbstractExternalInputStreamFactory
implements IInputStreamFactory {
    private static final long serialVersionUID = 1L;
    protected Map<String, String> configuration;
    protected final List<PartitionWorkLoadBasedOnSize> partitionWorkLoadsBasedOnSize = new ArrayList<PartitionWorkLoadBasedOnSize>();
    protected transient AlgebricksAbsolutePartitionConstraint partitionConstraint;

    @Override
    public IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return IExternalDataSourceFactory.DataSourceType.STREAM;
    }

    @Override
    public boolean isIndexible() {
        return false;
    }

    @Override
    public abstract AsterixInputStream createInputStream(IHyracksTaskContext var1, int var2) throws HyracksDataException;

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() {
        return this.partitionConstraint;
    }

    protected int getPartitionsCount() {
        return this.getPartitionConstraint().getLocations().length;
    }

    @Override
    public void configure(IServiceContext ctx, Map<String, String> configuration, IWarningCollector warningCollector) throws AlgebricksException {
        this.configuration = configuration;
        this.partitionConstraint = ((ICcApplicationContext)ctx.getApplicationContext()).getClusterStateManager().getClusterLocations();
    }

    protected IncludeExcludeMatcher getIncludeExcludeMatchers() throws CompilationException {
        ArrayList<Matcher> includeMatchers = new ArrayList<Matcher>();
        ArrayList<Matcher> excludeMatchers = new ArrayList<Matcher>();
        String pattern = null;
        try {
            for (Map.Entry<String, String> entry : this.configuration.entrySet()) {
                if (entry.getKey().startsWith("include")) {
                    pattern = entry.getValue();
                    includeMatchers.add(Pattern.compile(ExternalDataUtils.patternToRegex(pattern)).matcher(""));
                    continue;
                }
                if (!entry.getKey().startsWith("exclude")) continue;
                pattern = entry.getValue();
                excludeMatchers.add(Pattern.compile(ExternalDataUtils.patternToRegex(pattern)).matcher(""));
            }
        }
        catch (PatternSyntaxException ex) {
            throw new CompilationException(ErrorCode.INVALID_REGEX_PATTERN, new Serializable[]{pattern});
        }
        IncludeExcludeMatcher includeExcludeMatcher = !includeMatchers.isEmpty() ? new IncludeExcludeMatcher(includeMatchers, (matchers1, key) -> ExternalDataUtils.matchPatterns(matchers1, key)) : (!excludeMatchers.isEmpty() ? new IncludeExcludeMatcher(excludeMatchers, (matchers1, key) -> !ExternalDataUtils.matchPatterns(matchers1, key)) : new IncludeExcludeMatcher(Collections.emptyList(), (matchers1, key) -> true));
        return includeExcludeMatcher;
    }

    public static class IncludeExcludeMatcher
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<Matcher> matchersList;
        private final BiPredicate<List<Matcher>, String> predicate;

        public IncludeExcludeMatcher(List<Matcher> matchersList, BiPredicate<List<Matcher>, String> predicate) {
            this.matchersList = matchersList;
            this.predicate = predicate;
        }

        public List<Matcher> getMatchersList() {
            return this.matchersList;
        }

        public BiPredicate<List<Matcher>, String> getPredicate() {
            return this.predicate;
        }
    }

    public static class PartitionWorkLoadBasedOnSize
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<String> filePaths = new ArrayList<String>();
        private long totalSize = 0L;

        public List<String> getFilePaths() {
            return this.filePaths;
        }

        public void addFilePath(String filePath, long size) {
            this.filePaths.add(filePath);
            this.totalSize += size;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public String toString() {
            return "Files: " + this.filePaths.size() + ", Total Size: " + this.totalSize;
        }
    }
}

