/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.join;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksJobletContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluator;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparator;
import org.apache.hyracks.api.dataflow.value.ITuplePartitionComputer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.io.GeneratedRunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.buffermanager.DeallocatableFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.FramePoolBackedFrameBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.IPartitionedTupleBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.ISimpleFrameBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.PreferToSpillFullyOccupiedFramePolicy;
import org.apache.hyracks.dataflow.std.buffermanager.VPartitionTupleBufferManager;
import org.apache.hyracks.dataflow.std.join.InMemoryHashJoin;
import org.apache.hyracks.dataflow.std.structures.SerializableHashTable;
import org.apache.hyracks.dataflow.std.structures.TuplePointer;

public class OptimizedHybridHashJoin {
    private FrameTupleAppender bigFrameAppender;
    private final IHyracksJobletContext jobletCtx;
    private final String buildRelName;
    private final String probeRelName;
    private final ITuplePartitionComputer buildHpc;
    private final ITuplePartitionComputer probeHpc;
    private final RecordDescriptor buildRd;
    private final RecordDescriptor probeRd;
    private final RunFileWriter[] buildRFWriters;
    private final RunFileWriter[] probeRFWriters;
    private final IPredicateEvaluator predEvaluator;
    private final boolean isLeftOuter;
    private final IMissingWriter[] nonMatchWriters;
    private final BitSet spilledStatus;
    private final int numOfPartitions;
    private final int memSizeInFrames;
    private InMemoryHashJoin inMemJoiner;
    private IPartitionedTupleBufferManager bufferManager;
    private PreferToSpillFullyOccupiedFramePolicy spillPolicy;
    private final FrameTupleAccessor accessorBuild;
    private final FrameTupleAccessor accessorProbe;
    private ISimpleFrameBufferManager bufferManagerForHashTable;
    private boolean isReversed;
    private int[] buildPSizeInTups;
    private IFrame reloadBuffer;
    private final TuplePointer tempPtr = new TuplePointer();
    private int[] probePSizeInTups;

    public OptimizedHybridHashJoin(IHyracksJobletContext jobletCtx, int memSizeInFrames, int numOfPartitions, String probeRelName, String buildRelName, RecordDescriptor probeRd, RecordDescriptor buildRd, ITuplePartitionComputer probeHpc, ITuplePartitionComputer buildHpc, IPredicateEvaluator predEval, boolean isLeftOuter, IMissingWriterFactory[] nullWriterFactories1) {
        this.jobletCtx = jobletCtx;
        this.memSizeInFrames = memSizeInFrames;
        this.buildRd = buildRd;
        this.probeRd = probeRd;
        this.buildHpc = buildHpc;
        this.probeHpc = probeHpc;
        this.buildRelName = buildRelName;
        this.probeRelName = probeRelName;
        this.numOfPartitions = numOfPartitions;
        this.buildRFWriters = new RunFileWriter[numOfPartitions];
        this.probeRFWriters = new RunFileWriter[numOfPartitions];
        this.accessorBuild = new FrameTupleAccessor(buildRd);
        this.accessorProbe = new FrameTupleAccessor(probeRd);
        this.predEvaluator = predEval;
        this.isLeftOuter = isLeftOuter;
        this.isReversed = false;
        this.spilledStatus = new BitSet(numOfPartitions);
        IMissingWriter[] iMissingWriterArray = this.nonMatchWriters = isLeftOuter ? new IMissingWriter[nullWriterFactories1.length] : null;
        if (isLeftOuter) {
            for (int i = 0; i < nullWriterFactories1.length; ++i) {
                this.nonMatchWriters[i] = nullWriterFactories1[i].createMissingWriter();
            }
        }
    }

    public void initBuild() throws HyracksDataException {
        DeallocatableFramePool framePool = new DeallocatableFramePool((IHyracksFrameMgrContext)this.jobletCtx, this.memSizeInFrames * this.jobletCtx.getInitialFrameSize());
        this.bufferManagerForHashTable = new FramePoolBackedFrameBufferManager(framePool);
        this.bufferManager = new VPartitionTupleBufferManager(PreferToSpillFullyOccupiedFramePolicy.createAtMostOneFrameForSpilledPartitionConstrain(this.spilledStatus), this.numOfPartitions, framePool);
        this.spillPolicy = new PreferToSpillFullyOccupiedFramePolicy(this.bufferManager, this.spilledStatus);
        this.spilledStatus.clear();
        this.buildPSizeInTups = new int[this.numOfPartitions];
    }

    public void build(ByteBuffer buffer) throws HyracksDataException {
        this.accessorBuild.reset(buffer);
        int tupleCount = this.accessorBuild.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            int pid = this.buildHpc.partition((IFrameTupleAccessor)this.accessorBuild, i, this.numOfPartitions);
            this.processTupleBuildPhase(i, pid);
            int n = pid;
            this.buildPSizeInTups[n] = this.buildPSizeInTups[n] + 1;
        }
    }

    private void processTupleBuildPhase(int tid, int pid) throws HyracksDataException {
        while (!this.bufferManager.insertTuple(pid, (IFrameTupleAccessor)this.accessorBuild, tid, this.tempPtr)) {
            int victimPartition;
            int recordSize = VPartitionTupleBufferManager.calculateActualSize(null, this.accessorBuild.getTupleLength(tid));
            double numFrames = (double)recordSize / (double)this.jobletCtx.getInitialFrameSize();
            if (numFrames > (double)this.bufferManager.getConstrain().frameLimit(pid) || (victimPartition = this.spillPolicy.selectVictimPartition(pid)) < 0) {
                if (numFrames > (double)this.memSizeInFrames || recordSize < this.jobletCtx.getInitialFrameSize()) {
                    throw HyracksDataException.create((ErrorCode)ErrorCode.INSUFFICIENT_MEMORY, (Serializable[])new Serializable[0]);
                }
                this.flushBigObjectToDisk(pid, this.accessorBuild, tid, this.buildRFWriters, this.buildRelName);
                this.spilledStatus.set(pid);
                if ((double)this.bufferManager.getPhysicalSize(pid) / (double)this.jobletCtx.getInitialFrameSize() > (double)this.bufferManager.getConstrain().frameLimit(pid)) {
                    this.spillPartition(pid);
                }
                return;
            }
            this.spillPartition(victimPartition);
        }
    }

    private void spillPartition(int pid) throws HyracksDataException {
        RunFileWriter writer = this.getSpillWriterOrCreateNewOneIfNotExist(this.buildRFWriters, this.buildRelName, pid);
        this.bufferManager.flushPartition(pid, (IFrameWriter)writer);
        this.bufferManager.clearPartition(pid);
        this.spilledStatus.set(pid);
    }

    private void closeBuildPartition(int pid) throws HyracksDataException {
        if (this.buildRFWriters[pid] == null) {
            throw new HyracksDataException("Tried to close the non-existing file writer.");
        }
        this.buildRFWriters[pid].close();
    }

    private RunFileWriter getSpillWriterOrCreateNewOneIfNotExist(RunFileWriter[] runFileWriters, String refName, int pid) throws HyracksDataException {
        RunFileWriter writer = runFileWriters[pid];
        if (writer == null) {
            FileReference file = this.jobletCtx.createManagedWorkspaceFile(refName);
            writer = new RunFileWriter(file, this.jobletCtx.getIoManager());
            writer.open();
            runFileWriters[pid] = writer;
        }
        return writer;
    }

    public void closeBuild() throws HyracksDataException {
        this.closeAllSpilledPartitions(this.buildRFWriters, this.buildRelName);
        int inMemTupCount = this.makeSpaceForHashTableAndBringBackSpilledPartitions();
        SerializableHashTable table = new SerializableHashTable(inMemTupCount, (IHyracksFrameMgrContext)this.jobletCtx, this.bufferManagerForHashTable);
        this.inMemJoiner = new InMemoryHashJoin((IHyracksFrameMgrContext)this.jobletCtx, new FrameTupleAccessor(this.probeRd), this.probeHpc, new FrameTupleAccessor(this.buildRd), this.buildRd, this.buildHpc, this.isLeftOuter, this.nonMatchWriters, table, this.predEvaluator, this.isReversed, this.bufferManagerForHashTable);
        this.buildHashTable();
    }

    public void clearBuildTempFiles() throws HyracksDataException {
        this.clearTempFiles(this.buildRFWriters);
    }

    public void clearProbeTempFiles() throws HyracksDataException {
        this.clearTempFiles(this.probeRFWriters);
    }

    private void clearTempFiles(RunFileWriter[] runFileWriters) throws HyracksDataException {
        for (int i = 0; i < runFileWriters.length; ++i) {
            if (runFileWriters[i] == null) continue;
            runFileWriters[i].erase();
        }
    }

    public void fail() throws HyracksDataException {
        for (RunFileWriter writer : this.buildRFWriters) {
            if (writer == null) continue;
            CleanupUtils.fail((IFrameWriter)writer, null);
        }
        for (RunFileWriter writer : this.probeRFWriters) {
            if (writer == null) continue;
            CleanupUtils.fail((IFrameWriter)writer, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllSpilledPartitions(RunFileWriter[] runFileWriters, String refName) throws HyracksDataException {
        try {
            int pid = this.spilledStatus.nextSetBit(0);
            while (pid >= 0 && pid < this.numOfPartitions) {
                if (this.bufferManager.getNumTuples(pid) > 0) {
                    this.bufferManager.flushPartition(pid, (IFrameWriter)this.getSpillWriterOrCreateNewOneIfNotExist(runFileWriters, refName, pid));
                    this.bufferManager.clearPartition(pid);
                }
                pid = this.spilledStatus.nextSetBit(pid + 1);
            }
        }
        finally {
            for (RunFileWriter runFileWriter : runFileWriters) {
                if (runFileWriter == null) continue;
                runFileWriter.close();
            }
        }
    }

    private int makeSpaceForHashTableAndBringBackSpilledPartitions() throws HyracksDataException {
        int frameSize = this.jobletCtx.getInitialFrameSize();
        long freeSpace = (long)(this.memSizeInFrames - this.spilledStatus.cardinality()) * (long)frameSize;
        int inMemTupCount = 0;
        int p = this.spilledStatus.nextClearBit(0);
        while (p >= 0 && p < this.numOfPartitions) {
            freeSpace -= (long)this.bufferManager.getPhysicalSize(p);
            inMemTupCount += this.buildPSizeInTups[p];
            p = this.spilledStatus.nextClearBit(p + 1);
        }
        return this.spillAndReloadPartitions(frameSize, freeSpace -= SerializableHashTable.getExpectedTableByteSize(inMemTupCount, frameSize), inMemTupCount);
    }

    private int spillAndReloadPartitions(int frameSize, long freeSpace, int inMemTupCount) throws HyracksDataException {
        long currentFreeSpace;
        long expectedHashTableSizeDecrease;
        int pidToSpill;
        int currentInMemTupCount = inMemTupCount;
        for (currentFreeSpace = freeSpace; currentFreeSpace < 0L; currentFreeSpace += (long)this.bufferManager.getPhysicalSize(pidToSpill) + expectedHashTableSizeDecrease - (long)frameSize) {
            pidToSpill = this.selectSinglePartitionToSpill(currentFreeSpace, currentInMemTupCount, frameSize);
            if (pidToSpill >= 0) {
                int numberOfTuplesToBeSpilled = this.buildPSizeInTups[pidToSpill];
                expectedHashTableSizeDecrease = -SerializableHashTable.calculateByteSizeDeltaForTableSizeChange(currentInMemTupCount, -numberOfTuplesToBeSpilled, frameSize);
                currentInMemTupCount -= numberOfTuplesToBeSpilled;
                this.spillPartition(pidToSpill);
                this.closeBuildPartition(pidToSpill);
                continue;
            }
            throw new HyracksDataException("Hash join does not have enough memory even after spilling.");
        }
        return this.bringPartitionsBack(currentFreeSpace, currentInMemTupCount, frameSize);
    }

    private int bringPartitionsBack(long freeSpace, int inMemTupCount, int frameSize) throws HyracksDataException {
        int pid = 0;
        int currentMemoryTupleCount = inMemTupCount;
        long currentFreeSpace = freeSpace;
        while ((pid = this.selectAPartitionToReload(currentFreeSpace, pid, currentMemoryTupleCount)) >= 0 && this.loadSpilledPartitionToMem(pid, this.buildRFWriters[pid])) {
            currentMemoryTupleCount += this.buildPSizeInTups[pid];
            currentFreeSpace = currentFreeSpace - (long)this.bufferManager.getPhysicalSize(pid) - SerializableHashTable.calculateByteSizeDeltaForTableSizeChange(inMemTupCount, this.buildPSizeInTups[pid], frameSize) + (long)frameSize;
        }
        return currentMemoryTupleCount;
    }

    private int selectSinglePartitionToSpill(long currentFreeSpace, int currentInMemTupCount, int frameSize) {
        long minSpaceAfterSpill = (long)this.memSizeInFrames * (long)frameSize;
        int minSpaceAfterSpillPartID = -1;
        int nextAvailablePidToSpill = -1;
        int p = this.spilledStatus.nextClearBit(0);
        while (p >= 0 && p < this.numOfPartitions) {
            if (this.buildPSizeInTups[p] != 0 && this.bufferManager.getPhysicalSize(p) != 0) {
                long spaceAfterSpill;
                if (nextAvailablePidToSpill < 0) {
                    nextAvailablePidToSpill = p;
                }
                if ((spaceAfterSpill = currentFreeSpace + (long)this.bufferManager.getPhysicalSize(p) - (long)frameSize + -SerializableHashTable.calculateByteSizeDeltaForTableSizeChange(currentInMemTupCount, -this.buildPSizeInTups[p], frameSize)) == 0L) {
                    return p;
                }
                if (spaceAfterSpill > 0L && spaceAfterSpill < minSpaceAfterSpill) {
                    minSpaceAfterSpill = spaceAfterSpill;
                    minSpaceAfterSpillPartID = p;
                }
            }
            p = this.spilledStatus.nextClearBit(p + 1);
        }
        return minSpaceAfterSpillPartID >= 0 ? minSpaceAfterSpillPartID : nextAvailablePidToSpill;
    }

    private int selectAPartitionToReload(long freeSpace, int pid, int inMemTupCount) {
        int frameSize = this.jobletCtx.getInitialFrameSize();
        long totalFreeSpace = freeSpace + (long)frameSize;
        if (totalFreeSpace > 0L) {
            int i = this.spilledStatus.nextSetBit(pid);
            while (i >= 0 && i < this.numOfPartitions) {
                int spilledTupleCount = this.buildPSizeInTups[i];
                long expectedHashTableByteSizeIncrease = SerializableHashTable.calculateByteSizeDeltaForTableSizeChange(inMemTupCount, spilledTupleCount, frameSize);
                if (totalFreeSpace >= this.buildRFWriters[i].getFileSize() + expectedHashTableByteSizeIncrease) {
                    return i;
                }
                i = this.spilledStatus.nextSetBit(i + 1);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadSpilledPartitionToMem(int pid, RunFileWriter wr) throws HyracksDataException {
        try (GeneratedRunFileReader r = wr.createReader();){
            r.open();
            if (this.reloadBuffer == null) {
                this.reloadBuffer = new VSizeFrame((IHyracksFrameMgrContext)this.jobletCtx);
            }
            while (r.nextFrame(this.reloadBuffer)) {
                this.accessorBuild.reset(this.reloadBuffer.getBuffer());
                for (int tid = 0; tid < this.accessorBuild.getTupleCount(); ++tid) {
                    if (this.bufferManager.insertTuple(pid, (IFrameTupleAccessor)this.accessorBuild, tid, this.tempPtr)) continue;
                    this.bufferManager.clearPartition(pid);
                    boolean bl = false;
                    return bl;
                }
            }
            r.setDeleteAfterClose(true);
        }
        this.spilledStatus.set(pid, false);
        this.buildRFWriters[pid] = null;
        return true;
    }

    private void buildHashTable() throws HyracksDataException {
        for (int pid = 0; pid < this.numOfPartitions; ++pid) {
            if (this.spilledStatus.get(pid)) continue;
            this.bufferManager.flushPartition(pid, new IFrameWriter(){

                public void open() {
                }

                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    OptimizedHybridHashJoin.this.inMemJoiner.build(buffer);
                }

                public void fail() {
                }

                public void close() {
                }
            });
        }
    }

    public void initProbe(ITuplePairComparator comparator) {
        this.probePSizeInTups = new int[this.numOfPartitions];
        this.inMemJoiner.setComparator(comparator);
        this.bufferManager.setConstrain(VPartitionTupleBufferManager.NO_CONSTRAIN);
    }

    public void probe(ByteBuffer buffer, IFrameWriter writer) throws HyracksDataException {
        this.accessorProbe.reset(buffer);
        int tupleCount = this.accessorProbe.getTupleCount();
        if (this.isBuildRelAllInMemory()) {
            this.inMemJoiner.join(buffer, writer);
            return;
        }
        this.inMemJoiner.resetAccessorProbe((IFrameTupleAccessor)this.accessorProbe);
        for (int i = 0; i < tupleCount; ++i) {
            int pid = this.probeHpc.partition((IFrameTupleAccessor)this.accessorProbe, i, this.numOfPartitions);
            if (this.buildPSizeInTups[pid] <= 0 && !this.isLeftOuter) continue;
            if (this.spilledStatus.get(pid)) {
                this.processTupleProbePhase(i, pid);
            } else {
                this.inMemJoiner.join(i, writer);
            }
            int n = pid;
            this.probePSizeInTups[n] = this.probePSizeInTups[n] + 1;
        }
    }

    private void processTupleProbePhase(int tupleId, int pid) throws HyracksDataException {
        if (!this.bufferManager.insertTuple(pid, (IFrameTupleAccessor)this.accessorProbe, tupleId, this.tempPtr)) {
            int victim;
            int recordSize = VPartitionTupleBufferManager.calculateActualSize(null, this.accessorProbe.getTupleLength(tupleId));
            boolean modestCase = recordSize <= this.jobletCtx.getInitialFrameSize() / 2;
            int n = victim = modestCase && this.bufferManager.getNumTuples(pid) > 0 ? pid : this.spillPolicy.findSpilledPartitionWithMaxMemoryUsage();
            if (victim >= 0 && this.bufferManager.getPhysicalSize(victim) >= recordSize) {
                RunFileWriter runFileWriter = this.getSpillWriterOrCreateNewOneIfNotExist(this.probeRFWriters, this.probeRelName, victim);
                this.bufferManager.flushPartition(victim, (IFrameWriter)runFileWriter);
                this.bufferManager.clearPartition(victim);
                if (!this.bufferManager.insertTuple(pid, (IFrameTupleAccessor)this.accessorProbe, tupleId, this.tempPtr)) {
                    this.flushBigObjectToDisk(pid, this.accessorProbe, tupleId, this.probeRFWriters, this.probeRelName);
                }
            } else {
                this.flushBigObjectToDisk(pid, this.accessorProbe, tupleId, this.probeRFWriters, this.probeRelName);
            }
        }
    }

    private void flushBigObjectToDisk(int pid, FrameTupleAccessor accessor, int i, RunFileWriter[] runFileWriters, String refName) throws HyracksDataException {
        if (this.bigFrameAppender == null) {
            this.bigFrameAppender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.jobletCtx));
        }
        RunFileWriter runFileWriter = this.getSpillWriterOrCreateNewOneIfNotExist(runFileWriters, refName, pid);
        if (!this.bigFrameAppender.append((IFrameTupleAccessor)accessor, i)) {
            throw new HyracksDataException("The given tuple is too big");
        }
        this.bigFrameAppender.write((IFrameWriter)runFileWriter, true);
    }

    private boolean isBuildRelAllInMemory() {
        return this.spilledStatus.nextSetBit(0) < 0;
    }

    public void completeProbe(IFrameWriter writer) throws HyracksDataException {
        this.inMemJoiner.completeJoin(writer);
    }

    public void releaseResource() throws HyracksDataException {
        this.inMemJoiner.closeTable();
        this.closeAllSpilledPartitions(this.probeRFWriters, this.probeRelName);
        this.bufferManager.close();
        this.inMemJoiner = null;
        this.bufferManager = null;
        this.bufferManagerForHashTable = null;
    }

    public RunFileReader getBuildRFReader(int pid) throws HyracksDataException {
        return this.buildRFWriters[pid] == null ? null : this.buildRFWriters[pid].createDeleteOnCloseReader();
    }

    public int getBuildPartitionSizeInTup(int pid) {
        return this.buildPSizeInTups[pid];
    }

    public RunFileReader getProbeRFReader(int pid) throws HyracksDataException {
        return this.probeRFWriters[pid] == null ? null : this.probeRFWriters[pid].createDeleteOnCloseReader();
    }

    public int getProbePartitionSizeInTup(int pid) {
        return this.probePSizeInTups[pid];
    }

    public int getMaxBuildPartitionSize() {
        return this.getMaxPartitionSize(this.buildPSizeInTups);
    }

    public int getMaxProbePartitionSize() {
        return this.getMaxPartitionSize(this.probePSizeInTups);
    }

    private int getMaxPartitionSize(int[] partitions) {
        int max = partitions[0];
        for (int i = 1; i < partitions.length; ++i) {
            if (partitions[i] <= max) continue;
            max = partitions[i];
        }
        return max;
    }

    public BitSet getPartitionStatus() {
        return this.spilledStatus;
    }

    public int getPartitionSize(int pid) {
        return this.bufferManager.getPhysicalSize(pid);
    }

    public void setIsReversed(boolean b) {
        this.isReversed = b;
    }

    public static enum SIDE {
        BUILD,
        PROBE;

    }
}

