/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.job.profiling.om;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.job.profiling.IStatsCollector;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.control.common.job.profiling.StatsCollector;
import org.apache.hyracks.control.common.job.profiling.counters.MultiResolutionEventProfiler;
import org.apache.hyracks.control.common.job.profiling.om.AbstractProfile;
import org.apache.hyracks.control.common.job.profiling.om.PartitionProfile;

public class TaskProfile
extends AbstractProfile {
    private static final long serialVersionUID = 1L;
    private TaskAttemptId taskAttemptId;
    private Map<PartitionId, PartitionProfile> partitionSendProfile;
    private IStatsCollector statsCollector;
    private Set<Warning> warnings;
    private long totalWarningsCount;

    public static TaskProfile create(DataInput dis) throws IOException {
        TaskProfile taskProfile = new TaskProfile();
        taskProfile.readFields(dis);
        return taskProfile;
    }

    private TaskProfile() {
    }

    public TaskProfile(TaskAttemptId taskAttemptId, Map<PartitionId, PartitionProfile> partitionSendProfile, IStatsCollector statsCollector, Set<Warning> warnings, long totalWarningsCount) {
        this.taskAttemptId = taskAttemptId;
        this.partitionSendProfile = new HashMap<PartitionId, PartitionProfile>(partitionSendProfile);
        this.statsCollector = statsCollector;
        this.warnings = warnings;
        this.totalWarningsCount = totalWarningsCount;
    }

    public TaskAttemptId getTaskId() {
        return this.taskAttemptId;
    }

    public Map<PartitionId, PartitionProfile> getPartitionSendProfile() {
        return this.partitionSendProfile;
    }

    @Override
    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        json.put("activity-id", this.taskAttemptId.getTaskId().getActivityId().toString());
        json.put("partition", this.taskAttemptId.getTaskId().getPartition());
        json.put("attempt", this.taskAttemptId.getAttempt());
        if (this.partitionSendProfile != null) {
            ArrayNode pspArray = om.createArrayNode();
            for (PartitionProfile pp : this.partitionSendProfile.values()) {
                ObjectNode ppObj = om.createObjectNode();
                PartitionId pid = pp.getPartitionId();
                ObjectNode pidObj = om.createObjectNode();
                pidObj.put("job-id", pid.getJobId().toString());
                pidObj.put("connector-id", pid.getConnectorDescriptorId().toString());
                pidObj.put("sender-index", pid.getSenderIndex());
                pidObj.put("receiver-index", pid.getReceiverIndex());
                ppObj.set("partition-id", (JsonNode)pidObj);
                ppObj.put("open-time", pp.getOpenTime());
                ppObj.put("close-time", pp.getCloseTime());
                MultiResolutionEventProfiler samples = pp.getSamples();
                ppObj.put("offset", samples.getOffset());
                int resolution = samples.getResolution();
                int sampleCount = samples.getCount();
                ArrayNode ftA = om.createArrayNode();
                int[] ft = samples.getSamples();
                for (int i = 0; i < sampleCount; ++i) {
                    ftA.add(ft[i]);
                }
                ppObj.set("frame-times", (JsonNode)ftA);
                ppObj.put("resolution", resolution);
                pspArray.add((JsonNode)ppObj);
            }
            json.set("partition-send-profile", (JsonNode)pspArray);
        }
        this.populateCounters(json);
        return json;
    }

    @Override
    protected void populateCounters(ObjectNode json) {
        ObjectMapper om = new ObjectMapper();
        Map opTimes = this.statsCollector.getAllOperatorStats();
        ArrayNode countersObj = om.createArrayNode();
        opTimes.forEach((key, value) -> {
            ObjectNode jpe = om.createObjectNode();
            jpe.put("name", key);
            jpe.put("time", Double.parseDouble(new DecimalFormat("#.####").format((double)value.getTimeCounter().get() / 1000000.0)));
            jpe.put("disk-io", value.getDiskIoCounter().get());
            countersObj.add((JsonNode)jpe);
        });
        json.set("counters", (JsonNode)countersObj);
    }

    public IStatsCollector getStatsCollector() {
        return this.statsCollector;
    }

    public Set<Warning> getWarnings() {
        return this.warnings;
    }

    public long getTotalWarningsCount() {
        return this.totalWarningsCount;
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.taskAttemptId = TaskAttemptId.create((DataInput)input);
        int size = input.readInt();
        this.partitionSendProfile = new HashMap<PartitionId, PartitionProfile>();
        for (int i = 0; i < size; ++i) {
            PartitionId key = PartitionId.create((DataInput)input);
            PartitionProfile value = PartitionProfile.create(input);
            this.partitionSendProfile.put(key, value);
        }
        this.statsCollector = StatsCollector.create(input);
        this.warnings = new HashSet<Warning>();
        TaskProfile.deserializeWarnings(input, this.warnings);
        this.totalWarningsCount = input.readLong();
    }

    @Override
    public void writeFields(DataOutput output) throws IOException {
        super.writeFields(output);
        this.taskAttemptId.writeFields(output);
        output.writeInt(this.partitionSendProfile.size());
        for (Map.Entry<PartitionId, PartitionProfile> entry : this.partitionSendProfile.entrySet()) {
            entry.getKey().writeFields(output);
            entry.getValue().writeFields(output);
        }
        this.statsCollector.writeFields(output);
        this.serializeWarnings(output);
        output.writeLong(this.totalWarningsCount);
    }

    private void serializeWarnings(DataOutput output) throws IOException {
        output.writeInt(this.warnings.size());
        for (Warning warning : this.warnings) {
            warning.writeFields(output);
        }
    }

    private static void deserializeWarnings(DataInput input, Set<Warning> warnings) throws IOException {
        int warnCount = input.readInt();
        for (int i = 0; i < warnCount; ++i) {
            warnings.add(Warning.create((DataInput)input));
        }
    }
}

