/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.work;

import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SynchronizableWork
extends AbstractWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean done;
    private Exception e;

    protected abstract void doRun() throws Exception;

    public void init() {
        this.done = false;
        this.e = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            this.doRun();
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Exception thrown from work", (Throwable)ex);
            this.e = ex;
        }
        finally {
            SynchronizableWork synchronizableWork = this;
            synchronized (synchronizableWork) {
                this.done = true;
                this.notifyAll();
            }
        }
    }

    public final synchronized void sync() throws Exception {
        while (!this.done) {
            this.wait();
        }
        if (this.e != null) {
            throw this.e;
        }
    }
}

