/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.metadata.utils.KeyFieldTypeUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ValidateUtil {
    private ValidateUtil() {
    }

    public static void validateFilterField(ARecordType recordType, ARecordType metaType, Integer filterSourceIndicator, List<String> filterField, SourceLocation sourceLoc) throws AlgebricksException {
        ARecordType itemType = filterSourceIndicator == 0 ? recordType : metaType;
        IAType fieldType = itemType.getSubFieldType(filterField);
        if (fieldType == null) {
            throw new CompilationException(ErrorCode.COMPILATION_FIELD_NOT_FOUND, sourceLoc, new Serializable[]{RecordUtil.toFullyQualifiedName(filterField)});
        }
        switch (fieldType.getTypeTag()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BINARY: 
            case DATE: 
            case TIME: 
            case DATETIME: 
            case UUID: 
            case YEARMONTHDURATION: 
            case DAYTIMEDURATION: {
                break;
            }
            case UNION: {
                throw new CompilationException(ErrorCode.COMPILATION_FILTER_CANNOT_BE_NULLABLE, new Serializable[]{RecordUtil.toFullyQualifiedName(filterField)});
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_FILTER_TYPE, new Serializable[]{fieldType.getTypeTag().name()});
            }
        }
    }

    public static List<IAType> validatePartitioningExpressions(ARecordType recType, ARecordType metaRecType, List<List<String>> partitioningExprs, List<Integer> keySourceIndicators, boolean autogenerated, SourceLocation sourceLoc) throws AlgebricksException {
        ArrayList<IAType> partitioningExprTypes = new ArrayList(partitioningExprs.size());
        if (autogenerated) {
            if (partitioningExprs.size() > 1) {
                throw new CompilationException(ErrorCode.COMPILATION_CANNOT_AUTOGENERATE_COMPOSITE_PRIMARY_KEY, sourceLoc, new Serializable[0]);
            }
            List<String> fieldName = partitioningExprs.get(0);
            IAType fieldType = recType.getSubFieldType(fieldName);
            if (fieldType == null) {
                String unTypeField = fieldName.get(0) == null ? "" : fieldName.get(0);
                throw new CompilationException(ErrorCode.COMPILATION_FIELD_NOT_FOUND, sourceLoc, new Serializable[]{unTypeField});
            }
            partitioningExprTypes.add(fieldType);
            ATypeTag pkTypeTag = fieldType.getTypeTag();
            if (pkTypeTag != ATypeTag.UUID) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_AUTOGENERATED_TYPE, sourceLoc, new Serializable[]{pkTypeTag.name(), ATypeTag.UUID.name()});
            }
        } else {
            partitioningExprTypes = KeyFieldTypeUtil.getKeyTypes((ARecordType)recType, (ARecordType)metaRecType, partitioningExprs, keySourceIndicators);
            block4: for (int i = 0; i < partitioningExprs.size(); ++i) {
                List<String> partitioningExpr = partitioningExprs.get(i);
                IAType fieldType = (IAType)partitioningExprTypes.get(i);
                if (fieldType == null) {
                    throw new CompilationException(ErrorCode.COMPILATION_FIELD_NOT_FOUND, sourceLoc, new Serializable[]{RecordUtil.toFullyQualifiedName(partitioningExpr)});
                }
                boolean nullable = KeyFieldTypeUtil.chooseSource(keySourceIndicators, (int)i, (ARecordType)recType, (ARecordType)metaRecType).isSubFieldNullable(partitioningExpr);
                if (nullable) {
                    throw new CompilationException(ErrorCode.COMPILATION_PRIMARY_KEY_CANNOT_BE_NULLABLE, sourceLoc, new Serializable[]{RecordUtil.toFullyQualifiedName(partitioningExpr)});
                }
                switch (fieldType.getTypeTag()) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: 
                    case FLOAT: 
                    case DOUBLE: 
                    case STRING: 
                    case BINARY: 
                    case DATE: 
                    case TIME: 
                    case DATETIME: 
                    case UUID: 
                    case YEARMONTHDURATION: 
                    case DAYTIMEDURATION: {
                        continue block4;
                    }
                    case UNION: {
                        throw new CompilationException(ErrorCode.COMPILATION_PRIMARY_KEY_CANNOT_BE_NULLABLE, sourceLoc, new Serializable[]{RecordUtil.toFullyQualifiedName(partitioningExpr)});
                    }
                    default: {
                        throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_PRIMARY_KEY_TYPE, sourceLoc, new Serializable[]{fieldType.getTypeTag()});
                    }
                }
            }
        }
        return partitioningExprTypes;
    }

    public static void validateIndexFieldType(DatasetConfig.IndexType indexType, IAType fieldType, List<String> displayFieldName, SourceLocation sourceLoc) throws AlgebricksException {
        block0 : switch (indexType) {
            case ARRAY: 
            case BTREE: {
                switch (fieldType.getTypeTag()) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: 
                    case FLOAT: 
                    case DOUBLE: 
                    case STRING: 
                    case BINARY: 
                    case DATE: 
                    case TIME: 
                    case DATETIME: 
                    case UUID: 
                    case YEARMONTHDURATION: 
                    case DAYTIMEDURATION: 
                    case UNION: {
                        break block0;
                    }
                }
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"The field \"" + displayFieldName + "\" which is of type " + fieldType.getTypeTag() + " cannot be indexed using the BTree index."});
            }
            case RTREE: {
                switch (fieldType.getTypeTag()) {
                    case UNION: 
                    case POINT: 
                    case LINE: 
                    case RECTANGLE: 
                    case CIRCLE: 
                    case POLYGON: 
                    case GEOMETRY: {
                        break block0;
                    }
                }
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"The field \"" + displayFieldName + "\" which is of type " + fieldType.getTypeTag() + " cannot be indexed using the RTree index."});
            }
            case LENGTH_PARTITIONED_NGRAM_INVIX: {
                switch (fieldType.getTypeTag()) {
                    case STRING: 
                    case UNION: {
                        break block0;
                    }
                }
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"The field \"" + displayFieldName + "\" which is of type " + fieldType.getTypeTag() + " cannot be indexed using the Length Partitioned N-Gram index."});
            }
            case LENGTH_PARTITIONED_WORD_INVIX: {
                switch (fieldType.getTypeTag()) {
                    case STRING: 
                    case UNION: 
                    case MULTISET: 
                    case ARRAY: {
                        break block0;
                    }
                }
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"The field \"" + displayFieldName + "\" which is of type " + fieldType.getTypeTag() + " cannot be indexed using the Length Partitioned Keyword index."});
            }
            case SINGLE_PARTITION_NGRAM_INVIX: {
                switch (fieldType.getTypeTag()) {
                    case STRING: 
                    case UNION: {
                        break block0;
                    }
                }
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"The field \"" + displayFieldName + "\" which is of type " + fieldType.getTypeTag() + " cannot be indexed using the N-Gram index."});
            }
            case SINGLE_PARTITION_WORD_INVIX: {
                switch (fieldType.getTypeTag()) {
                    case STRING: 
                    case UNION: 
                    case MULTISET: 
                    case ARRAY: {
                        break block0;
                    }
                }
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"The field \"" + displayFieldName + "\" which is of type " + fieldType.getTypeTag() + " cannot be indexed using the Keyword index."});
            }
            default: {
                throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_INDEX_TYPE, sourceLoc, new Serializable[]{String.valueOf(indexType)});
            }
        }
    }
}

