/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.comm.io;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameAppender;
import org.apache.hyracks.api.comm.IFrameFieldAppender;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameFixedFieldAppender;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;

public class FrameFixedFieldTupleAppender
implements IFrameTupleAppender,
IFrameFieldAppender {
    private FrameFixedFieldAppender fieldAppender;
    private FrameTupleAppender tupleAppender = new FrameTupleAppender();
    private IFrame sharedFrame;
    private IFrameAppender lastAppender;

    public FrameFixedFieldTupleAppender(int numFields) {
        this.fieldAppender = new FrameFixedFieldAppender(numFields);
        this.lastAppender = this.tupleAppender;
    }

    private void resetAppenderIfNecessary(IFrameAppender appender) throws HyracksDataException {
        if (this.lastAppender != appender) {
            if (this.lastAppender == this.fieldAppender && this.fieldAppender.hasLeftOverFields()) {
                throw new HyracksDataException("The previous appended fields haven't been flushed yet.");
            }
            appender.reset(this.sharedFrame, false);
            this.lastAppender = appender;
        }
    }

    public boolean appendField(byte[] bytes, int offset, int length) throws HyracksDataException {
        this.resetAppenderIfNecessary(this.fieldAppender);
        return this.fieldAppender.appendField(bytes, offset, length);
    }

    public boolean appendField(IFrameTupleAccessor accessor, int tid, int fid) throws HyracksDataException {
        this.resetAppenderIfNecessary(this.fieldAppender);
        return this.fieldAppender.appendField(accessor, tid, fid);
    }

    public boolean append(IFrameTupleAccessor tupleAccessor, int tIndex) throws HyracksDataException {
        this.resetAppenderIfNecessary(this.tupleAppender);
        return this.tupleAppender.append(tupleAccessor, tIndex);
    }

    public boolean append(int[] fieldSlots, byte[] bytes, int offset, int length) throws HyracksDataException {
        this.resetAppenderIfNecessary(this.tupleAppender);
        return this.tupleAppender.append(fieldSlots, bytes, offset, length);
    }

    public boolean append(byte[] bytes, int offset, int length) throws HyracksDataException {
        this.resetAppenderIfNecessary(this.tupleAppender);
        return this.tupleAppender.append(bytes, offset, length);
    }

    public boolean appendSkipEmptyField(int[] fieldSlots, byte[] bytes, int offset, int length) throws HyracksDataException {
        this.resetAppenderIfNecessary(this.tupleAppender);
        return this.tupleAppender.appendSkipEmptyField(fieldSlots, bytes, offset, length);
    }

    public boolean append(IFrameTupleAccessor tupleAccessor, int tStartOffset, int tEndOffset) throws HyracksDataException {
        this.resetAppenderIfNecessary(this.tupleAppender);
        return this.tupleAppender.append(tupleAccessor, tStartOffset, tEndOffset);
    }

    public boolean appendConcat(IFrameTupleAccessor accessor0, int tIndex0, IFrameTupleAccessor accessor1, int tIndex1) throws HyracksDataException {
        this.resetAppenderIfNecessary(this.tupleAppender);
        return this.tupleAppender.appendConcat(accessor0, tIndex0, accessor1, tIndex1);
    }

    public boolean appendConcat(IFrameTupleAccessor accessor0, int tIndex0, int[] fieldSlots1, byte[] bytes1, int offset1, int dataLen1) throws HyracksDataException {
        this.resetAppenderIfNecessary(this.tupleAppender);
        return this.tupleAppender.appendConcat(accessor0, tIndex0, fieldSlots1, bytes1, offset1, dataLen1);
    }

    public boolean appendProjection(IFrameTupleAccessor accessor, int tIndex, int[] fields) throws HyracksDataException {
        this.resetAppenderIfNecessary(this.tupleAppender);
        return this.tupleAppender.appendProjection(accessor, tIndex, fields);
    }

    public void reset(IFrame frame, boolean clear) throws HyracksDataException {
        this.sharedFrame = frame;
        this.tupleAppender.reset(this.sharedFrame, clear);
        this.fieldAppender.reset(this.sharedFrame, clear);
    }

    public int getTupleCount() {
        return this.lastAppender.getTupleCount();
    }

    public ByteBuffer getBuffer() {
        return this.lastAppender.getBuffer();
    }

    public void write(IFrameWriter outWriter, boolean clear) throws HyracksDataException {
        this.lastAppender.write(outWriter, clear);
    }
}

