/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.dataflow;

import java.nio.ByteBuffer;
import org.apache.asterix.external.feed.management.FeedConnectionId;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class FeedFrameCollector
implements IFrameWriter {
    private final FeedConnectionId connectionId;
    private IFrameWriter writer;
    private State state;

    public FeedFrameCollector(FeedPolicyAccessor feedPolicyAccessor, IFrameWriter writer, FeedConnectionId connectionId) {
        this.connectionId = connectionId;
        this.writer = writer;
        this.state = State.ACTIVE;
    }

    public synchronized void close() throws HyracksDataException {
        this.writer.close();
        this.state = State.FINISHED;
        this.notify();
    }

    public synchronized void disconnect() {
        this.setState(State.FINISHED);
    }

    public synchronized void nextFrame(ByteBuffer frame) throws HyracksDataException {
        this.writer.nextFrame(frame);
    }

    public synchronized State getState() {
        return this.state;
    }

    public synchronized void setState(State state) {
        this.state = state;
        switch (state) {
            case FINISHED: 
            case HANDOVER: {
                this.notifyAll();
                break;
            }
        }
    }

    public IFrameWriter getFrameWriter() {
        return this.writer;
    }

    public void setFrameWriter(IFrameWriter writer) {
        this.writer = writer;
    }

    public String toString() {
        return "FrameCollector " + this.connectionId + "," + this.state + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof FeedFrameCollector) {
            return this.connectionId.equals(((FeedFrameCollector)o).connectionId);
        }
        return false;
    }

    public int hashCode() {
        return this.connectionId.toString().hashCode();
    }

    public synchronized void flush() throws HyracksDataException {
        this.writer.flush();
    }

    public void open() throws HyracksDataException {
        this.writer.open();
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }

    public FeedConnectionId getConnectionId() {
        return this.connectionId;
    }

    public static enum State {
        ACTIVE,
        FINISHED,
        TRANSITION,
        HANDOVER;

    }
}

