/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.variablesize;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.INullIntrospector;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.tuples.TypeAwareTupleWriter;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.AbstractInvertedListBuilder;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexUtils;

public class VariableSizeElementInvertedListBuilder
extends AbstractInvertedListBuilder {
    private ITreeIndexTupleWriter writer;
    protected final ITypeTraits[] allFields;

    public VariableSizeElementInvertedListBuilder(ITypeTraits[] tokenTypeTraits, ITypeTraits[] invListFields, ITypeTraits nullTypeTraits, INullIntrospector nullIntrospector) throws HyracksDataException {
        super(invListFields);
        int i;
        this.allFields = new ITypeTraits[invListFields.length + tokenTypeTraits.length];
        for (i = 0; i < tokenTypeTraits.length; ++i) {
            this.allFields[i] = tokenTypeTraits[i];
        }
        for (i = 0; i < invListFields.length; ++i) {
            this.allFields[i + tokenTypeTraits.length] = invListFields[i];
        }
        this.writer = new TypeAwareTupleWriter(this.allFields, nullTypeTraits, nullIntrospector);
        InvertedIndexUtils.verifyHasVarSizeTypeTrait(invListFields);
    }

    @Override
    public boolean startNewList(ITupleReference tuple, int numTokenFields) {
        if (!this.checkEnoughSpace(tuple, numTokenFields, tuple.getFieldCount() - numTokenFields)) {
            return false;
        }
        this.listSize = 0;
        return true;
    }

    private boolean checkEnoughSpace(ITupleReference tuple, int numTokenFields, int numElementFields) {
        int numBytesRequired = this.writer.bytesRequired(tuple, numTokenFields, numElementFields);
        return this.checkEnoughSpace(numBytesRequired);
    }

    private boolean checkEnoughSpace(int numBytesRequired) {
        return this.pos + numBytesRequired + 4 <= this.targetBuf.length;
    }

    @Override
    public boolean appendElement(ITupleReference tuple, int numTokenFields, int numElementFields) {
        int numBytesRequired = this.writer.bytesRequired(tuple, numTokenFields, numElementFields);
        if (!this.checkEnoughSpace(numBytesRequired)) {
            return false;
        }
        this.pos += this.writer.writeTupleFields(tuple, numTokenFields, numElementFields, this.targetBuf, this.pos);
        ++this.listSize;
        InvertedIndexUtils.setInvertedListFrameEndOffset(this.targetBuf, this.pos);
        return true;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }
}

