/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.job.profiling;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.job.profiling.IStatsCollector;
import org.apache.hyracks.api.job.profiling.NoOpOperatorStats;
import org.apache.hyracks.api.job.profiling.OperatorStats;

public class StatsCollector
implements IStatsCollector {
    private static final long serialVersionUID = 6858817639895434379L;
    private final Map<String, IOperatorStats> operatorStatsMap = new LinkedHashMap<String, IOperatorStats>();

    public void add(IOperatorStats operatorStats) {
        if (this.operatorStatsMap.containsKey(operatorStats.getName())) {
            throw new IllegalArgumentException("Operator with the same name already exists");
        }
        this.operatorStatsMap.put(operatorStats.getName(), operatorStats);
    }

    public IOperatorStats getOperatorStats(String operatorName) {
        return this.operatorStatsMap.getOrDefault(operatorName, (IOperatorStats)NoOpOperatorStats.INSTANCE);
    }

    public Map<String, IOperatorStats> getAllOperatorStats() {
        return Collections.unmodifiableMap(this.operatorStatsMap);
    }

    public static StatsCollector create(DataInput input) throws IOException {
        StatsCollector statsCollector = new StatsCollector();
        statsCollector.readFields(input);
        return statsCollector;
    }

    public IOperatorStats getAggregatedStats() {
        OperatorStats aggregatedStats = new OperatorStats("aggregated", "ODID:-1");
        for (IOperatorStats stats : this.operatorStatsMap.values()) {
            aggregatedStats.getInputTupleCounter().update(stats.getInputTupleCounter().get());
            aggregatedStats.getTimeCounter().update(stats.getTimeCounter().get());
            aggregatedStats.getPageReads().update(stats.getPageReads().get());
            aggregatedStats.coldReadCounter().update(stats.coldReadCounter().get());
        }
        return aggregatedStats;
    }

    public void writeFields(DataOutput output) throws IOException {
        output.writeInt(this.operatorStatsMap.size());
        for (IOperatorStats stats : this.operatorStatsMap.values()) {
            stats.writeFields(output);
        }
    }

    public void readFields(DataInput input) throws IOException {
        int operatorCount = input.readInt();
        for (int i = 0; i < operatorCount; ++i) {
            IOperatorStats opStats = IOperatorStats.create((DataInput)input);
            this.operatorStatsMap.put(opStats.getName(), opStats);
        }
    }
}

