/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.clause;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;

public class SelectSetOperation
extends AbstractClause {
    private SetOperationInput leftInput;
    private List<SetOperationRight> rightInputs = new ArrayList<SetOperationRight>();

    public SelectSetOperation(SetOperationInput leftInput, List<SetOperationRight> rightInputs) {
        this.leftInput = leftInput;
        if (rightInputs != null) {
            this.rightInputs.addAll(rightInputs);
        }
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return ((ISqlppVisitor)visitor).visit(this, arg);
    }

    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.SELECT_SET_OPERATION;
    }

    public SetOperationInput getLeftInput() {
        return this.leftInput;
    }

    public List<SetOperationRight> getRightInputs() {
        return this.rightInputs;
    }

    public boolean hasRightInputs() {
        return this.rightInputs != null && !this.rightInputs.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.leftInput, this.rightInputs);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SelectSetOperation)) {
            return false;
        }
        SelectSetOperation target = (SelectSetOperation)((Object)object);
        return Objects.equals(this.leftInput, target.leftInput) && Objects.equals(this.rightInputs, target.rightInputs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.leftInput);
        for (SetOperationRight right : this.rightInputs) {
            sb.append(" " + right);
        }
        return sb.toString();
    }
}

