/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.concurrent.ExecutorService;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.deployment.DeploymentId;
import org.apache.hyracks.api.messages.IMessage;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.application.CCServiceContext;
import org.apache.hyracks.control.cc.work.AbstractHeartbeatWork;
import org.apache.hyracks.control.common.deployment.DeploymentUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApplicationMessageWork
extends AbstractHeartbeatWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final byte[] message;
    private final DeploymentId deploymentId;

    public ApplicationMessageWork(ClusterControllerService ccs, byte[] message, DeploymentId deploymentId, String nodeId) {
        super(ccs, nodeId, null);
        this.deploymentId = deploymentId;
        this.message = message;
    }

    @Override
    public void runWork() {
        CCServiceContext ctx = this.ccs.getContext();
        try {
            IMessage data = (IMessage)DeploymentUtils.deserialize((byte[])this.message, (DeploymentId)this.deploymentId, (IServiceContext)ctx);
            ApplicationMessageWork.notifyMessageBroker(ctx, data, this.nodeId);
        }
        catch (Exception e) {
            LOGGER.error("unexpected error", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public Level logLevel() {
        return Level.TRACE;
    }

    public String toString() {
        return this.getName() + ": nodeID: " + this.nodeId;
    }

    private static void notifyMessageBroker(ICCServiceContext ctx, IMessage msg, String nodeId) {
        ExecutorService executor = ctx.getControllerService().getExecutor();
        executor.execute(() -> {
            try {
                ctx.getMessageBroker().receivedMessage(msg, nodeId);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

