/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.List;
import org.apache.hyracks.api.dataflow.TaskAttemptId;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.cc.job.TaskAttempt;
import org.apache.hyracks.control.cc.work.AbstractTaskLifecycleWork;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaskFailureWork
extends AbstractTaskLifecycleWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<Exception> exceptions;

    public TaskFailureWork(ClusterControllerService ccs, JobId jobId, TaskAttemptId taId, String nodeId, List<Exception> exceptions) {
        super(ccs, jobId, taId, nodeId);
        this.exceptions = exceptions;
    }

    @Override
    protected void performEvent(TaskAttempt ta) {
        Exception ex = this.exceptions.get(0);
        LOGGER.log(ExceptionUtils.causedByInterrupt((Throwable)ex) ? Level.DEBUG : Level.WARN, "Executing task failure work for " + this, (Throwable)ex);
        IJobManager jobManager = this.ccs.getJobManager();
        JobRun run = jobManager.get(this.jobId);
        if (run == null) {
            return;
        }
        this.ccs.getResultDirectoryService().reportJobFailure(this.jobId, this.exceptions);
        run.getExecutor().notifyTaskFailure(ta, this.exceptions);
    }

    public String toString() {
        return this.getName() + ": [" + this.jobId + ":" + this.taId + ":" + this.nodeId + "]";
    }
}

