/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.ChainedLSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.impls.DiskComponentMetadata;
import org.apache.hyracks.storage.am.lsm.common.impls.FilterBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.impls.IChainedComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.util.ComponentUtils;
import org.apache.hyracks.storage.am.lsm.common.util.LSMComponentIdUtils;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractLSMDiskComponent
extends AbstractLSMComponent
implements ILSMDiskComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DiskComponentMetadata metadata;
    private final ArrayBackedValueStorage buffer = new ArrayBackedValueStorage(8);
    private ILSMComponentId componentId;

    public AbstractLSMDiskComponent(AbstractLSMIndex lsmIndex, IMetadataPageManager mdPageManager, ILSMComponentFilter filter) {
        super(lsmIndex, filter);
        this.state = ILSMComponent.ComponentState.READABLE_UNWRITABLE;
        this.metadata = new DiskComponentMetadata(mdPageManager);
    }

    @Override
    public void schedule(ILSMIOOperation.LSMIOOperationType ioOperationType) throws HyracksDataException {
        if (ioOperationType != ILSMIOOperation.LSMIOOperationType.MERGE) {
            throw new IllegalStateException("Unsupported operation type: " + ioOperationType);
        }
        if (this.state == ILSMComponent.ComponentState.INACTIVE) {
            throw new IllegalStateException("Trying to schedule a merge of an inactive disk component");
        }
        if (this.state == ILSMComponent.ComponentState.READABLE_MERGING) {
            throw new IllegalStateException("The disk component has already been scheduled for a merge");
        }
        this.state = ILSMComponent.ComponentState.READABLE_MERGING;
    }

    @Override
    public boolean threadEnter(LSMOperationType opType, boolean isMutableComponent) {
        if (this.state == ILSMComponent.ComponentState.INACTIVE) {
            throw new IllegalStateException("Trying to enter an inactive disk component");
        }
        switch (opType) {
            case FORCE_MODIFICATION: 
            case MODIFICATION: 
            case REPLICATE: 
            case SEARCH: 
            case DISK_COMPONENT_SCAN: 
            case MERGE: {
                ++this.readerCount;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operation " + opType);
            }
        }
        return true;
    }

    @Override
    public boolean threadExit(LSMOperationType opType, boolean failedOperation, boolean isMutableComponent) throws HyracksDataException {
        switch (opType) {
            case MERGE: {
                --this.readerCount;
                if (failedOperation) {
                    this.state = ILSMComponent.ComponentState.READABLE_UNWRITABLE;
                    break;
                }
                this.state = this.readerCount == 0 ? ILSMComponent.ComponentState.INACTIVE : ILSMComponent.ComponentState.UNREADABLE_UNWRITABLE;
                break;
            }
            case FORCE_MODIFICATION: 
            case MODIFICATION: 
            case REPLICATE: 
            case SEARCH: 
            case DISK_COMPONENT_SCAN: {
                --this.readerCount;
                if (this.readerCount != 0 || this.state != ILSMComponent.ComponentState.UNREADABLE_UNWRITABLE) break;
                this.state = ILSMComponent.ComponentState.INACTIVE;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operation " + opType);
            }
        }
        if (this.readerCount <= -1) {
            throw new IllegalStateException("Invalid LSM disk component readerCount: " + this.readerCount);
        }
        return false;
    }

    @Override
    public DiskComponentMetadata getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ILSMComponentId getId() throws HyracksDataException {
        if (this.componentId != null) {
            return this.componentId;
        }
        AbstractLSMDiskComponent abstractLSMDiskComponent = this;
        synchronized (abstractLSMDiskComponent) {
            if (this.componentId == null) {
                this.componentId = LSMComponentIdUtils.readFrom(this.metadata, this.buffer);
            }
        }
        if (this.componentId.missing()) {
            LOGGER.warn("component id {} not found from disk component metadata {}", (Object)this.componentId, (Object)this.getIndex());
        }
        return this.componentId;
    }

    @Override
    public void markAsValid(boolean persist, IPageWriteFailureCallback callback) throws HyracksDataException {
        ComponentUtils.markAsValid(this.getMetadataHolder(), persist, callback);
        LOGGER.debug("marked {} as valid component with id {}", (Object)this.getIndex(), (Object)this.getId());
    }

    @Override
    public void activate(boolean createNewComponent) throws HyracksDataException {
        if (createNewComponent) {
            this.getIndex().create();
        }
        this.getIndex().activate();
        if (this.getLSMComponentFilter() != null && !createNewComponent) {
            this.getLsmIndex().getFilterManager().readFilter(this.getLSMComponentFilter(), this.getMetadataHolder());
        }
    }

    @Override
    public final void deactivateAndDestroy() throws HyracksDataException {
        this.deactivateAndPurge();
        this.destroy();
    }

    @Override
    public final void deactivateAndPurge() throws HyracksDataException {
        this.deactivate();
        this.purge();
    }

    @Override
    public void destroy() throws HyracksDataException {
        this.getIndex().destroy();
    }

    @Override
    public void deactivate() throws HyracksDataException {
        this.getIndex().deactivate();
    }

    protected void purge() throws HyracksDataException {
        this.getIndex().purge();
    }

    @Override
    public void validate() throws HyracksDataException {
        this.getIndex().validate();
    }

    protected IChainedComponentBulkLoader createFilterBulkLoader() throws HyracksDataException {
        return new FilterBulkLoader(this.getLSMComponentFilter(), this.getMetadataHolder(), this.getLsmIndex().getFilterManager(), this.getLsmIndex().getTreeFields(), this.getLsmIndex().getFilterFields(), MultiComparator.create((IBinaryComparatorFactory[])this.getLSMComponentFilter().getFilterCmpFactories()));
    }

    protected IChainedComponentBulkLoader createIndexBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, IPageWriteCallback callback) throws HyracksDataException {
        return new LSMIndexBulkLoader(this.getIndex().createBulkLoader(fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, callback));
    }

    protected IChainedComponentBulkLoader createMergeIndexBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, IPageWriteCallback callback) throws HyracksDataException {
        return this.createIndexBulkLoader(fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, callback);
    }

    @Override
    public ChainedLSMDiskComponentBulkLoader createBulkLoader(ILSMIOOperation operation, float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, boolean withFilter, boolean cleanupEmptyComponent, IPageWriteCallback callback) throws HyracksDataException {
        ChainedLSMDiskComponentBulkLoader chainedBulkLoader = new ChainedLSMDiskComponentBulkLoader(operation, this, cleanupEmptyComponent);
        if (withFilter && this.getLsmIndex().getFilterFields() != null) {
            chainedBulkLoader.addBulkLoader(this.createFilterBulkLoader());
        }
        IChainedComponentBulkLoader indexBulkloader = operation.getIOOpertionType() == ILSMIOOperation.LSMIOOperationType.MERGE ? this.createMergeIndexBulkLoader(fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, callback) : this.createIndexBulkLoader(fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, callback);
        chainedBulkLoader.addBulkLoader(indexBulkloader);
        callback.initialize((IIndexBulkLoader)chainedBulkLoader);
        return chainedBulkLoader;
    }

    public String toString() {
        return "{\"class\":" + this.getClass().getSimpleName() + "\", \"id\":" + this.componentId + ", \"index\":" + this.getIndex() + "}";
    }
}

