/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.util.Arrays;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.typecomputer.impl.AbstractRecordFunctionTypeComputer;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;

public class RecordAddTypeComputer
extends AbstractRecordFunctionTypeComputer {
    public static final RecordAddTypeComputer INSTANCE = new RecordAddTypeComputer();

    private RecordAddTypeComputer() {
    }

    @Override
    public IAType computeTypeImpl(AbstractFunctionCallExpression functionCallExpression, IVariableTypeEnvironment env, ARecordType inputRecordType, boolean isOutputMissable, boolean isOutputNullable) throws AlgebricksException {
        ILogicalExpression arg2 = (ILogicalExpression)((Mutable)functionCallExpression.getArguments().get(2)).getValue();
        IAType type2 = (IAType)env.getType(arg2);
        IAType actualType2 = TypeComputeUtils.getActualType(type2);
        ATypeTag tag2 = actualType2.getTypeTag();
        if (tag2 == ATypeTag.MISSING) {
            IAType type0 = (IAType)env.getType((ILogicalExpression)((Mutable)functionCallExpression.getArguments().get(0)).getValue());
            return RecordAddTypeComputer.wrapTypeWithUnknown(type0, isOutputMissable, isOutputNullable);
        }
        ILogicalExpression arg1 = (ILogicalExpression)((Mutable)functionCallExpression.getArguments().get(1)).getValue();
        if (arg1.getExpressionTag() != LogicalExpressionTag.CONSTANT) {
            return RecordAddTypeComputer.wrapTypeWithUnknown(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE, isOutputMissable, isOutputNullable);
        }
        ConstantExpression constantExpression = (ConstantExpression)arg1;
        AsterixConstantValue constantValue = (AsterixConstantValue)constantExpression.getValue();
        String newFieldName = ((AString)constantValue.getObject()).getStringValue();
        ARecordType outputRecordType = inputRecordType;
        if (!Arrays.asList(inputRecordType.getFieldNames()).contains(newFieldName)) {
            String[] fieldNames = new String[inputRecordType.getFieldNames().length + 1];
            IAType[] fieldTypes = new IAType[inputRecordType.getFieldTypes().length + 1];
            for (int currentCursorPosition = 0; currentCursorPosition < inputRecordType.getFieldNames().length; ++currentCursorPosition) {
                fieldNames[currentCursorPosition] = inputRecordType.getFieldNames()[currentCursorPosition];
                fieldTypes[currentCursorPosition] = inputRecordType.getFieldTypes()[currentCursorPosition];
            }
            fieldNames[currentCursorPosition] = newFieldName;
            fieldTypes[currentCursorPosition] = type2;
            String inputTypeName = inputRecordType.getTypeName();
            String outputTypeName = inputTypeName != null ? inputTypeName + "_add_" + newFieldName : null;
            outputRecordType = new ARecordType(outputTypeName, fieldNames, fieldTypes, inputRecordType.isOpen());
        }
        return RecordAddTypeComputer.wrapTypeWithUnknown(outputRecordType, isOutputMissable, isOutputNullable);
    }
}

