/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.implementation.AccessTokenCache;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class BearerTokenAuthenticationPolicy
implements HttpPipelinePolicy {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER = "Bearer";
    private final String[] scopes;
    private final AccessTokenCache cache;

    public BearerTokenAuthenticationPolicy(TokenCredential credential, String ... scopes) {
        Objects.requireNonNull(credential);
        this.scopes = scopes;
        this.cache = new AccessTokenCache(credential);
    }

    public Mono<Void> authorizeRequest(HttpPipelineCallContext context) {
        if (this.scopes == null) {
            return Mono.empty();
        }
        return this.setAuthorizationHeaderHelper(context, new TokenRequestContext().addScopes(this.scopes), false);
    }

    public Mono<Boolean> authorizeRequestOnChallenge(HttpPipelineCallContext context, HttpResponse response) {
        return Mono.just((Object)false);
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if ("http".equals(context.getHttpRequest().getUrl().getProtocol())) {
            return Mono.error((Throwable)new RuntimeException("token credentials require a URL using the HTTPS protocol scheme"));
        }
        HttpPipelineNextPolicy nextPolicy = next.clone();
        return this.authorizeRequest(context).then(Mono.defer(() -> next.process())).flatMap(httpResponse -> {
            String authHeader = httpResponse.getHeaderValue("WWW-Authenticate");
            if (httpResponse.getStatusCode() == 401 && authHeader != null) {
                return this.authorizeRequestOnChallenge(context, (HttpResponse)httpResponse).flatMap(retry -> {
                    if (retry.booleanValue()) {
                        return nextPolicy.process();
                    }
                    return Mono.just((Object)httpResponse);
                });
            }
            return Mono.just((Object)httpResponse);
        });
    }

    public Mono<Void> setAuthorizationHeader(HttpPipelineCallContext context, TokenRequestContext tokenRequestContext) {
        return this.setAuthorizationHeaderHelper(context, tokenRequestContext, true);
    }

    private Mono<Void> setAuthorizationHeaderHelper(HttpPipelineCallContext context, TokenRequestContext tokenRequestContext, boolean checkToForceFetchToken) {
        return this.cache.getToken(tokenRequestContext, checkToForceFetchToken).flatMap(token -> {
            context.getHttpRequest().getHeaders().set(AUTHORIZATION_HEADER, "Bearer " + token.getToken());
            return Mono.empty();
        });
    }
}

