/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.control;

import java.io.Serializable;

public class CcId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private short id;

    private CcId(short id) {
        this.id = id;
    }

    public static CcId valueOf(String ccIdString) {
        return new CcId(Integer.decode(ccIdString).shortValue());
    }

    public static CcId valueOf(int ccId) {
        if ((ccId & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("ccId cannot exceed 16-bits: " + Integer.toHexString(ccId));
        }
        return new CcId((short)ccId);
    }

    public short shortValue() {
        return this.id;
    }

    public long toLongMask() {
        return (long)this.id << 48;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return obj instanceof CcId && this.id == ((CcId)obj).id;
    }

    public String toString() {
        return "CC:" + Integer.toHexString(this.id & 0xFFFF);
    }
}

