/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class AFloat
implements IAObject {
    protected float value;

    public AFloat(float value) {
        this.value = value;
    }

    public float getFloatValue() {
        return this.value;
    }

    @Override
    public IAType getType() {
        return BuiltinType.AFLOAT;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AFloat)) {
            return false;
        }
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(((AFloat)o).getFloatValue());
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return this.equals(obj);
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    public String toString() {
        return Float.toString(this.value);
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        json.put("AFloat", this.value);
        return json;
    }
}

