/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import org.apache.asterix.common.config.ActiveProperties;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.common.config.ExternalProperties;
import org.apache.asterix.common.config.MessagingProperties;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.config.NodeProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.asterix.common.config.ReplicationProperties;
import org.apache.asterix.common.config.StorageProperties;
import org.apache.asterix.common.config.TransactionProperties;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.hyracks.api.config.IConfigManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class AsterixProperties {
    public static final String SECTION_PREFIX_EXTENSION = "extension/";

    private AsterixProperties() {
    }

    public static String getSectionId(String prefix, String section) {
        return section.substring(prefix.length());
    }

    public static void registerConfigOptions(IConfigManager configManager) {
        configManager.register(new Class[]{NodeProperties.Option.class, CompilerProperties.Option.class, MetadataProperties.Option.class, ExternalProperties.Option.class, ActiveProperties.Option.class, MessagingProperties.Option.class, ReplicationProperties.Option.class, StorageProperties.Option.class, TransactionProperties.Option.class});
        configManager.addConfigurator(IConfigManager.ConfiguratorMetric.APPLY_DEFAULTS.metric() - 1, () -> {
            try {
                PropertiesAccessor.getInstance(configManager.getAppConfig());
            }
            catch (AsterixException e) {
                throw HyracksDataException.create((Throwable)((Object)e));
            }
        });
    }
}

