/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.dataflow;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IResource;

public class DatasetLocalResource
implements IResource {
    private static final long serialVersionUID = 1L;
    private final int datasetId;
    private int partition;
    private final IResource resource;

    public DatasetLocalResource(int datasetId, int partition, IResource resource) {
        this.datasetId = datasetId;
        this.partition = partition;
        this.resource = resource;
    }

    public int getPartition() {
        return this.partition;
    }

    public int getDatasetId() {
        return this.datasetId;
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public void setPath(String path) {
        this.resource.setPath(path);
    }

    public void setPartition(int partition) {
        this.partition = partition;
    }

    public IIndex createInstance(INCServiceContext ncServiceCtx) throws HyracksDataException {
        return this.resource.createInstance(ncServiceCtx);
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), 1L);
        json.put("datasetId", this.datasetId);
        json.put("partition", this.partition);
        json.set("resource", this.resource.toJson(registry));
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        int datasetId = json.get("datasetId").asInt();
        int partition = json.get("partition").asInt();
        IResource resource = (IResource)registry.deserialize(json.get("resource"));
        return new DatasetLocalResource(datasetId, partition, resource);
    }
}

