/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.ioopcallbacks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.common.api.IDatasetInfoProvider;
import org.apache.asterix.common.api.ILSMComponentIdGeneratorFactory;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.ioopcallbacks.LSMIOOperationCallback;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentIdGenerator;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.common.IResource;

public class LSMIndexIOOperationCallbackFactory
implements ILSMIOOperationCallbackFactory {
    private static final long serialVersionUID = 1L;
    protected final ILSMComponentIdGeneratorFactory idGeneratorFactory;
    protected final IDatasetInfoProvider datasetInfoProvider;
    protected transient INCServiceContext ncCtx;
    protected transient IResource resource;

    public LSMIndexIOOperationCallbackFactory(ILSMComponentIdGeneratorFactory idGeneratorFactory, IDatasetInfoProvider datasetInfoProvider) {
        this.idGeneratorFactory = idGeneratorFactory;
        this.datasetInfoProvider = datasetInfoProvider;
    }

    public void initialize(INCServiceContext ncCtx, IResource resource) {
        this.ncCtx = ncCtx;
        this.resource = resource;
    }

    protected ILSMComponentIdGenerator getComponentIdGenerator() throws HyracksDataException {
        return this.idGeneratorFactory.getComponentIdGenerator(this.ncCtx, this.resource);
    }

    protected IIndexCheckpointManagerProvider getIndexCheckpointManagerProvider() {
        return ((INcApplicationContext)this.ncCtx.getApplicationContext()).getIndexCheckpointManagerProvider();
    }

    public ILSMIOOperationCallback createIoOpCallback(ILSMIndex index) throws HyracksDataException {
        return new LSMIOOperationCallback(this.datasetInfoProvider.getDatasetInfo(this.ncCtx), index, this.getComponentIdGenerator().getId(), this.getIndexCheckpointManagerProvider());
    }

    public int getCurrentMemoryComponentIndex() throws HyracksDataException {
        return this.idGeneratorFactory.getComponentIdGenerator(this.ncCtx, this.resource).getCurrentComponentIndex();
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), 1L);
        json.set("idGeneratorFactory", this.idGeneratorFactory.toJson(registry));
        json.set("datasetInfoProvider", this.datasetInfoProvider.toJson(registry));
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        ILSMComponentIdGeneratorFactory idGeneratorFactory = (ILSMComponentIdGeneratorFactory)registry.deserialize(json.get("idGeneratorFactory"));
        IDatasetInfoProvider datasetInfoProvider = (IDatasetInfoProvider)registry.deserialize(json.get("datasetInfoProvider"));
        return new LSMIndexIOOperationCallbackFactory(idGeneratorFactory, datasetInfoProvider);
    }
}

