/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.metadata.IProjectionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class OperatorDeepCopyVisitor
implements ILogicalOperatorVisitor<ILogicalOperator, Void> {
    @Override
    public ILogicalOperator visitAggregateOperator(AggregateOperator op, Void arg) throws AlgebricksException {
        ArrayList<LogicalVariable> newList = new ArrayList<LogicalVariable>();
        ArrayList<Mutable<ILogicalExpression>> newExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        newList.addAll(op.getVariables());
        this.deepCopyExpressionRefs(newExpressions, op.getExpressions());
        return new AggregateOperator(newList, newExpressions);
    }

    @Override
    public ILogicalOperator visitRunningAggregateOperator(RunningAggregateOperator op, Void arg) throws AlgebricksException {
        ArrayList<LogicalVariable> newList = new ArrayList<LogicalVariable>();
        ArrayList<Mutable<ILogicalExpression>> newExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        newList.addAll(op.getVariables());
        this.deepCopyExpressionRefs(newExpressions, op.getExpressions());
        return new RunningAggregateOperator(newList, newExpressions);
    }

    @Override
    public ILogicalOperator visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Void arg) throws AlgebricksException {
        return new EmptyTupleSourceOperator();
    }

    @Override
    public ILogicalOperator visitGroupByOperator(GroupByOperator op, Void arg) throws AlgebricksException {
        ArrayList<Pair<LogicalVariable, Mutable<ILogicalExpression>>> groupByList = new ArrayList<Pair<LogicalVariable, Mutable<ILogicalExpression>>>();
        ArrayList<Pair<LogicalVariable, Mutable<ILogicalExpression>>> decoList = new ArrayList<Pair<LogicalVariable, Mutable<ILogicalExpression>>>();
        ArrayList<ILogicalPlan> newSubplans = new ArrayList<ILogicalPlan>();
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> pair : op.getGroupByList()) {
            groupByList.add((Pair<LogicalVariable, Mutable<ILogicalExpression>>)new Pair((Object)((LogicalVariable)pair.first), this.deepCopyExpressionRef((Mutable<ILogicalExpression>)((Mutable)pair.second))));
        }
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> pair : op.getDecorList()) {
            decoList.add((Pair<LogicalVariable, Mutable<ILogicalExpression>>)new Pair((Object)((LogicalVariable)pair.first), this.deepCopyExpressionRef((Mutable<ILogicalExpression>)((Mutable)pair.second))));
        }
        GroupByOperator gbyOp = new GroupByOperator(groupByList, decoList, newSubplans, op.isGroupAll());
        for (ILogicalPlan plan : op.getNestedPlans()) {
            newSubplans.add(OperatorManipulationUtil.deepCopy(plan, gbyOp));
        }
        return gbyOp;
    }

    @Override
    public ILogicalOperator visitLimitOperator(LimitOperator op, Void arg) throws AlgebricksException {
        return new LimitOperator((ILogicalExpression)this.deepCopyExpressionRef(op.getMaxObjects()).getValue(), (ILogicalExpression)this.deepCopyExpressionRef(op.getOffset()).getValue(), op.isTopmostLimitOp());
    }

    @Override
    public ILogicalOperator visitInnerJoinOperator(InnerJoinOperator op, Void arg) throws AlgebricksException {
        return new InnerJoinOperator(this.deepCopyExpressionRef(op.getCondition()), op.getInputs().get(0), op.getInputs().get(1));
    }

    @Override
    public ILogicalOperator visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Void arg) throws AlgebricksException {
        return new LeftOuterJoinOperator(this.deepCopyExpressionRef(op.getCondition()), op.getInputs().get(0), op.getInputs().get(1), op.getMissingValue());
    }

    @Override
    public ILogicalOperator visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Void arg) throws AlgebricksException {
        return new NestedTupleSourceOperator(op.getDataSourceReference());
    }

    @Override
    public ILogicalOperator visitOrderOperator(OrderOperator op, Void arg) throws AlgebricksException {
        return new OrderOperator(this.deepCopyOrderAndExpression(op.getOrderExpressions()));
    }

    @Override
    public ILogicalOperator visitAssignOperator(AssignOperator op, Void arg) throws AlgebricksException {
        ArrayList<LogicalVariable> newList = new ArrayList<LogicalVariable>();
        ArrayList<Mutable<ILogicalExpression>> newExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        newList.addAll(op.getVariables());
        this.deepCopyExpressionRefs(newExpressions, op.getExpressions());
        return new AssignOperator(newList, newExpressions);
    }

    @Override
    public ILogicalOperator visitSelectOperator(SelectOperator op, Void arg) throws AlgebricksException {
        return new SelectOperator(this.deepCopyExpressionRef(op.getCondition()), op.getRetainMissingAsValue(), op.getMissingPlaceholderVariable());
    }

    @Override
    public ILogicalOperator visitProjectOperator(ProjectOperator op, Void arg) throws AlgebricksException {
        ArrayList<LogicalVariable> newList = new ArrayList<LogicalVariable>();
        newList.addAll(op.getVariables());
        return new ProjectOperator(newList);
    }

    @Override
    public ILogicalOperator visitReplicateOperator(ReplicateOperator op, Void arg) throws AlgebricksException {
        return new ReplicateOperator(op.getOutputArity());
    }

    @Override
    public ILogicalOperator visitSplitOperator(SplitOperator op, Void arg) throws AlgebricksException {
        return new SplitOperator(op.getOutputArity(), op.getBranchingExpression());
    }

    @Override
    public ILogicalOperator visitScriptOperator(ScriptOperator op, Void arg) throws AlgebricksException {
        ArrayList<LogicalVariable> newInputList = new ArrayList<LogicalVariable>();
        ArrayList<LogicalVariable> newOutputList = new ArrayList<LogicalVariable>();
        newInputList.addAll(op.getInputVariables());
        newOutputList.addAll(op.getOutputVariables());
        return new ScriptOperator(op.getScriptDescription(), newInputList, newOutputList);
    }

    @Override
    public ILogicalOperator visitSubplanOperator(SubplanOperator op, Void arg) throws AlgebricksException {
        ArrayList<ILogicalPlan> newSubplans = new ArrayList<ILogicalPlan>();
        SubplanOperator subplanOp = new SubplanOperator(newSubplans);
        for (ILogicalPlan plan : op.getNestedPlans()) {
            newSubplans.add(OperatorManipulationUtil.deepCopy(plan, subplanOp));
        }
        return subplanOp;
    }

    @Override
    public ILogicalOperator visitUnionOperator(UnionAllOperator op, Void arg) throws AlgebricksException {
        ArrayList<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> newVarMap = new ArrayList<Triple<LogicalVariable, LogicalVariable, LogicalVariable>>();
        List<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> varMap = op.getVariableMappings();
        for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> triple : varMap) {
            newVarMap.add((Triple<LogicalVariable, LogicalVariable, LogicalVariable>)new Triple((Object)((LogicalVariable)triple.first), (Object)((LogicalVariable)triple.second), (Object)((LogicalVariable)triple.third)));
        }
        return new UnionAllOperator(newVarMap);
    }

    @Override
    public ILogicalOperator visitIntersectOperator(IntersectOperator op, Void arg) throws AlgebricksException {
        int nInput = op.getNumInput();
        boolean hasExtraVars = op.hasExtraVariables();
        ArrayList<LogicalVariable> newOutputCompareVars = new ArrayList<LogicalVariable>(op.getOutputCompareVariables());
        ArrayList<LogicalVariable> newOutputExtraVars = hasExtraVars ? new ArrayList<LogicalVariable>(op.getOutputExtraVariables()) : null;
        ArrayList<List<LogicalVariable>> newInputCompareVars = new ArrayList<List<LogicalVariable>>(nInput);
        ArrayList<List<LogicalVariable>> newInputExtraVars = hasExtraVars ? new ArrayList<List<LogicalVariable>>(nInput) : null;
        for (int i = 0; i < nInput; ++i) {
            newInputCompareVars.add(new ArrayList<LogicalVariable>(op.getInputCompareVariables(i)));
            if (!hasExtraVars) continue;
            newInputExtraVars.add(new ArrayList<LogicalVariable>(op.getInputExtraVariables(i)));
        }
        return new IntersectOperator(newOutputCompareVars, newOutputExtraVars, newInputCompareVars, newInputExtraVars);
    }

    @Override
    public ILogicalOperator visitUnnestOperator(UnnestOperator op, Void arg) throws AlgebricksException {
        return new UnnestOperator(op.getVariable(), this.deepCopyExpressionRef(op.getExpressionRef()), op.getPositionalVariable(), op.getPositionalVariableType());
    }

    @Override
    public ILogicalOperator visitUnnestMapOperator(UnnestMapOperator op, Void arg) throws AlgebricksException {
        ArrayList<LogicalVariable> newInputList = new ArrayList<LogicalVariable>();
        newInputList.addAll(op.getVariables());
        Mutable<ILogicalExpression> newSelectCondition = op.getSelectCondition() != null ? this.deepCopyExpressionRef(op.getSelectCondition()) : null;
        return new UnnestMapOperator(newInputList, this.deepCopyExpressionRef(op.getExpressionRef()), new ArrayList<Object>(op.getVariableTypes()), op.propagatesInput(), newSelectCondition, op.getOutputLimit());
    }

    @Override
    public ILogicalOperator visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Void arg) throws AlgebricksException {
        ArrayList<LogicalVariable> newInputList = new ArrayList<LogicalVariable>();
        newInputList.addAll(op.getVariables());
        return new LeftOuterUnnestMapOperator(newInputList, this.deepCopyExpressionRef(op.getExpressionRef()), new ArrayList<Object>(op.getVariableTypes()), op.getMissingValue());
    }

    @Override
    public ILogicalOperator visitDataScanOperator(DataSourceScanOperator op, Void arg) throws AlgebricksException {
        ArrayList<LogicalVariable> newInputList = new ArrayList<LogicalVariable>();
        newInputList.addAll(op.getVariables());
        Mutable<ILogicalExpression> newSelectCondition = op.getSelectCondition() != null ? this.deepCopyExpressionRef(op.getSelectCondition()) : null;
        IProjectionInfo<?> projectionInfo = op.getProjectionInfo() != null ? op.getProjectionInfo().createCopy() : null;
        return new DataSourceScanOperator(newInputList, op.getDataSource(), newSelectCondition, op.getOutputLimit(), projectionInfo);
    }

    @Override
    public ILogicalOperator visitDistinctOperator(DistinctOperator op, Void arg) throws AlgebricksException {
        ArrayList<Mutable<ILogicalExpression>> newExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newExpressions, op.getExpressions());
        return new DistinctOperator(newExpressions);
    }

    @Override
    public ILogicalOperator visitExchangeOperator(ExchangeOperator op, Void arg) throws AlgebricksException {
        return new ExchangeOperator();
    }

    @Override
    public ILogicalOperator visitWriteOperator(WriteOperator op, Void arg) throws AlgebricksException {
        ArrayList<Mutable<ILogicalExpression>> newExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newExpressions, op.getExpressions());
        return new WriteOperator(newExpressions, op.getDataSink());
    }

    @Override
    public ILogicalOperator visitDistributeResultOperator(DistributeResultOperator op, Void arg) throws AlgebricksException {
        ArrayList<Mutable<ILogicalExpression>> newExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newExpressions, op.getExpressions());
        return new DistributeResultOperator(newExpressions, op.getDataSink(), op.getResultMetadata());
    }

    @Override
    public ILogicalOperator visitWriteResultOperator(WriteResultOperator op, Void arg) throws AlgebricksException {
        ArrayList<Mutable<ILogicalExpression>> newKeyExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newKeyExpressions, op.getKeyExpressions());
        ArrayList<Mutable<ILogicalExpression>> newLSMComponentFilterExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newKeyExpressions, op.getAdditionalFilteringExpressions());
        WriteResultOperator writeResultOp = new WriteResultOperator(op.getDataSource(), this.deepCopyExpressionRef(op.getPayloadExpression()), newKeyExpressions);
        writeResultOp.setAdditionalFilteringExpressions(newLSMComponentFilterExpressions);
        return writeResultOp;
    }

    @Override
    public ILogicalOperator visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Void arg) throws AlgebricksException {
        ArrayList<Mutable<ILogicalExpression>> newKeyExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newKeyExpressions, op.getPrimaryKeyExpressions());
        ArrayList<Mutable<ILogicalExpression>> newLSMComponentFilterExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newKeyExpressions, op.getAdditionalFilteringExpressions());
        InsertDeleteUpsertOperator insertDeleteOp = new InsertDeleteUpsertOperator(op.getDataSource(), this.deepCopyExpressionRef(op.getPayloadExpression()), newKeyExpressions, op.getOperation(), op.isBulkload());
        insertDeleteOp.setAdditionalFilteringExpressions(newLSMComponentFilterExpressions);
        return insertDeleteOp;
    }

    @Override
    public ILogicalOperator visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Void arg) throws AlgebricksException {
        ArrayList<Mutable<ILogicalExpression>> newPrimaryKeyExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newPrimaryKeyExpressions, op.getPrimaryKeyExpressions());
        ArrayList<Mutable<ILogicalExpression>> newSecondaryKeyExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newSecondaryKeyExpressions, op.getSecondaryKeyExpressions());
        MutableObject newFilterExpression = new MutableObject((Object)((AbstractLogicalExpression)op.getFilterExpression()).cloneExpression());
        MutableObject newBeforeOpFilterExpression = new MutableObject((Object)((AbstractLogicalExpression)op.getBeforeOpFilterExpression()).cloneExpression());
        ArrayList<Mutable<ILogicalExpression>> newLSMComponentFilterExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newLSMComponentFilterExpressions, op.getAdditionalFilteringExpressions());
        IndexInsertDeleteUpsertOperator indexInsertDeleteOp = new IndexInsertDeleteUpsertOperator(op.getDataSourceIndex(), newPrimaryKeyExpressions, newSecondaryKeyExpressions, (Mutable<ILogicalExpression>)newFilterExpression, (Mutable<ILogicalExpression>)newBeforeOpFilterExpression, op.getOperation(), op.isBulkload(), op.getNumberOfAdditionalNonFilteringFields());
        indexInsertDeleteOp.setAdditionalFilteringExpressions(newLSMComponentFilterExpressions);
        for (ILogicalPlan plan : op.getNestedPlans()) {
            indexInsertDeleteOp.getNestedPlans().add(OperatorManipulationUtil.deepCopy(plan, indexInsertDeleteOp));
        }
        return indexInsertDeleteOp;
    }

    @Override
    public ILogicalOperator visitTokenizeOperator(TokenizeOperator op, Void arg) throws AlgebricksException {
        ArrayList<Mutable<ILogicalExpression>> newPrimaryKeyExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newPrimaryKeyExpressions, op.getPrimaryKeyExpressions());
        ArrayList<Mutable<ILogicalExpression>> newSecondaryKeyExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newSecondaryKeyExpressions, op.getSecondaryKeyExpressions());
        ArrayList<LogicalVariable> newTokenizeVars = new ArrayList<LogicalVariable>();
        this.deepCopyVars(newTokenizeVars, op.getTokenizeVars());
        MutableObject newFilterExpression = new MutableObject((Object)((AbstractLogicalExpression)op.getFilterExpression()).cloneExpression());
        ArrayList<Object> newTokenizeVarTypes = new ArrayList<Object>();
        this.deepCopyObjects(newTokenizeVarTypes, op.getTokenizeVarTypes());
        TokenizeOperator tokenizeOp = new TokenizeOperator(op.getDataSourceIndex(), newPrimaryKeyExpressions, newSecondaryKeyExpressions, newTokenizeVars, (Mutable<ILogicalExpression>)newFilterExpression, op.getOperation(), op.isBulkload(), op.isPartitioned(), newTokenizeVarTypes);
        return tokenizeOp;
    }

    @Override
    public ILogicalOperator visitForwardOperator(ForwardOperator op, Void arg) throws AlgebricksException {
        return new ForwardOperator(op.getSideDataKey(), this.deepCopyExpressionRef(op.getSideDataExpression()));
    }

    @Override
    public ILogicalOperator visitSinkOperator(SinkOperator op, Void arg) throws AlgebricksException {
        return new SinkOperator();
    }

    private void deepCopyExpressionRefs(List<Mutable<ILogicalExpression>> newExprs, List<Mutable<ILogicalExpression>> oldExprs) {
        for (Mutable<ILogicalExpression> oldExpr : oldExprs) {
            newExprs.add((Mutable<ILogicalExpression>)new MutableObject((Object)((AbstractLogicalExpression)oldExpr.getValue()).cloneExpression()));
        }
    }

    private Mutable<ILogicalExpression> deepCopyExpressionRef(Mutable<ILogicalExpression> oldExprRef) {
        ILogicalExpression oldExpr = (ILogicalExpression)oldExprRef.getValue();
        if (oldExpr == null) {
            return new MutableObject(null);
        }
        return new MutableObject((Object)oldExpr.cloneExpression());
    }

    private List<LogicalVariable> deepCopyVars(List<LogicalVariable> newVars, List<LogicalVariable> oldVars) {
        for (LogicalVariable oldVar : oldVars) {
            newVars.add(oldVar);
        }
        return newVars;
    }

    private List<Object> deepCopyObjects(List<Object> newObjs, List<Object> oldObjs) {
        for (Object oldObj : oldObjs) {
            newObjs.add(oldObj);
        }
        return newObjs;
    }

    private List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> deepCopyOrderAndExpression(List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> ordersAndExprs) {
        ArrayList<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> newOrdersAndExprs = new ArrayList<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>>();
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> pair : ordersAndExprs) {
            newOrdersAndExprs.add((Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>)new Pair((Object)((OrderOperator.IOrder)pair.first), this.deepCopyExpressionRef((Mutable<ILogicalExpression>)((Mutable)pair.second))));
        }
        return newOrdersAndExprs;
    }

    @Override
    public ILogicalOperator visitDelegateOperator(DelegateOperator op, Void arg) throws AlgebricksException {
        return new DelegateOperator(op.getNewInstanceOfDelegateOperator());
    }

    @Override
    public ILogicalOperator visitMaterializeOperator(MaterializeOperator op, Void arg) throws AlgebricksException {
        return new MaterializeOperator();
    }

    @Override
    public ILogicalOperator visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Void arg) throws AlgebricksException {
        return new LeftOuterUnnestOperator(op.getVariable(), this.deepCopyExpressionRef(op.getExpressionRef()), op.getPositionalVariable(), op.getPositionalVariableType(), op.getMissingValue());
    }

    @Override
    public ILogicalOperator visitWindowOperator(WindowOperator op, Void arg) throws AlgebricksException {
        ArrayList<Mutable<ILogicalExpression>> newPartitionExprs = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(op.getPartitionExpressions(), newPartitionExprs);
        List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> newOrderExprs = this.deepCopyOrderAndExpression(op.getOrderExpressions());
        List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> newFrameValueExprs = this.deepCopyOrderAndExpression(op.getFrameValueExpressions());
        ArrayList<Mutable<ILogicalExpression>> newFrameStartExprs = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newFrameStartExprs, op.getFrameStartExpressions());
        ArrayList<Mutable<ILogicalExpression>> newFrameStartValidationExprs = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newFrameStartValidationExprs, op.getFrameStartValidationExpressions());
        ArrayList<Mutable<ILogicalExpression>> newFrameEndExprs = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newFrameEndExprs, op.getFrameEndExpressions());
        ArrayList<Mutable<ILogicalExpression>> newFrameEndValidationExprs = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newFrameEndValidationExprs, op.getFrameEndValidationExpressions());
        ArrayList<Mutable<ILogicalExpression>> newFrameExclusionExprs = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newFrameExclusionExprs, op.getFrameExcludeExpressions());
        ILogicalExpression newFrameExcludeUnaryExpr = (ILogicalExpression)this.deepCopyExpressionRef(op.getFrameExcludeUnaryExpression()).getValue();
        ILogicalExpression newFrameOffsetExpr = (ILogicalExpression)this.deepCopyExpressionRef(op.getFrameOffsetExpression()).getValue();
        ArrayList<LogicalVariable> newVariables = new ArrayList<LogicalVariable>();
        this.deepCopyVars(newVariables, op.getVariables());
        ArrayList<Mutable<ILogicalExpression>> newExpressions = new ArrayList<Mutable<ILogicalExpression>>();
        this.deepCopyExpressionRefs(newExpressions, op.getExpressions());
        WindowOperator newWinOp = new WindowOperator(newPartitionExprs, newOrderExprs, newFrameValueExprs, newFrameStartExprs, newFrameStartValidationExprs, newFrameEndExprs, newFrameEndValidationExprs, newFrameExclusionExprs, op.getFrameExcludeNegationStartIdx(), newFrameExcludeUnaryExpr, newFrameOffsetExpr, op.getFrameMaxObjects(), newVariables, newExpressions, null);
        List<ILogicalPlan> newNestedPlans = newWinOp.getNestedPlans();
        for (ILogicalPlan nestedPlan : op.getNestedPlans()) {
            newNestedPlans.add(OperatorManipulationUtil.deepCopy(nestedPlan, newWinOp));
        }
        return newWinOp;
    }
}

