/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords.impl.pb;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Range;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.protobuf.MessageOrBuilder;
import org.apache.hadoop.thirdparty.protobuf.TextFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class GetApplicationsRequestPBImpl
extends GetApplicationsRequest {
    YarnServiceProtos.GetApplicationsRequestProto proto = YarnServiceProtos.GetApplicationsRequestProto.getDefaultInstance();
    YarnServiceProtos.GetApplicationsRequestProto.Builder builder = null;
    boolean viaProto = false;
    Set<String> applicationTypes = null;
    EnumSet<YarnApplicationState> applicationStates = null;
    Set<String> users = null;
    Set<String> queues = null;
    long limit = Long.MAX_VALUE;
    Range<Long> start = null;
    Range<Long> finish = null;
    private Set<String> applicationTags;
    private ApplicationsRequestScope scope;
    private String name;

    public GetApplicationsRequestPBImpl() {
        this.builder = YarnServiceProtos.GetApplicationsRequestProto.newBuilder();
    }

    public GetApplicationsRequestPBImpl(YarnServiceProtos.GetApplicationsRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnServiceProtos.GetApplicationsRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.applicationTypes != null && !this.applicationTypes.isEmpty()) {
            this.builder.clearApplicationTypes();
            this.builder.addAllApplicationTypes(this.applicationTypes);
        }
        if (this.applicationStates != null && !this.applicationStates.isEmpty()) {
            this.builder.clearApplicationStates();
            this.applicationStates.forEach(input -> this.builder.addApplicationStates(ProtoUtils.convertToProtoFormat(input)));
        }
        if (this.applicationTags != null && !this.applicationTags.isEmpty()) {
            this.builder.clearApplicationTags();
            this.builder.addAllApplicationTags(this.applicationTags);
        }
        if (this.scope != null) {
            this.builder.setScope(ProtoUtils.convertToProtoFormat(this.scope));
        }
        if (this.start != null) {
            this.builder.setStartBegin(((Long)this.start.getMinimum()).longValue());
            this.builder.setStartEnd(((Long)this.start.getMaximum()).longValue());
        }
        if (this.finish != null) {
            this.builder.setFinishBegin(((Long)this.finish.getMinimum()).longValue());
            this.builder.setFinishEnd(((Long)this.finish.getMaximum()).longValue());
        }
        if (this.limit != Long.MAX_VALUE) {
            this.builder.setLimit(this.limit);
        }
        if (this.users != null && !this.users.isEmpty()) {
            this.builder.clearUsers();
            this.builder.addAllUsers(this.users);
        }
        if (this.queues != null && !this.queues.isEmpty()) {
            this.builder.clearQueues();
            this.builder.addAllQueues(this.queues);
        }
        if (this.name != null) {
            this.builder.setName(this.name);
        }
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServiceProtos.GetApplicationsRequestProto.newBuilder((YarnServiceProtos.GetApplicationsRequestProto)this.proto);
        }
        this.viaProto = false;
    }

    private void initApplicationTypes() {
        if (this.applicationTypes != null) {
            return;
        }
        YarnServiceProtos.GetApplicationsRequestProto p = this.viaProto ? this.proto : this.builder;
        List appTypeList = p.getApplicationTypesList();
        this.applicationTypes = new HashSet<String>();
        this.applicationTypes.addAll(appTypeList);
    }

    private void initApplicationStates() {
        if (this.applicationStates != null) {
            return;
        }
        YarnServiceProtos.GetApplicationsRequestProto p = this.viaProto ? this.proto : this.builder;
        List appStatesList = p.getApplicationStatesList();
        this.applicationStates = EnumSet.noneOf(YarnApplicationState.class);
        for (YarnProtos.YarnApplicationStateProto c : appStatesList) {
            this.applicationStates.add(ProtoUtils.convertFromProtoFormat(c));
        }
    }

    private void initUsers() {
        if (this.users != null) {
            return;
        }
        YarnServiceProtos.GetApplicationsRequestProto p = this.viaProto ? this.proto : this.builder;
        List usersList = p.getUsersList();
        this.users = new HashSet<String>();
        this.users.addAll(usersList);
    }

    private void initQueues() {
        if (this.queues != null) {
            return;
        }
        YarnServiceProtos.GetApplicationsRequestProto p = this.viaProto ? this.proto : this.builder;
        List queuesList = p.getQueuesList();
        this.queues = new HashSet<String>();
        this.queues.addAll(queuesList);
    }

    public synchronized Set<String> getApplicationTypes() {
        this.initApplicationTypes();
        return this.applicationTypes;
    }

    public synchronized void setApplicationTypes(Set<String> applicationTypes) {
        this.maybeInitBuilder();
        if (applicationTypes == null) {
            this.builder.clearApplicationTypes();
        }
        this.applicationTypes = applicationTypes;
    }

    private void initApplicationTags() {
        if (this.applicationTags != null) {
            return;
        }
        YarnServiceProtos.GetApplicationsRequestProto p = this.viaProto ? this.proto : this.builder;
        this.applicationTags = new HashSet<String>();
        this.applicationTags.addAll(p.getApplicationTagsList());
    }

    public synchronized Set<String> getApplicationTags() {
        this.initApplicationTags();
        return this.applicationTags;
    }

    public synchronized void setApplicationTags(Set<String> tags) {
        this.maybeInitBuilder();
        if (tags == null || tags.isEmpty()) {
            this.builder.clearApplicationTags();
            this.applicationTags = null;
            return;
        }
        this.applicationTags = new HashSet<String>();
        for (String tag : tags) {
            this.applicationTags.add(StringUtils.toLowerCase((String)tag));
        }
    }

    public synchronized EnumSet<YarnApplicationState> getApplicationStates() {
        this.initApplicationStates();
        return this.applicationStates;
    }

    private void initScope() {
        if (this.scope != null) {
            return;
        }
        YarnServiceProtos.GetApplicationsRequestProto p = this.viaProto ? this.proto : this.builder;
        this.scope = ProtoUtils.convertFromProtoFormat(p.getScope());
    }

    public synchronized ApplicationsRequestScope getScope() {
        this.initScope();
        return this.scope;
    }

    public synchronized void setScope(ApplicationsRequestScope scope) {
        this.maybeInitBuilder();
        if (scope == null) {
            this.builder.clearScope();
        }
        this.scope = scope;
    }

    public synchronized void setApplicationStates(EnumSet<YarnApplicationState> applicationStates) {
        this.maybeInitBuilder();
        if (applicationStates == null) {
            this.builder.clearApplicationStates();
        }
        this.applicationStates = applicationStates;
    }

    public synchronized void setApplicationStates(Set<String> applicationStates) {
        EnumSet<YarnApplicationState> appStates = null;
        for (YarnApplicationState state : YarnApplicationState.values()) {
            if (!applicationStates.contains(StringUtils.toLowerCase((String)state.name()))) continue;
            if (appStates == null) {
                appStates = EnumSet.of(state);
                continue;
            }
            appStates.add(state);
        }
        this.setApplicationStates(appStates);
    }

    public synchronized Set<String> getUsers() {
        this.initUsers();
        return this.users;
    }

    public synchronized void setUsers(Set<String> users) {
        this.maybeInitBuilder();
        if (users == null) {
            this.builder.clearUsers();
        }
        this.users = users;
    }

    public synchronized Set<String> getQueues() {
        this.initQueues();
        return this.queues;
    }

    public synchronized void setQueues(Set<String> queues) {
        this.maybeInitBuilder();
        if (queues == null) {
            this.builder.clearQueues();
        }
        this.queues = queues;
    }

    public synchronized long getLimit() {
        if (this.limit == Long.MAX_VALUE) {
            YarnServiceProtos.GetApplicationsRequestProto p = this.viaProto ? this.proto : this.builder;
            this.limit = p.hasLimit() ? p.getLimit() : Long.MAX_VALUE;
        }
        return this.limit;
    }

    public synchronized void setLimit(long limit) {
        this.maybeInitBuilder();
        this.limit = limit;
    }

    public synchronized Range<Long> getStartRange() {
        if (this.start == null) {
            YarnServiceProtos.GetApplicationsRequestProto p;
            Object object = p = this.viaProto ? this.proto : this.builder;
            if (p.hasStartBegin() || p.hasStartEnd()) {
                long begin = p.hasStartBegin() ? p.getStartBegin() : 0L;
                long end = p.hasStartEnd() ? p.getStartEnd() : Long.MAX_VALUE;
                this.start = Range.between((Comparable)Long.valueOf(begin), (Comparable)Long.valueOf(end));
            }
        }
        return this.start;
    }

    public synchronized void setStartRange(Range<Long> range) {
        this.start = range;
    }

    public synchronized void setStartRange(long begin, long end) throws IllegalArgumentException {
        if (begin > end) {
            throw new IllegalArgumentException("begin > end in range (begin, end): (" + begin + ", " + end + ")");
        }
        this.start = Range.between((Comparable)Long.valueOf(begin), (Comparable)Long.valueOf(end));
    }

    public synchronized Range<Long> getFinishRange() {
        if (this.finish == null) {
            YarnServiceProtos.GetApplicationsRequestProto p;
            Object object = p = this.viaProto ? this.proto : this.builder;
            if (p.hasFinishBegin() || p.hasFinishEnd()) {
                long begin = p.hasFinishBegin() ? p.getFinishBegin() : 0L;
                long end = p.hasFinishEnd() ? p.getFinishEnd() : Long.MAX_VALUE;
                this.finish = Range.between((Comparable)Long.valueOf(begin), (Comparable)Long.valueOf(end));
            }
        }
        return this.finish;
    }

    public synchronized void setFinishRange(Range<Long> range) {
        this.finish = range;
    }

    public synchronized void setFinishRange(long begin, long end) {
        if (begin > end) {
            throw new IllegalArgumentException("begin > end in range (begin, end): (" + begin + ", " + end + ")");
        }
        this.finish = Range.between((Comparable)Long.valueOf(begin), (Comparable)Long.valueOf(end));
    }

    public synchronized String getName() {
        YarnServiceProtos.GetApplicationsRequestProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.name != null) {
            return this.name;
        }
        if (p.hasName()) {
            this.name = p.getName();
        }
        return this.name;
    }

    public synchronized void setName(String name) {
        this.maybeInitBuilder();
        if (name == null) {
            this.builder.clearName();
        }
        this.name = name;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((GetApplicationsRequestPBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }
}

