/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.indexing.IndexingConstants;
import org.apache.asterix.formats.nontagged.TypeTraitProvider;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.InternalDatasetDetails;
import org.apache.asterix.metadata.utils.ArrayIndexUtil;
import org.apache.asterix.metadata.utils.DatasetUtil;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.metadata.utils.SecondaryTreeIndexOperationsHelper;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.utils.RuntimeUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraintHelper;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.jobgen.impl.ConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import org.apache.hyracks.algebricks.data.ISerializerDeserializerProvider;
import org.apache.hyracks.algebricks.data.ITypeTraitProvider;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.aggreg.SimpleAlgebricksAccumulatingAggregatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.base.SinkRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.algebricks.runtime.operators.std.AssignRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.std.UnnestRuntimeFactory;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.job.IConnectorDescriptorRegistry;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.connectors.OneToOneConnectorDescriptor;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.preclustered.PreclusteredGroupOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelperFactory;

public class SecondaryArrayIndexBTreeOperationsHelper
extends SecondaryTreeIndexOperationsHelper {
    private final int numAtomicSecondaryKeys;
    private final int numArraySecondaryKeys;
    private final int numTotalSecondaryKeys;
    private final EvalFactoryAndRecDescStackBuilder evalFactoryAndRecDescStackBuilder = new EvalFactoryAndRecDescStackBuilder();
    private final Index.ArrayIndexDetails arrayIndexDetails;
    private final List<List<String>> flattenedFieldNames;
    private final List<IAType> flattenedKeyTypes;
    private final List<List<Boolean>> unnestFlags;

    protected SecondaryArrayIndexBTreeOperationsHelper(Dataset dataset, Index index, MetadataProvider metadataProvider, SourceLocation sourceLoc) throws AlgebricksException {
        super(dataset, index, metadataProvider, sourceLoc);
        this.arrayIndexDetails = (Index.ArrayIndexDetails)index.getIndexDetails();
        this.flattenedFieldNames = new ArrayList<List<String>>();
        this.flattenedKeyTypes = new ArrayList<IAType>();
        this.unnestFlags = new ArrayList<List<Boolean>>();
        for (Index.ArrayIndexElement e : this.arrayIndexDetails.getElementList()) {
            if (e.getUnnestList().isEmpty()) {
                this.flattenedFieldNames.add(e.getProjectList().get(0));
                this.flattenedKeyTypes.add(e.getTypeList().get(0));
                this.unnestFlags.add(ArrayIndexUtil.getUnnestFlags(e.getUnnestList(), e.getProjectList().get(0)));
                continue;
            }
            for (int i = 0; i < e.getProjectList().size(); ++i) {
                List<String> project = e.getProjectList().get(i);
                this.flattenedFieldNames.add(ArrayIndexUtil.getFlattenedKeyFieldNames(e.getUnnestList(), project));
                this.flattenedKeyTypes.add(e.getTypeList().get(i));
                this.unnestFlags.add(ArrayIndexUtil.getUnnestFlags(e.getUnnestList(), project));
            }
        }
        int totalSecondaryKeyCount = 0;
        int atomicSecondaryKeyCount = 0;
        for (Index.ArrayIndexElement e : this.arrayIndexDetails.getElementList()) {
            if (e.getUnnestList().isEmpty()) {
                ++atomicSecondaryKeyCount;
                ++totalSecondaryKeyCount;
                continue;
            }
            totalSecondaryKeyCount += e.getProjectList().size();
        }
        this.numTotalSecondaryKeys = totalSecondaryKeyCount;
        this.numAtomicSecondaryKeys = atomicSecondaryKeyCount;
        this.numArraySecondaryKeys = this.numTotalSecondaryKeys - this.numAtomicSecondaryKeys;
    }

    private int findPosOfArrayIndexElement() throws AsterixException {
        for (int i = 0; i < this.arrayIndexDetails.getElementList().size(); ++i) {
            if (this.arrayIndexDetails.getElementList().get(i).getUnnestList().isEmpty()) continue;
            return i;
        }
        throw new AsterixException(ErrorCode.COMPILATION_ILLEGAL_STATE, this.sourceLoc, new Serializable[]{"No array index found."});
    }

    @Override
    protected void setSecondaryRecDescAndComparators() throws AlgebricksException {
        int i;
        Index.ArrayIndexDetails arrayIndexDetails = (Index.ArrayIndexDetails)this.index.getIndexDetails();
        int numSecondaryKeys = this.getNumSecondaryKeys();
        this.secondaryFieldAccessEvalFactories = new IScalarEvaluatorFactory[numSecondaryKeys + this.numFilterFields];
        this.secondaryComparatorFactories = new IBinaryComparatorFactory[numSecondaryKeys + this.numPrimaryKeys];
        this.secondaryBloomFilterKeyFields = new int[numSecondaryKeys];
        ISerializerDeserializer[] secondaryRecFields = new ISerializerDeserializer[this.numPrimaryKeys + numSecondaryKeys + this.numFilterFields];
        ISerializerDeserializer[] enforcedRecFields = new ISerializerDeserializer[1 + this.numPrimaryKeys + (this.dataset.hasMetaPart() ? 1 : 0) + this.numFilterFields];
        ITypeTraits[] enforcedTypeTraits = new ITypeTraits[1 + this.numPrimaryKeys + (this.dataset.hasMetaPart() ? 1 : 0) + this.numFilterFields];
        this.secondaryTypeTraits = new ITypeTraits[numSecondaryKeys + this.numPrimaryKeys];
        ISerializerDeserializerProvider serdeProvider = this.metadataProvider.getDataFormat().getSerdeProvider();
        ITypeTraitProvider typeTraitProvider = this.metadataProvider.getDataFormat().getTypeTraitProvider();
        IBinaryComparatorFactoryProvider comparatorFactoryProvider = this.metadataProvider.getDataFormat().getBinaryComparatorFactoryProvider();
        boolean isOverridingKeyFieldTypes = arrayIndexDetails.isOverridingKeyFieldTypes();
        int flattenedListPos = 0;
        for (Index.ArrayIndexElement e : arrayIndexDetails.getElementList()) {
            for (int i2 = 0; i2 < e.getProjectList().size(); ++i2) {
                ISerializerDeserializer keySerde;
                this.addSKEvalFactories(isOverridingKeyFieldTypes ? this.enforcedItemType : this.itemType, flattenedListPos, false);
                Pair<IAType, Boolean> keyTypePair = ArrayIndexUtil.getNonNullableOpenFieldType(e.getTypeList().get(i2), e.getUnnestList(), e.getProjectList().get(i2), this.itemType);
                IAType keyType = (IAType)keyTypePair.first;
                this.anySecondaryKeyIsNullable = this.anySecondaryKeyIsNullable || (Boolean)keyTypePair.second != false;
                secondaryRecFields[flattenedListPos] = keySerde = serdeProvider.getSerializerDeserializer((Object)keyType);
                this.secondaryComparatorFactories[flattenedListPos] = comparatorFactoryProvider.getBinaryComparatorFactory((Object)keyType, true);
                this.secondaryTypeTraits[flattenedListPos] = typeTraitProvider.getTypeTrait((Object)keyType);
                this.secondaryBloomFilterKeyFields[flattenedListPos] = flattenedListPos;
                ++flattenedListPos;
            }
        }
        if (this.dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            for (i = 0; i < this.numPrimaryKeys; ++i) {
                secondaryRecFields[numSecondaryKeys + i] = this.primaryRecDesc.getFields()[i];
                enforcedRecFields[i] = this.primaryRecDesc.getFields()[i];
                this.secondaryTypeTraits[numSecondaryKeys + i] = this.primaryRecDesc.getTypeTraits()[i];
                enforcedTypeTraits[i] = this.primaryRecDesc.getTypeTraits()[i];
                this.secondaryComparatorFactories[numSecondaryKeys + i] = this.primaryComparatorFactories[i];
            }
        } else {
            for (i = 0; i < this.numPrimaryKeys; ++i) {
                secondaryRecFields[numSecondaryKeys + i] = IndexingConstants.getSerializerDeserializer((int)i);
                enforcedRecFields[i] = IndexingConstants.getSerializerDeserializer((int)i);
                this.secondaryTypeTraits[numSecondaryKeys + i] = IndexingConstants.getTypeTraits((int)i);
                enforcedTypeTraits[i] = IndexingConstants.getTypeTraits((int)i);
                this.secondaryComparatorFactories[numSecondaryKeys + i] = IndexingConstants.getComparatorFactory((int)i);
            }
        }
        enforcedRecFields[this.numPrimaryKeys] = serdeProvider.getSerializerDeserializer((Object)this.itemType);
        enforcedTypeTraits[this.numPrimaryKeys] = typeTraitProvider.getTypeTrait((Object)this.itemType);
        if (this.dataset.hasMetaPart()) {
            enforcedRecFields[this.numPrimaryKeys + 1] = serdeProvider.getSerializerDeserializer((Object)this.metaType);
            enforcedTypeTraits[this.numPrimaryKeys + 1] = typeTraitProvider.getTypeTrait((Object)this.metaType);
        }
        if (this.numFilterFields > 0) {
            ISerializerDeserializer serde;
            ARecordType filterItemType = ((InternalDatasetDetails)this.dataset.getDatasetDetails()).getFilterSourceIndicator() == 0 ? this.itemType : this.metaType;
            this.addSKEvalFactories(this.itemType, numSecondaryKeys, true);
            Pair<IAType, Boolean> keyTypePair = Index.getNonNullableKeyFieldType(this.filterFieldName, filterItemType);
            IAType type = (IAType)keyTypePair.first;
            secondaryRecFields[this.numPrimaryKeys + numSecondaryKeys] = serde = serdeProvider.getSerializerDeserializer((Object)type);
            enforcedRecFields[this.numPrimaryKeys + 1 + (this.dataset.hasMetaPart() ? 1 : 0)] = serde;
            enforcedTypeTraits[this.numPrimaryKeys + 1 + (this.dataset.hasMetaPart() ? 1 : 0)] = typeTraitProvider.getTypeTrait((Object)type);
        }
        this.secondaryRecDesc = new RecordDescriptor(secondaryRecFields, this.secondaryTypeTraits);
        this.enforcedRecDesc = new RecordDescriptor(enforcedRecFields, enforcedTypeTraits);
    }

    @Override
    protected int getNumSecondaryKeys() {
        return this.arrayIndexDetails.getElementList().stream().map(e -> e.getProjectList().size()).reduce(0, Integer::sum);
    }

    protected int[] createFieldPermutationForBulkLoadOp(int numSecondaryKeyFields) {
        int[] fieldPermutation = new int[numSecondaryKeyFields + this.numPrimaryKeys + this.numFilterFields];
        for (int i = 0; i < fieldPermutation.length; ++i) {
            fieldPermutation[i] = i;
        }
        return fieldPermutation;
    }

    protected void addSKEvalFactories(ARecordType recordType, int fieldPos, boolean isFilterField) throws AlgebricksException {
        if (isFilterField) {
            this.addFilterFieldToBuilder(recordType);
            return;
        }
        List<String> flattenedFieldName = this.flattenedFieldNames.get(fieldPos);
        List<Boolean> workingUnnestFlags = this.unnestFlags.get(fieldPos);
        if (workingUnnestFlags.stream().noneMatch(b -> b)) {
            this.addAtomicFieldToBuilder(recordType, fieldPos);
        } else {
            EvalFactoryAndRecDescInvoker commandExecutor = new EvalFactoryAndRecDescInvoker(!this.evalFactoryAndRecDescStackBuilder.isUnnestEvalPopulated());
            ArrayIndexUtil.walkArrayPath(this.index, recordType, flattenedFieldName, workingUnnestFlags, commandExecutor);
        }
    }

    @Override
    public JobSpecification buildLoadingJobSpec() throws AlgebricksException {
        JobSpecification spec = RuntimeUtils.createJobSpecification((ICcApplicationContext)this.metadataProvider.getApplicationContext());
        if (this.dataset.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            throw new UnsupportedOperationException("Array indexes on external datasets not currently supported.");
        }
        IndexUtil.bindJobEventListener(spec, this.metadataProvider);
        IOperatorDescriptor sourceOp = DatasetUtil.createDummyKeyProviderOp(spec, this.dataset, this.metadataProvider);
        IOperatorDescriptor targetOp = DatasetUtil.createPrimaryIndexScanOp(spec, this.metadataProvider, this.dataset);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
        sourceOp = targetOp;
        if (this.arrayIndexDetails.isOverridingKeyFieldTypes() && !this.enforcedItemType.equals((Object)this.itemType)) {
            targetOp = this.createCastOp(spec, this.dataset.getDatasetType(), this.index.isEnforced());
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
            sourceOp = targetOp;
        }
        if (this.dataset.hasMetaPart()) {
            int[] outColumns = new int[]{this.primaryRecDesc.getFieldCount()};
            int[] projectionList = new int[this.primaryRecDesc.getFieldCount() - 1];
            for (int i = 0; i < projectionList.length - 1; ++i) {
                projectionList[i] = i;
            }
            projectionList[projectionList.length - 1] = this.primaryRecDesc.getFieldCount() - 2;
            ISerializerDeserializer[] fields = new ISerializerDeserializer[this.primaryRecDesc.getFieldCount() - 1];
            ITypeTraits[] typeTraits = new ITypeTraits[this.primaryRecDesc.getFieldCount() - 1];
            for (int i = 0; i < this.primaryRecDesc.getFieldCount() - 1; ++i) {
                fields[i] = this.primaryRecDesc.getFields()[i];
                typeTraits[i] = this.primaryRecDesc.getTypeTraits()[i];
            }
            targetOp = this.createGenericAssignOp(spec, new ArrayList<IScalarEvaluatorFactory>(), new RecordDescriptor(fields, typeTraits), outColumns, projectionList);
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
            sourceOp = targetOp;
        }
        MutableObject sourceOpRef = new MutableObject((Object)sourceOp);
        MutableObject targetOpRef = new MutableObject((Object)targetOp);
        LoadingJobBuilder jobBuilder = new LoadingJobBuilder(spec, (Mutable<IOperatorDescriptor>)sourceOpRef, (Mutable<IOperatorDescriptor>)targetOpRef);
        int posOfArrayElement = this.findPosOfArrayIndexElement();
        ArrayIndexUtil.walkArrayPath(this.flattenedFieldNames.get(posOfArrayElement), this.unnestFlags.get(posOfArrayElement), jobBuilder);
        sourceOp = (IOperatorDescriptor)sourceOpRef.getValue();
        if (this.anySecondaryKeyIsNullable || this.arrayIndexDetails.isOverridingKeyFieldTypes()) {
            targetOp = this.createFilterAnyUnknownSelectOp(spec, this.numTotalSecondaryKeys, this.secondaryRecDesc);
            spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
            sourceOp = targetOp;
        }
        IBinaryComparatorFactory[] comparatorFactories = this.getComparatorFactoriesForOrder();
        targetOp = this.createSortOp(spec, comparatorFactories, this.secondaryRecDesc);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
        sourceOp = targetOp;
        targetOp = this.createPreSortedDistinctOp(spec, comparatorFactories, this.secondaryRecDesc);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
        sourceOp = targetOp;
        IndexDataflowHelperFactory dataflowHelperFactory = new IndexDataflowHelperFactory(this.metadataProvider.getStorageComponentProvider().getStorageManager(), this.secondaryFileSplitProvider);
        targetOp = this.createTreeIndexBulkLoadOp(spec, this.createFieldPermutationForBulkLoadOp(this.numTotalSecondaryKeys), (IIndexDataflowHelperFactory)dataflowHelperFactory, 1.0f);
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
        sourceOp = targetOp;
        SinkRuntimeFactory sinkRuntimeFactory = new SinkRuntimeFactory();
        sinkRuntimeFactory.setSourceLocation(this.sourceLoc);
        targetOp = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 0, new IPushRuntimeFactory[]{sinkRuntimeFactory}, new RecordDescriptor[]{this.secondaryRecDesc});
        spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)spec), sourceOp, 0, targetOp, 0);
        spec.addRoot(targetOp);
        spec.setConnectorPolicyAssignmentPolicy((IConnectorPolicyAssignmentPolicy)new ConnectorPolicyAssignmentPolicy());
        return spec;
    }

    private IBinaryComparatorFactory[] getComparatorFactoriesForOrder() {
        IBinaryComparatorFactory[] comparatorFactories = new IBinaryComparatorFactory[this.numPrimaryKeys + this.numTotalSecondaryKeys + this.numFilterFields];
        if (this.numTotalSecondaryKeys >= 0) {
            System.arraycopy(this.secondaryComparatorFactories, 0, comparatorFactories, 0, this.numTotalSecondaryKeys);
        }
        if (this.numPrimaryKeys >= 0) {
            System.arraycopy(this.primaryComparatorFactories, 0, comparatorFactories, this.numTotalSecondaryKeys, this.numPrimaryKeys);
        }
        if (this.numFilterFields > 0) {
            comparatorFactories[this.numTotalSecondaryKeys + this.numPrimaryKeys] = this.secondaryComparatorFactories[this.numTotalSecondaryKeys];
        }
        return comparatorFactories;
    }

    private IOperatorDescriptor createPreSortedDistinctOp(JobSpecification spec, IBinaryComparatorFactory[] secondaryComparatorFactories, RecordDescriptor secondaryRecDesc) {
        int[] distinctFields = new int[secondaryComparatorFactories.length];
        for (int i = 0; i < secondaryComparatorFactories.length; ++i) {
            distinctFields[i] = i;
        }
        IAggregateEvaluatorFactory[] aggFactories = new IAggregateEvaluatorFactory[]{};
        SimpleAlgebricksAccumulatingAggregatorFactory aggregatorFactory = new SimpleAlgebricksAccumulatingAggregatorFactory(aggFactories, distinctFields);
        aggregatorFactory.setSourceLocation(this.sourceLoc);
        PreclusteredGroupOperatorDescriptor distinctOp = new PreclusteredGroupOperatorDescriptor((IOperatorDescriptorRegistry)spec, distinctFields, secondaryComparatorFactories, (IAggregatorDescriptorFactory)aggregatorFactory, secondaryRecDesc, false, -1);
        distinctOp.setSourceLocation(this.sourceLoc);
        return distinctOp;
    }

    private AlgebricksMetaOperatorDescriptor createUnnestOp(JobSpecification spec, int inputWidth, IScalarEvaluatorFactory sef, RecordDescriptor unnestRecDesc) throws AlgebricksException {
        int[] projectionList = IntStream.range(0, inputWidth + 1).toArray();
        IUnnestingEvaluatorFactory unnestingEvaluatorFactory = this.metadataProvider.getFunctionManager().lookupFunction(BuiltinFunctions.SCAN_COLLECTION, this.sourceLoc).createUnnestingEvaluatorFactory(new IScalarEvaluatorFactory[]{sef});
        UnnestRuntimeFactory unnest = new UnnestRuntimeFactory(projectionList.length - 1, unnestingEvaluatorFactory, projectionList, false, null);
        unnest.setSourceLocation(this.sourceLoc);
        AlgebricksMetaOperatorDescriptor algebricksMetaOperatorDescriptor = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 1, new IPushRuntimeFactory[]{unnest}, new RecordDescriptor[]{unnestRecDesc});
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)algebricksMetaOperatorDescriptor, (AlgebricksPartitionConstraint)this.primaryPartitionConstraint);
        return algebricksMetaOperatorDescriptor;
    }

    private AlgebricksMetaOperatorDescriptor createIntermediateAssignOp(JobSpecification spec, boolean isFirstAssign, int inputWidth, List<IScalarEvaluatorFactory> sefs, RecordDescriptor assignRecDesc) {
        int[] outColumns;
        int[] projectionList;
        if (isFirstAssign) {
            projectionList = new int[this.numPrimaryKeys + this.numAtomicSecondaryKeys + this.numFilterFields + 1];
            outColumns = IntStream.range(inputWidth, this.numAtomicSecondaryKeys + this.numFilterFields == 1 ? inputWidth + 1 : inputWidth + this.numAtomicSecondaryKeys + this.numFilterFields).toArray();
            for (int i = 0; i < this.numPrimaryKeys; ++i) {
                projectionList[i] = i;
            }
            System.arraycopy(outColumns, 0, projectionList, this.numPrimaryKeys, this.numAtomicSecondaryKeys);
            if (this.numFilterFields > 0) {
                projectionList[this.numPrimaryKeys + this.numAtomicSecondaryKeys] = outColumns[outColumns.length - 1];
            }
        } else {
            outColumns = new int[]{inputWidth};
            projectionList = new int[inputWidth - 1];
            for (int i = 0; i < projectionList.length - 1; ++i) {
                projectionList[i] = i;
            }
        }
        projectionList[projectionList.length - 1] = inputWidth - 1;
        return this.createGenericAssignOp(spec, sefs, assignRecDesc, outColumns, projectionList);
    }

    private AlgebricksMetaOperatorDescriptor createFinalAssignOp(JobSpecification spec, boolean isFirstAssign, int inputWidth, List<IScalarEvaluatorFactory> sefs, RecordDescriptor assignRecDesc) {
        int[] outColumns;
        int[] projectionList;
        if (isFirstAssign) {
            int i;
            int outColumnsCursor = 0;
            projectionList = new int[this.numPrimaryKeys + this.numTotalSecondaryKeys + this.numFilterFields];
            outColumns = IntStream.range(inputWidth, this.numTotalSecondaryKeys + this.numFilterFields == 1 ? inputWidth + 1 : inputWidth + this.numTotalSecondaryKeys + this.numFilterFields).toArray();
            for (i = 0; i < this.numTotalSecondaryKeys; ++i) {
                int sizeOfFieldNamesForI = this.flattenedFieldNames.get(i).size();
                projectionList[i] = this.unnestFlags.get(i).get(sizeOfFieldNamesForI - 1) != false ? this.numPrimaryKeys + 1 : outColumns[outColumnsCursor++];
            }
            for (i = this.numTotalSecondaryKeys; i < this.numPrimaryKeys + this.numTotalSecondaryKeys; ++i) {
                projectionList[i] = i - this.numTotalSecondaryKeys;
            }
            if (this.numFilterFields > 0) {
                projectionList[projectionList.length - 1] = outColumns[outColumnsCursor];
            }
        } else {
            int i;
            int atomicSKCursor = 0;
            int arraySKCursor = 0;
            projectionList = new int[this.numPrimaryKeys + this.numTotalSecondaryKeys + this.numFilterFields];
            outColumns = IntStream.range(inputWidth, inputWidth + this.numArraySecondaryKeys).toArray();
            for (i = 0; i < this.numTotalSecondaryKeys; ++i) {
                int sizeOfFieldNamesForI = this.flattenedFieldNames.get(i).size();
                projectionList[i] = this.unnestFlags.get(i).stream().noneMatch(b -> b) ? this.numPrimaryKeys + atomicSKCursor++ : (this.unnestFlags.get(i).get(sizeOfFieldNamesForI - 1) == false ? outColumns[arraySKCursor++] : this.numPrimaryKeys + this.numAtomicSecondaryKeys + this.numFilterFields + 1);
            }
            for (i = 0; i < this.numPrimaryKeys; ++i) {
                projectionList[i + this.numTotalSecondaryKeys] = i;
            }
            if (this.numFilterFields > 0) {
                projectionList[this.numPrimaryKeys + this.numTotalSecondaryKeys] = this.numPrimaryKeys + this.numAtomicSecondaryKeys;
            }
        }
        return this.createGenericAssignOp(spec, sefs, assignRecDesc, outColumns, projectionList);
    }

    private AlgebricksMetaOperatorDescriptor createGenericAssignOp(JobSpecification spec, List<IScalarEvaluatorFactory> sefs, RecordDescriptor assignRecDesc, int[] outColumns, int[] projectionList) {
        AssignRuntimeFactory assign = new AssignRuntimeFactory(outColumns, sefs.toArray(new IScalarEvaluatorFactory[0]), projectionList);
        assign.setSourceLocation(this.sourceLoc);
        AlgebricksMetaOperatorDescriptor algebricksMetaOperatorDescriptor = new AlgebricksMetaOperatorDescriptor((IOperatorDescriptorRegistry)spec, 1, 1, new IPushRuntimeFactory[]{assign}, new RecordDescriptor[]{assignRecDesc});
        AlgebricksPartitionConstraintHelper.setPartitionConstraintInJobSpec((JobSpecification)spec, (IOperatorDescriptor)algebricksMetaOperatorDescriptor, (AlgebricksPartitionConstraint)this.primaryPartitionConstraint);
        return algebricksMetaOperatorDescriptor;
    }

    private void addAtomicFieldToBuilder(ARecordType recordType, int indexPos) throws AlgebricksException {
        IAType workingType = (IAType)Index.getNonNullableOpenFieldType((Index)this.index, (IAType)this.flattenedKeyTypes.get((int)indexPos), this.flattenedFieldNames.get((int)indexPos), (ARecordType)recordType).first;
        IScalarEvaluatorFactory sef = this.metadataProvider.getDataFormat().getFieldAccessEvaluatorFactory(this.metadataProvider.getFunctionManager(), recordType, this.flattenedFieldNames.get(indexPos), this.numPrimaryKeys, this.sourceLoc);
        this.evalFactoryAndRecDescStackBuilder.addAtomicSK(sef, workingType);
    }

    private void addFilterFieldToBuilder(ARecordType recordType) throws AlgebricksException {
        IScalarEvaluatorFactory sef = this.metadataProvider.getDataFormat().getFieldAccessEvaluatorFactory(this.metadataProvider.getFunctionManager(), recordType, this.filterFieldName, this.numPrimaryKeys, this.sourceLoc);
        this.evalFactoryAndRecDescStackBuilder.addFilter(sef, (IAType)Index.getNonNullableKeyFieldType((List<String>)this.filterFieldName, (ARecordType)recordType).first);
    }

    class EvalFactoryAndRecDescStackBuilder {
        private final Deque<EvalFactoryAndPosition> unnestEvalFactories = new ArrayDeque<EvalFactoryAndPosition>();
        private final List<EvalFactoryAndPosition> atomicSKEvalFactories = new ArrayList<EvalFactoryAndPosition>();
        private final List<EvalFactoryAndPosition> finalArraySKEvalFactories = new ArrayList<EvalFactoryAndPosition>();
        private final Queue<IAType> unnestEvalTypes = new LinkedList<IAType>();
        private final List<IAType> atomicSKEvalTypes = new ArrayList<IAType>();
        private EvalFactoryAndPosition filterEvalFactory = null;
        private IAType filterEvalType = null;
        private int workingPosition = 0;

        EvalFactoryAndRecDescStackBuilder() {
        }

        public void addAtomicSK(IScalarEvaluatorFactory sef, IAType type) {
            this.atomicSKEvalFactories.add(new EvalFactoryAndPosition(sef));
            this.atomicSKEvalTypes.add(type);
        }

        public void addFilter(IScalarEvaluatorFactory sef, IAType type) {
            this.filterEvalFactory = new EvalFactoryAndPosition(sef);
            this.filterEvalType = type;
        }

        public void addFinalArraySK(IScalarEvaluatorFactory sef) {
            this.finalArraySKEvalFactories.add(new EvalFactoryAndPosition(sef));
        }

        public void addUnnest(IScalarEvaluatorFactory sef, IAType type) {
            this.unnestEvalFactories.push(new EvalFactoryAndPosition(sef));
            this.unnestEvalTypes.add(type);
        }

        public boolean isUnnestEvalPopulated() {
            return !this.unnestEvalFactories.isEmpty();
        }

        public Deque<List<IScalarEvaluatorFactory>> buildEvalFactoryStack() {
            ArrayDeque<List<EvalFactoryAndPosition>> resultant = new ArrayDeque<List<EvalFactoryAndPosition>>();
            resultant.push(this.finalArraySKEvalFactories);
            int initialUnnestEvalFactorySize = this.unnestEvalFactories.size();
            for (int i = 0; i < initialUnnestEvalFactorySize - 1; ++i) {
                if (i != 0) {
                    resultant.push(new ArrayList());
                }
                resultant.push(Collections.singletonList(this.unnestEvalFactories.pop()));
                if (i != initialUnnestEvalFactorySize - 2) continue;
                resultant.push(new ArrayList());
            }
            ((List)resultant.peek()).addAll(this.atomicSKEvalFactories);
            ArrayList<EvalFactoryAndPosition> reorderedSEFs = new ArrayList<EvalFactoryAndPosition>(Objects.requireNonNull((List)resultant.peek()));
            reorderedSEFs.sort(Comparator.comparingInt(s -> s.position));
            resultant.pop();
            resultant.push(reorderedSEFs);
            if (this.filterEvalFactory != null) {
                ((List)resultant.peek()).add(this.filterEvalFactory);
            }
            resultant.push(Collections.singletonList(this.unnestEvalFactories.pop()));
            return resultant.stream().map(l -> l.stream().map(s -> s.scalarEvaluatorFactory).collect(Collectors.toList())).collect(Collectors.toCollection(ArrayDeque::new));
        }

        public Deque<RecordDescriptor> buildRecDescStack() throws AlgebricksException {
            int initialUnnestEvalTypesSize = this.unnestEvalTypes.size();
            ArrayDeque<RecordDescriptor> resultant = new ArrayDeque<RecordDescriptor>();
            RecordDescriptor recDescBeforeFirstUnnest = SecondaryArrayIndexBTreeOperationsHelper.this.primaryRecDesc;
            if (SecondaryArrayIndexBTreeOperationsHelper.this.dataset.hasMetaPart()) {
                ISerializerDeserializer[] fields = new ISerializerDeserializer[SecondaryArrayIndexBTreeOperationsHelper.this.primaryRecDesc.getFieldCount() - 1];
                ITypeTraits[] typeTraits = new ITypeTraits[SecondaryArrayIndexBTreeOperationsHelper.this.primaryRecDesc.getFieldCount() - 1];
                for (int i = 0; i < SecondaryArrayIndexBTreeOperationsHelper.this.primaryRecDesc.getFieldCount() - 1; ++i) {
                    fields[i] = SecondaryArrayIndexBTreeOperationsHelper.this.primaryRecDesc.getFields()[i];
                    typeTraits[i] = SecondaryArrayIndexBTreeOperationsHelper.this.primaryRecDesc.getTypeTraits()[i];
                }
                recDescBeforeFirstUnnest = new RecordDescriptor(fields, typeTraits);
            }
            resultant.addLast(recDescBeforeFirstUnnest);
            resultant.addLast(this.createUnnestRecDesc(recDescBeforeFirstUnnest, this.unnestEvalTypes.remove()));
            for (int i = 0; i < initialUnnestEvalTypesSize - 1; ++i) {
                resultant.addLast(this.createAssignRecDesc((RecordDescriptor)resultant.getLast(), i == 0));
                resultant.addLast(this.createUnnestRecDesc((RecordDescriptor)resultant.getLast(), this.unnestEvalTypes.remove()));
            }
            resultant.addLast(SecondaryArrayIndexBTreeOperationsHelper.this.secondaryRecDesc);
            return resultant;
        }

        private RecordDescriptor createUnnestRecDesc(RecordDescriptor priorRecDesc, IAType type) throws AlgebricksException {
            ISerializerDeserializerProvider serdeProvider = SecondaryArrayIndexBTreeOperationsHelper.this.metadataProvider.getDataFormat().getSerdeProvider();
            ISerializerDeserializer[] unnestFields = (ISerializerDeserializer[])Stream.concat(Stream.of(priorRecDesc.getFields()), Stream.of(serdeProvider.getSerializerDeserializer((Object)type))).toArray(ISerializerDeserializer[]::new);
            ITypeTraits[] unnestTypes = (ITypeTraits[])Stream.concat(Stream.of(priorRecDesc.getTypeTraits()), Stream.of(TypeTraitProvider.INSTANCE.getTypeTrait((Object)type))).toArray(ITypeTraits[]::new);
            return new RecordDescriptor(unnestFields, unnestTypes);
        }

        private RecordDescriptor createAssignRecDesc(RecordDescriptor priorRecDesc, boolean isFirstAssign) throws AlgebricksException {
            ArrayList<Object> assignFields = new ArrayList();
            ArrayList<Object> assignTypes = new ArrayList();
            if (isFirstAssign) {
                ISerializerDeserializerProvider serdeProvider = SecondaryArrayIndexBTreeOperationsHelper.this.metadataProvider.getDataFormat().getSerdeProvider();
                for (int i = 0; i < SecondaryArrayIndexBTreeOperationsHelper.this.numPrimaryKeys; ++i) {
                    assignFields.add(priorRecDesc.getFields()[i]);
                    assignTypes.add(priorRecDesc.getTypeTraits()[i]);
                }
                for (IAType s : this.atomicSKEvalTypes) {
                    assignFields.add(serdeProvider.getSerializerDeserializer((Object)s));
                    assignTypes.add(TypeTraitProvider.INSTANCE.getTypeTrait((Object)s));
                }
                if (this.filterEvalType != null) {
                    assignFields.add(serdeProvider.getSerializerDeserializer((Object)this.filterEvalType));
                    assignTypes.add(TypeTraitProvider.INSTANCE.getTypeTrait((Object)this.filterEvalType));
                }
                assignFields.add(priorRecDesc.getFields()[priorRecDesc.getFieldCount() - 1]);
                assignTypes.add(priorRecDesc.getTypeTraits()[priorRecDesc.getFieldCount() - 1]);
            } else {
                assignFields = new ArrayList<ISerializerDeserializer>(Arrays.asList(priorRecDesc.getFields()));
                assignTypes = new ArrayList<ITypeTraits>(Arrays.asList(priorRecDesc.getTypeTraits()));
                assignFields.remove(priorRecDesc.getFieldCount() - 2);
                assignTypes.remove(priorRecDesc.getFieldCount() - 2);
            }
            return new RecordDescriptor(assignFields.toArray(new ISerializerDeserializer[0]), assignTypes.toArray(new ITypeTraits[0]));
        }

        class EvalFactoryAndPosition {
            final IScalarEvaluatorFactory scalarEvaluatorFactory;
            final int position;

            EvalFactoryAndPosition(IScalarEvaluatorFactory scalarEvaluatorFactory) {
                this.scalarEvaluatorFactory = scalarEvaluatorFactory;
                this.position = EvalFactoryAndRecDescStackBuilder.this.workingPosition++;
            }
        }
    }

    class LoadingJobBuilder
    implements ArrayIndexUtil.ActionCounterCommandExecutor {
        private final Deque<RecordDescriptor> recDescStack;
        private final Deque<List<IScalarEvaluatorFactory>> sefStack;
        private final JobSpecification spec;
        private final Mutable<IOperatorDescriptor> sourceOpRef;
        private final Mutable<IOperatorDescriptor> targetOpRef;
        private RecordDescriptor workingRecDesc;
        private RecordDescriptor nextRecDesc;

        LoadingJobBuilder(JobSpecification spec, Mutable<IOperatorDescriptor> sourceOpRef, Mutable<IOperatorDescriptor> targetOpRef) throws AlgebricksException {
            this.recDescStack = SecondaryArrayIndexBTreeOperationsHelper.this.evalFactoryAndRecDescStackBuilder.buildRecDescStack();
            this.sefStack = SecondaryArrayIndexBTreeOperationsHelper.this.evalFactoryAndRecDescStackBuilder.buildEvalFactoryStack();
            this.workingRecDesc = this.recDescStack.pop();
            this.spec = spec;
            this.sourceOpRef = sourceOpRef;
            this.targetOpRef = targetOpRef;
        }

        private void connectAndMoveToNextOp() {
            this.spec.connect((IConnectorDescriptor)new OneToOneConnectorDescriptor((IConnectorDescriptorRegistry)this.spec), (IOperatorDescriptor)this.sourceOpRef.getValue(), 0, (IOperatorDescriptor)this.targetOpRef.getValue(), 0);
            this.sourceOpRef.setValue((Object)((IOperatorDescriptor)this.targetOpRef.getValue()));
            this.workingRecDesc = this.nextRecDesc;
        }

        @Override
        public void executeActionOnFirstArrayStep() throws AlgebricksException {
            IScalarEvaluatorFactory sef = this.sefStack.pop().get(0);
            this.nextRecDesc = this.recDescStack.pop();
            this.targetOpRef.setValue((Object)SecondaryArrayIndexBTreeOperationsHelper.this.createUnnestOp(this.spec, this.workingRecDesc.getFieldCount(), sef, this.nextRecDesc));
            this.connectAndMoveToNextOp();
        }

        @Override
        public void executeActionOnIntermediateArrayStep(int numberOfActionsAlreadyPerformed) throws AlgebricksException {
            this.nextRecDesc = this.recDescStack.pop();
            this.targetOpRef.setValue((Object)SecondaryArrayIndexBTreeOperationsHelper.this.createIntermediateAssignOp(this.spec, numberOfActionsAlreadyPerformed < 2, this.workingRecDesc.getFieldCount(), this.sefStack.pop(), this.nextRecDesc));
            this.connectAndMoveToNextOp();
            IScalarEvaluatorFactory sef = this.sefStack.pop().get(0);
            this.nextRecDesc = this.recDescStack.pop();
            this.targetOpRef.setValue((Object)SecondaryArrayIndexBTreeOperationsHelper.this.createUnnestOp(this.spec, this.workingRecDesc.getFieldCount(), sef, this.nextRecDesc));
            this.connectAndMoveToNextOp();
        }

        @Override
        public void executeActionOnFinalArrayStep(int numberOfActionsAlreadyPerformed) throws AlgebricksException {
            this.nextRecDesc = this.recDescStack.pop();
            this.targetOpRef.setValue((Object)SecondaryArrayIndexBTreeOperationsHelper.this.createFinalAssignOp(this.spec, numberOfActionsAlreadyPerformed < 2, this.workingRecDesc.getFieldCount(), this.sefStack.pop(), this.nextRecDesc));
            this.connectAndMoveToNextOp();
        }
    }

    class EvalFactoryAndRecDescInvoker
    implements ArrayIndexUtil.TypeTrackerCommandExecutor {
        private final boolean isFirstWalk;

        public EvalFactoryAndRecDescInvoker(boolean isFirstWalk) {
            this.isFirstWalk = isFirstWalk;
        }

        @Override
        public void executeActionOnEachArrayStep(ARecordType startingStepRecordType, IAType workingType, List<String> fieldName, boolean isFirstArrayStep, boolean isLastUnnestInIntermediateStep) throws AlgebricksException {
            if (!this.isFirstWalk) {
                return;
            }
            int sourceColumnForNestedArrays = SecondaryArrayIndexBTreeOperationsHelper.this.numPrimaryKeys + SecondaryArrayIndexBTreeOperationsHelper.this.numAtomicSecondaryKeys + SecondaryArrayIndexBTreeOperationsHelper.this.numFilterFields;
            int sourceColumnForFirstUnnestInAtomicPath = isFirstArrayStep ? SecondaryArrayIndexBTreeOperationsHelper.this.numPrimaryKeys : sourceColumnForNestedArrays;
            IScalarEvaluatorFactory sef = SecondaryArrayIndexBTreeOperationsHelper.this.metadataProvider.getDataFormat().getFieldAccessEvaluatorFactory(SecondaryArrayIndexBTreeOperationsHelper.this.metadataProvider.getFunctionManager(), startingStepRecordType, fieldName, sourceColumnForFirstUnnestInAtomicPath, SecondaryArrayIndexBTreeOperationsHelper.this.sourceLoc);
            SecondaryArrayIndexBTreeOperationsHelper.this.evalFactoryAndRecDescStackBuilder.addUnnest(sef, workingType);
        }

        @Override
        public void executeActionOnFinalArrayStep(ARecordType startingStepRecordType, List<String> fieldName, boolean isNonArrayStep, boolean requiresOnlyOneUnnest) throws AlgebricksException {
            if (!isNonArrayStep) {
                return;
            }
            int sourceColumnForFinalEvaluator = 1 + (requiresOnlyOneUnnest ? SecondaryArrayIndexBTreeOperationsHelper.this.numPrimaryKeys : SecondaryArrayIndexBTreeOperationsHelper.this.numPrimaryKeys + SecondaryArrayIndexBTreeOperationsHelper.this.numAtomicSecondaryKeys + SecondaryArrayIndexBTreeOperationsHelper.this.numFilterFields);
            IScalarEvaluatorFactory sef = SecondaryArrayIndexBTreeOperationsHelper.this.metadataProvider.getDataFormat().getFieldAccessEvaluatorFactory(SecondaryArrayIndexBTreeOperationsHelper.this.metadataProvider.getFunctionManager(), startingStepRecordType, fieldName, sourceColumnForFinalEvaluator, SecondaryArrayIndexBTreeOperationsHelper.this.sourceLoc);
            SecondaryArrayIndexBTreeOperationsHelper.this.evalFactoryAndRecDescStackBuilder.addFinalArraySK(sef);
        }
    }
}

