/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.gcs;

import com.google.api.gax.paging.Page;
import com.google.cloud.BaseServiceException;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStreamFactory;
import org.apache.asterix.external.input.record.reader.gcs.GCSInputStream;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.util.ExceptionUtils;

public class GCSInputStreamFactory
extends AbstractExternalInputStreamFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public AsterixInputStream createInputStream(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        return new GCSInputStream(this.configuration, ((AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize)this.partitionWorkLoadsBasedOnSize.get(partition)).getFilePaths());
    }

    @Override
    public void configure(IServiceContext ctx, Map<String, String> configuration, IWarningCollector warningCollector) throws AlgebricksException {
        Page items;
        super.configure(ctx, configuration, warningCollector);
        ExternalDataUtils.validateIncludeExclude(configuration);
        ArrayList<Blob> filesOnly = new ArrayList<Blob>();
        String container = configuration.get("container");
        Storage gcs = ExternalDataUtils.GCS.buildClient(configuration);
        Storage.BlobListOption options = Storage.BlobListOption.prefix((String)ExternalDataUtils.getPrefix(configuration));
        try {
            items = gcs.list(container, new Storage.BlobListOption[]{options});
        }
        catch (BaseServiceException ex) {
            throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)ex)});
        }
        AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher = ExternalDataUtils.getIncludeExcludeMatchers(configuration);
        this.collectAndFilterFiles((Page<Blob>)items, includeExcludeMatcher.getPredicate(), includeExcludeMatcher.getMatchersList(), filesOnly);
        if (filesOnly.isEmpty() && warningCollector.shouldWarn()) {
            Warning warning = Warning.of(null, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
            warningCollector.warn(warning);
        }
        this.distributeWorkLoad(filesOnly, this.getPartitionsCount());
    }

    private void collectAndFilterFiles(Page<Blob> items, BiPredicate<List<Matcher>, String> predicate, List<Matcher> matchers, List<Blob> filesOnly) {
        for (Blob item : items.iterateAll()) {
            if (item.getName().endsWith("/") || !predicate.test(matchers, item.getName())) continue;
            filesOnly.add(item);
        }
    }

    private void distributeWorkLoad(List<Blob> items, int partitionsCount) {
        PriorityQueue<AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize> workloadQueue = new PriorityQueue<AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize>(partitionsCount, Comparator.comparingLong(AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize::getTotalSize));
        for (int i = 0; i < partitionsCount; ++i) {
            workloadQueue.add(new AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize());
        }
        for (Blob item : items) {
            AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize workload = workloadQueue.poll();
            workload.addFilePath(item.getName(), item.getSize());
            workloadQueue.add(workload);
        }
        this.partitionWorkLoadsBasedOnSize.addAll(workloadQueue);
    }
}

