/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.ParquetConverterContext;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.nested.AbstractComplexConverter;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.converter.primitve.GenericPrimitiveConverter;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.parquet.io.api.Binary;

public class DecimalConverter
extends GenericPrimitiveConverter {
    public static final int LONG_MAX_PRECISION = 20;
    private final int precision;
    private final int scale;

    DecimalConverter(AbstractComplexConverter parent, IValueReference fieldName, int index, ParquetConverterContext context, int precision, int scale) {
        super(parent, fieldName, index, context);
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public void addInt(int value) {
        this.addLong(value);
    }

    @Override
    public void addLong(long value) {
        this.addConvertedDouble(BigDecimal.valueOf(value, this.scale).doubleValue());
    }

    @Override
    public void addBinary(Binary value) {
        if (this.precision <= 20) {
            this.addLong(DecimalConverter.getUnscaledLong(value.toByteBuffer()));
        } else {
            this.addConvertedDouble(new BigDecimal(new BigInteger(value.getBytes()), this.scale).doubleValue());
        }
    }

    private void addConvertedDouble(double value) {
        this.context.serializeDouble(value, this.parent.getDataOutput());
        this.parent.addValue(this);
    }

    private static long getUnscaledLong(ByteBuffer buffer) {
        byte[] bytes = buffer.array();
        int start = buffer.arrayOffset() + buffer.position();
        int end = buffer.arrayOffset() + buffer.limit();
        long value = 0L;
        for (int i = start; i < end; ++i) {
            value = value << 8 | (long)(bytes[i] & 0xFF);
        }
        int bits = 8 * (end - start);
        return value << 64 - bits >> 64 - bits;
    }
}

