/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.comm.io;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.util.IntSerDeUtils;

public class FrameTupleAccessor
implements IFrameTupleAccessor {
    private final RecordDescriptor recordDescriptor;
    private int tupleCountOffset;
    private ByteBuffer buffer;
    private int start;

    public FrameTupleAccessor(RecordDescriptor recordDescriptor) {
        this.recordDescriptor = recordDescriptor;
    }

    public void reset(ByteBuffer buffer) {
        this.reset(buffer, 0, buffer.limit());
    }

    public void reset(ByteBuffer buffer, int start, int length) {
        this.buffer = buffer;
        this.start = start;
        this.tupleCountOffset = start + FrameHelper.getTupleCountOffset((int)length);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getTupleCount() {
        return IntSerDeUtils.getInt((byte[])this.buffer.array(), (int)this.tupleCountOffset);
    }

    public int getTupleStartOffset(int tupleIndex) {
        int offset = tupleIndex == 0 ? 5 : IntSerDeUtils.getInt((byte[])this.buffer.array(), (int)(this.tupleCountOffset - 4 * tupleIndex));
        return this.start + offset;
    }

    public int getAbsoluteFieldStartOffset(int tupleIndex, int fIdx) {
        return this.getTupleStartOffset(tupleIndex) + this.getFieldSlotsLength() + this.getFieldStartOffset(tupleIndex, fIdx);
    }

    public int getTupleEndOffset(int tupleIndex) {
        return this.start + IntSerDeUtils.getInt((byte[])this.buffer.array(), (int)(this.tupleCountOffset - 4 * (tupleIndex + 1)));
    }

    public int getFieldStartOffset(int tupleIndex, int fIdx) {
        return fIdx == 0 ? 0 : IntSerDeUtils.getInt((byte[])this.buffer.array(), (int)(this.getTupleStartOffset(tupleIndex) + (fIdx - 1) * 4));
    }

    public int getFieldEndOffset(int tupleIndex, int fIdx) {
        return IntSerDeUtils.getInt((byte[])this.buffer.array(), (int)(this.getTupleStartOffset(tupleIndex) + fIdx * 4));
    }

    public int getFieldLength(int tupleIndex, int fIdx) {
        return this.getFieldEndOffset(tupleIndex, fIdx) - this.getFieldStartOffset(tupleIndex, fIdx);
    }

    public int getTupleLength(int tupleIndex) {
        return this.getTupleEndOffset(tupleIndex) - this.getTupleStartOffset(tupleIndex);
    }

    public int getFieldSlotsLength() {
        return this.getFieldCount() * 4;
    }

    public int getFieldCount() {
        return this.recordDescriptor.getFieldCount();
    }
}

