/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util.fastutil;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class Collectors {
    private static final Set<Collector.Characteristics> IDENTITY_CHARACTERISTICS = Collections.singleton(Collector.Characteristics.IDENTITY_FINISH);

    private Collectors() {
        throw new AssertionError((Object)"do not instantiate");
    }

    public static <T> Collector<Int2ObjectMap.Entry<T>, Int2ObjectMap<T>, Int2ObjectMap<T>> toInt2ObjectMap() {
        return new Collector<Int2ObjectMap.Entry<T>, Int2ObjectMap<T>, Int2ObjectMap<T>>(){

            @Override
            public Supplier<Int2ObjectMap<T>> supplier() {
                return Int2ObjectOpenHashMap::new;
            }

            @Override
            public BiConsumer<Int2ObjectMap<T>, Int2ObjectMap.Entry<T>> accumulator() {
                return (map, element) -> {
                    Object value;
                    int key = element.getIntKey();
                    Object oldValue = map.putIfAbsent(key, value = Objects.requireNonNull(element.getValue()));
                    if (oldValue != null) {
                        throw Collectors.duplicateKey(key, oldValue, value);
                    }
                };
            }

            @Override
            public BinaryOperator<Int2ObjectMap<T>> combiner() {
                return (map1, map2) -> {
                    for (Int2ObjectMap.Entry e : map2.int2ObjectEntrySet()) {
                        this.accumulator().accept((Int2ObjectMap<Int2ObjectMap>)map1, (Int2ObjectMap.Entry<Int2ObjectMap>)e);
                    }
                    return map1;
                };
            }

            @Override
            public Function<Int2ObjectMap<T>, Int2ObjectMap<T>> finisher() {
                return Function.identity();
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return IDENTITY_CHARACTERISTICS;
            }
        };
    }

    public static <T> Collector<Long2ObjectMap.Entry<T>, Long2ObjectMap<T>, Long2ObjectMap<T>> toLong2ObjectMap() {
        return new Collector<Long2ObjectMap.Entry<T>, Long2ObjectMap<T>, Long2ObjectMap<T>>(){

            @Override
            public Supplier<Long2ObjectMap<T>> supplier() {
                return Long2ObjectOpenHashMap::new;
            }

            @Override
            public BiConsumer<Long2ObjectMap<T>, Long2ObjectMap.Entry<T>> accumulator() {
                return (map, element) -> {
                    Object value;
                    long key = element.getLongKey();
                    Object oldValue = map.putIfAbsent(key, value = Objects.requireNonNull(element.getValue()));
                    if (oldValue != null) {
                        throw Collectors.duplicateKey(key, oldValue, value);
                    }
                };
            }

            @Override
            public BinaryOperator<Long2ObjectMap<T>> combiner() {
                return (map1, map2) -> {
                    for (Long2ObjectMap.Entry e : map2.long2ObjectEntrySet()) {
                        this.accumulator().accept((Long2ObjectMap<Long2ObjectMap>)map1, (Long2ObjectMap.Entry<Long2ObjectMap>)e);
                    }
                    return map1;
                };
            }

            @Override
            public Function<Long2ObjectMap<T>, Long2ObjectMap<T>> finisher() {
                return Function.identity();
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return IDENTITY_CHARACTERISTICS;
            }
        };
    }

    private static IllegalStateException duplicateKey(Object key, Object oldValue, Object newValue) {
        return new IllegalStateException("Duplicate key " + key + " (old: " + oldValue + ", new: " + newValue + ")");
    }
}

