/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.metadata.utils.PushdownUtil;
import org.apache.asterix.optimizer.rules.InlineAndRemoveRedundantBooleanExpressionsRule;
import org.apache.asterix.optimizer.rules.pushdown.PushdownContext;
import org.apache.asterix.optimizer.rules.pushdown.descriptor.ScanDefineDescriptor;
import org.apache.asterix.optimizer.rules.pushdown.processor.AbstractPushdownProcessor;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;

public class InlineAndNormalizeFilterExpressionsProcessor
extends AbstractPushdownProcessor {
    public InlineAndNormalizeFilterExpressionsProcessor(PushdownContext pushdownContext, IOptimizationContext context) {
        super(pushdownContext, context);
    }

    @Override
    public boolean process() throws AlgebricksException {
        List<ScanDefineDescriptor> scanDefineDescriptors = this.pushdownContext.getRegisteredScans();
        for (ScanDefineDescriptor scanDefineDescriptor : scanDefineDescriptors) {
            scanDefineDescriptor.setFilterExpression(this.inline(scanDefineDescriptor.getFilterExpression()));
            scanDefineDescriptor.setRangeFilterExpression(this.inline(scanDefineDescriptor.getRangeFilterExpression()));
        }
        return false;
    }

    private ILogicalExpression inline(ILogicalExpression expression) {
        if (expression == null || expression.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return expression;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expression;
        List args = funcExpr.getArguments();
        if ((PushdownUtil.isAnd((ILogicalExpression)funcExpr) || PushdownUtil.isOr((ILogicalExpression)funcExpr)) && args.size() == 1) {
            return this.inline((ILogicalExpression)((Mutable)args.get(0)).getValue());
        }
        if (PushdownUtil.isAnd((ILogicalExpression)funcExpr) || PushdownUtil.isOr((ILogicalExpression)funcExpr)) {
            ArrayList<Mutable> inlinedArgs = new ArrayList<Mutable>();
            for (Mutable argRef : args) {
                ILogicalExpression arg = this.inline((ILogicalExpression)argRef.getValue());
                if (PushdownUtil.isSameFunction((ILogicalExpression)funcExpr, (ILogicalExpression)arg)) {
                    AbstractFunctionCallExpression argFuncExpr = (AbstractFunctionCallExpression)arg;
                    inlinedArgs.addAll(argFuncExpr.getArguments());
                    continue;
                }
                argRef.setValue((Object)arg);
                inlinedArgs.add(argRef);
            }
            args.clear();
            args.addAll(inlinedArgs);
        }
        if (PushdownUtil.isAnd((ILogicalExpression)funcExpr) || PushdownUtil.isOr((ILogicalExpression)funcExpr)) {
            InlineAndRemoveRedundantBooleanExpressionsRule.removeRedundantExpressions(args);
            if (args.size() == 1) {
                return (ILogicalExpression)((Mutable)args.get(0)).getValue();
            }
        }
        return expression;
    }
}

