/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.common.impls;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.replication.IIOReplicationManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICacheMemoryAllocator;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageWriter;
import org.apache.hyracks.storage.common.buffercache.IPageWriteCallback;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;
import org.apache.hyracks.storage.common.buffercache.VirtualPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;
import org.apache.hyracks.storage.common.file.FileMapManager;
import org.apache.hyracks.storage.common.file.IFileMapManager;
import org.apache.hyracks.util.JSONUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtualBufferCache
implements IVirtualBufferCache {
    private static final float MAP_FACTOR = 0.75f;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean DEBUG = false;
    private final ICacheMemoryAllocator allocator;
    private final IFileMapManager fileMapManager;
    private final int pageSize;
    private final int pageBudget;
    private final CacheBucket[] buckets;
    private final BlockingQueue<VirtualPage> freePages;
    private final AtomicInteger largePages;
    private final AtomicInteger used;
    private boolean open;

    public VirtualBufferCache(ICacheMemoryAllocator allocator, int pageSize, int pageBudget) {
        this.allocator = allocator;
        this.fileMapManager = new FileMapManager();
        this.pageSize = pageSize;
        if (pageBudget == 0) {
            throw new IllegalArgumentException("Page Budget Cannot be 0");
        }
        this.pageBudget = pageBudget;
        this.buckets = new CacheBucket[(int)((float)this.pageBudget / 0.75f)];
        this.freePages = new ArrayBlockingQueue<VirtualPage>(this.pageBudget);
        this.largePages = new AtomicInteger(0);
        this.used = new AtomicInteger(0);
        this.open = false;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageSizeWithHeader() {
        return this.pageSize;
    }

    public int getLargePages() {
        return this.largePages.get();
    }

    @Override
    public int getUsage() {
        return this.used.get();
    }

    public int getPreAllocatedPages() {
        return this.freePages.size();
    }

    public int getPageBudget() {
        return this.pageBudget;
    }

    @Override
    public boolean isFull() {
        return this.used.get() >= this.pageBudget;
    }

    @Override
    public boolean isFull(ILSMMemoryComponent memoryComponent) {
        return this.isFull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createFile(FileReference fileRef) throws HyracksDataException {
        IFileMapManager iFileMapManager = this.fileMapManager;
        synchronized (iFileMapManager) {
            return this.fileMapManager.registerFile(fileRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int openFile(FileReference fileRef) throws HyracksDataException {
        int n;
        try {
            IFileMapManager iFileMapManager = this.fileMapManager;
            synchronized (iFileMapManager) {
                if (this.fileMapManager.isMapped(fileRef)) {
                    int n2 = this.fileMapManager.lookupFileId(fileRef);
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.logStats();
                    return n2;
                }
            }
        }
        catch (Throwable throwable) {
            this.logStats();
            throw throwable;
        }
        {
            n = this.fileMapManager.registerFile(fileRef);
        }
        this.logStats();
        return n;
    }

    private void logStats() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Free (allocated) pages = " + this.freePages.size() + ". Budget = " + this.pageBudget + ". Large pages = " + this.largePages.get() + ". Overall usage = " + this.used.get());
        }
    }

    public void openFile(int fileId) throws HyracksDataException {
        this.logStats();
    }

    public void closeFile(int fileId) throws HyracksDataException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(FileReference fileRef) throws HyracksDataException {
        IFileMapManager iFileMapManager = this.fileMapManager;
        synchronized (iFileMapManager) {
            int fileId = this.fileMapManager.lookupFileId(fileRef);
            this.deleteFile(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(int fileId) throws HyracksDataException {
        IFileMapManager iFileMapManager = this.fileMapManager;
        synchronized (iFileMapManager) {
            this.fileMapManager.unregisterFile(fileId);
        }
        int reclaimedPages = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            CacheBucket bucket = this.buckets[i];
            bucket.bucketLock.lock();
            try {
                VirtualPage prev = null;
                VirtualPage curr = bucket.cachedPage;
                while (curr != null) {
                    if (BufferedFileHandle.getFileId((long)curr.dpid()) == fileId) {
                        ++reclaimedPages;
                        if (curr.isLargePage()) {
                            this.largePages.getAndAdd(-curr.getFrameSizeMultiplier());
                            this.used.addAndGet(-curr.getFrameSizeMultiplier());
                        } else {
                            this.used.decrementAndGet();
                        }
                        if (prev == null) {
                            bucket.cachedPage = curr.next();
                            this.recycle(curr);
                            curr = bucket.cachedPage;
                            continue;
                        }
                        prev.next(curr.next());
                        this.recycle(curr);
                        curr = prev.next();
                        continue;
                    }
                    prev = curr;
                    curr = curr.next();
                }
                continue;
            }
            finally {
                bucket.bucketLock.unlock();
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Reclaimed pages = " + reclaimedPages);
        }
        this.logStats();
    }

    private void recycle(VirtualPage page) {
        if (this.used.get() < this.pageBudget && !page.isLargePage()) {
            page.reset();
            this.freePages.offer(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICachedPage pin(long dpid, boolean newPage) throws HyracksDataException {
        VirtualPage page;
        int hash = this.hash(dpid);
        CacheBucket bucket = this.buckets[hash];
        bucket.bucketLock.lock();
        try {
            for (page = bucket.cachedPage; page != null; page = page.next()) {
                if (page.dpid() != dpid) continue;
                VirtualPage virtualPage = page;
                return virtualPage;
            }
            if (!newPage) {
                FileReference fileRef;
                int fileId = BufferedFileHandle.getFileId((long)dpid);
                IFileMapManager iFileMapManager = this.fileMapManager;
                synchronized (iFileMapManager) {
                    fileRef = this.fileMapManager.lookupFileName(fileId);
                }
                throw HyracksDataException.create((ErrorCode)ErrorCode.PAGE_DOES_NOT_EXIST_IN_FILE, (Serializable[])new Serializable[]{Integer.valueOf(BufferedFileHandle.getPageId((long)dpid)), fileRef});
            }
            page = this.getOrAllocPage(dpid);
            page.next(bucket.cachedPage);
            bucket.cachedPage = page;
        }
        finally {
            bucket.bucketLock.unlock();
        }
        return page;
    }

    public ICachedPage pin(long dpid, boolean newPage, boolean incrementStats) throws HyracksDataException {
        return this.pin(dpid, newPage);
    }

    private int hash(long dpid) {
        int hashValue = (int)dpid ^ Integer.reverse((int)(dpid >>> 32)) >>> 1;
        return hashValue % this.buckets.length;
    }

    private VirtualPage getOrAllocPage(long dpid) {
        VirtualPage page = (VirtualPage)this.freePages.poll();
        if (page == null) {
            page = new VirtualPage(this.allocator.allocate(this.pageSize, 1)[0], this.pageSize);
            page.multiplier(1);
        }
        page.dpid(dpid);
        this.used.incrementAndGet();
        return page;
    }

    public void resizePage(ICachedPage cPage, int multiplier, IExtraPageBlockHelper extraPageBlockHelper) {
        int diff;
        ByteBuffer oldBuffer = cPage.getBuffer();
        int origMultiplier = cPage.getFrameSizeMultiplier();
        if (origMultiplier == multiplier) {
            return;
        }
        if (origMultiplier == 1) {
            this.largePages.getAndAdd(multiplier);
            diff = multiplier - 1;
            this.used.getAndAdd(diff);
            for (int i = 0; i < diff; ++i) {
                this.freePages.poll();
            }
        } else if (multiplier == 1) {
            this.largePages.getAndAdd(-origMultiplier);
            this.used.addAndGet(-origMultiplier + 1);
        } else {
            diff = multiplier - origMultiplier;
            this.largePages.getAndAdd(diff);
            this.used.getAndAdd(diff);
            for (int i = 0; i < diff; ++i) {
                this.freePages.poll();
            }
        }
        ByteBuffer newBuffer = this.allocator.allocate(this.pageSize * multiplier, 1)[0];
        oldBuffer.position(0);
        if (multiplier < origMultiplier) {
            oldBuffer.limit(newBuffer.capacity());
        }
        newBuffer.put(oldBuffer);
        ((VirtualPage)cPage).buffer(newBuffer);
        ((VirtualPage)cPage).multiplier(multiplier);
    }

    public void unpin(ICachedPage page) throws HyracksDataException {
    }

    public void flush(ICachedPage page) throws HyracksDataException {
        throw new UnsupportedOperationException();
    }

    public void force(int fileId, boolean metadata) throws HyracksDataException {
    }

    @Override
    public void open() throws HyracksDataException {
        if (this.open) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.VBC_ALREADY_OPEN, (Serializable[])new Serializable[0]);
        }
        this.allocator.reserveAllocation(this.pageSize, this.pageBudget);
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = new CacheBucket();
        }
        this.largePages.set(0);
        this.used.set(0);
        this.open = true;
    }

    public void close() throws HyracksDataException {
        if (!this.open) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.VBC_ALREADY_CLOSED, (Serializable[])new Serializable[0]);
        }
        this.freePages.clear();
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i].cachedPage = null;
        }
        this.open = false;
    }

    public String dumpState() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Page size = %d%n", this.pageSize));
        sb.append(String.format("Page budget = %d%n", this.pageBudget));
        sb.append(String.format("Used pages = %d%n", this.used.get()));
        sb.append(String.format("Used large pages = %d%n", this.largePages.get()));
        sb.append(String.format("Available free pages = %d%n", this.freePages.size()));
        return sb.toString();
    }

    @Override
    public IFileMapManager getFileMapProvider() {
        return this.fileMapManager;
    }

    public int getNumPagesOfFile(int fileId) throws HyracksDataException {
        return -1;
    }

    public void returnPage(ICachedPage page) {
    }

    public IFIFOPageWriter createFIFOWriter(IPageWriteCallback callback, IPageWriteFailureCallback failureCallback) {
        throw new UnsupportedOperationException("Virtual buffer caches don't have FIFO writers");
    }

    public ICachedPage confiscatePage(long dpid) throws HyracksDataException {
        throw new UnsupportedOperationException("Virtual buffer caches don't have FIFO writers");
    }

    public ICachedPage confiscateLargePage(long dpid, int multiplier, int extraBlockPageId) throws HyracksDataException {
        throw new UnsupportedOperationException("Virtual buffer caches don't have FIFO writers");
    }

    public void returnPage(ICachedPage page, boolean reinsert) {
        throw new UnsupportedOperationException("Virtual buffer caches don't have FIFO writers");
    }

    public int getFileReferenceCount(int fileId) {
        return 0;
    }

    public boolean isReplicationEnabled() {
        return false;
    }

    public IIOReplicationManager getIOReplicationManager() {
        return null;
    }

    public void purgeHandle(int fileId) throws HyracksDataException {
        this.deleteFile(fileId);
    }

    public String toString() {
        return JSONUtil.fromMap(this.toMap());
    }

    private Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("class", this.getClass().getSimpleName());
        map.put("allocator", this.allocator.toString());
        map.put("pageSize", this.pageSize);
        map.put("pageBudget", this.pageBudget);
        map.put("open", this.open);
        return map;
    }

    public void closeFileIfOpen(FileReference fileRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void register(ILSMMemoryComponent memoryComponent) {
    }

    @Override
    public void unregister(ILSMMemoryComponent memoryComponent) {
    }

    @Override
    public void flushed(ILSMMemoryComponent memoryComponent) throws HyracksDataException {
    }

    private static class CacheBucket {
        private final ReentrantLock bucketLock = new ReentrantLock();
        private VirtualPage cachedPage;

        public String toString() {
            return CacheBucket.class.getSimpleName() + " -> " + (this.cachedPage == null ? "" : this.cachedPage.toString());
        }
    }
}

