/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.lazy;

import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.om.lazy.AbstractLazyVisitablePointable;
import org.apache.asterix.om.lazy.AbstractListLazyVisitablePointable;
import org.apache.asterix.om.lazy.GenericLazyVisitablePointable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class VariableListLazyVisitablePointable
extends AbstractListLazyVisitablePointable {
    private final ATypeTag itemTag;
    private final int actualChildOffset;

    public VariableListLazyVisitablePointable(boolean tagged, AbstractCollectionType listType) {
        super(tagged, listType);
        this.itemTag = listType.getItemType().getTypeTag();
        this.actualChildOffset = this.isTagged() ? 0 : -1;
        this.currentChildTypeTag = this.itemTag.serialize();
    }

    @Override
    public void nextChild() throws HyracksDataException {
        byte[] data = this.getByteArray();
        int itemOffset = this.getStartOffset() + AInt32SerializerDeserializer.getInt(data, this.itemsOffset + this.currentIndex * 4) + this.actualChildOffset;
        ATypeTag itemTypeTag = this.processTypeTag(data, itemOffset);
        int itemSize = NonTaggedFormatUtil.getFieldValueLength(data, itemOffset, itemTypeTag, this.isTaggedChild());
        this.currentValue.set(data, itemOffset, itemSize);
        ++this.currentIndex;
    }

    private ATypeTag processTypeTag(byte[] data, int itemOffset) {
        if (this.itemTag == ATypeTag.ANY) {
            this.currentChildTypeTag = data[itemOffset];
        }
        return this.itemTag;
    }

    @Override
    public boolean isTaggedChild() {
        return this.itemTag == ATypeTag.ANY;
    }

    @Override
    AbstractLazyVisitablePointable createVisitablePointable(IAType itemType) {
        if (itemType.getTypeTag() != ATypeTag.ANY) {
            return VariableListLazyVisitablePointable.createVisitable(itemType);
        }
        return new GenericLazyVisitablePointable();
    }
}

