/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.stream;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.external.IExternalFilterEvaluatorFactory;
import org.apache.asterix.external.api.IExternalDataRuntimeContext;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.input.filter.embedder.IExternalFilterValueEmbedder;
import org.apache.asterix.external.input.record.reader.stream.AbstractStreamRecordReader;
import org.apache.asterix.external.input.record.reader.stream.AvroRecordReader;
import org.apache.asterix.external.input.stream.factory.LocalFSInputStreamFactory;
import org.apache.asterix.external.input.stream.factory.SocketClientInputStreamFactory;
import org.apache.asterix.external.input.stream.factory.SocketServerInputStreamFactory;
import org.apache.asterix.external.provider.StreamRecordReaderProvider;
import org.apache.asterix.external.provider.context.ExternalReaderRuntimeDataContext;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public class StreamRecordReaderFactory
implements IRecordReaderFactory<Object> {
    private static final long serialVersionUID = 1L;
    protected IInputStreamFactory streamFactory;
    protected Map<String, String> configuration;
    protected Class<?> recordReaderClazz;
    protected IExternalFilterEvaluatorFactory filterEvaluatorFactory;
    private static final List<String> recordReaderNames = Collections.unmodifiableList(Arrays.asList("localfs", "socket_adapter", "socket", "socket-client"));

    @Override
    public final IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return IExternalDataSourceFactory.DataSourceType.RECORDS;
    }

    @Override
    public final Class<?> getRecordClass() throws AsterixException {
        return StreamRecordReaderProvider.getRecordClass(this.configuration);
    }

    @Override
    public final AlgebricksAbsolutePartitionConstraint getPartitionConstraint() throws AlgebricksException {
        return this.streamFactory.getPartitionConstraint();
    }

    @Override
    public final void configure(IServiceContext serviceCtx, Map<String, String> configuration, IWarningCollector warningCollector, IExternalFilterEvaluatorFactory filterEvaluatorFactory) throws HyracksDataException, AlgebricksException {
        this.configuration = configuration;
        this.setStreamFactory(configuration);
        this.streamFactory.configure(serviceCtx, configuration, warningCollector, filterEvaluatorFactory);
        this.recordReaderClazz = StreamRecordReaderProvider.getRecordReaderClazz(configuration);
        this.filterEvaluatorFactory = filterEvaluatorFactory;
    }

    @Override
    public final IRecordReader<?> createRecordReader(IExternalDataRuntimeContext context) throws HyracksDataException {
        AbstractStreamRecordReader<?> reader = this.createReader(context);
        ((ExternalReaderRuntimeDataContext)context).setReader(reader);
        return reader;
    }

    @Override
    public final IExternalDataRuntimeContext createExternalDataRuntimeContext(IHyracksTaskContext context, int partition) throws HyracksDataException {
        IExternalFilterValueEmbedder valueEmbedder = (IExternalFilterValueEmbedder)this.filterEvaluatorFactory.createValueEmbedder(context.getWarningCollector());
        return new ExternalReaderRuntimeDataContext(context, partition, valueEmbedder);
    }

    @Override
    public List<String> getRecordReaderNames() {
        return recordReaderNames;
    }

    protected void setStreamFactory(Map<String, String> config) throws CompilationException {
        String reader = config.get("reader");
        if (reader.equals("localfs")) {
            this.streamFactory = new LocalFSInputStreamFactory();
        } else if (reader.equals("socket_adapter") || reader.equals("socket")) {
            this.streamFactory = new SocketServerInputStreamFactory();
        } else if (reader.equals("socket-client")) {
            this.streamFactory = new SocketClientInputStreamFactory();
        } else {
            throw new CompilationException(ErrorCode.FEED_UNKNOWN_ADAPTER_NAME, new Serializable[0]);
        }
    }

    private AbstractStreamRecordReader<?> createReader(IExternalDataRuntimeContext context) throws HyracksDataException {
        try {
            AbstractStreamRecordReader streamRecordReader = this.recordReaderClazz.equals(AvroRecordReader.class) ? new AvroRecordReader(this.streamFactory.createInputStream(context), this.configuration) : (AbstractStreamRecordReader)this.recordReaderClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            streamRecordReader.configure(context.getTaskContext(), this.streamFactory.createInputStream(context), this.configuration);
            return streamRecordReader;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

