/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.external.IExternalFilterEvaluator;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.BuiltinTypeMap;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.util.LogRedactionUtil;

public final class ExternalDataPrefix
implements Serializable {
    private static final long serialVersionUID = -7612997190679310483L;
    private final String original;
    private final String protocolContainerPair;
    private final boolean endsWithSlash;
    private final List<String> segments;
    private final List<String> computedFieldNames = new ArrayList<String>();
    private final Map<String, ATypeTag> computedFieldsParts = new HashMap<String, ATypeTag>();
    private final List<IAType> computedFieldTypes = new ArrayList<IAType>();
    private final List<Integer> computedFieldSegmentIndexes = new ArrayList<Integer>();
    private final List<ARecordType> paths = new ArrayList<ARecordType>();
    private final Map<Integer, PrefixSegment> indexToComputedFieldsMap = new HashMap<Integer, PrefixSegment>();
    private String root;
    public static final String PREFIX_ROOT_FIELD_NAME = "prefix-root";
    public static final Set<ATypeTag> supportedTypes = new HashSet<ATypeTag>();

    public ExternalDataPrefix(Map<String, String> configuration) throws AlgebricksException {
        String prefix = ExternalDataUtils.getDefinitionOrPath(configuration);
        this.original = prefix != null ? prefix : "";
        this.endsWithSlash = this.original.endsWith("/");
        this.protocolContainerPair = ExternalDataUtils.getProtocolContainerPair(configuration);
        this.segments = ExternalDataPrefix.extractPrefixSegments(this.original);
        this.extractComputedFields();
        this.extractRoot();
    }

    public String getOriginal() {
        return this.original;
    }

    public boolean isEndsWithSlash() {
        return this.endsWithSlash;
    }

    public String getRoot() {
        return this.root;
    }

    public boolean hasComputedFields() {
        return !this.computedFieldNames.isEmpty();
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public List<String> getComputedFieldNames() {
        return this.computedFieldNames;
    }

    public List<IAType> getComputedFieldTypes() {
        return this.computedFieldTypes;
    }

    public List<Integer> getComputedFieldSegmentIndexes() {
        return this.computedFieldSegmentIndexes;
    }

    public List<ARecordType> getPaths() {
        return this.paths;
    }

    public Map<Integer, PrefixSegment> getIndexToComputedFieldsMap() {
        return this.indexToComputedFieldsMap;
    }

    public static List<String> extractPrefixSegments(String prefix) {
        return prefix.isEmpty() ? Collections.emptyList() : Arrays.asList(prefix.split("/"));
    }

    private void extractComputedFields() throws AlgebricksException {
        if (!this.segments.isEmpty()) {
            Matcher matcher = ExternalDataConstants.COMPUTED_FIELD_PATTERN.matcher("");
            StringBuilder expression = new StringBuilder();
            for (int i = 0; i < this.segments.size(); ++i) {
                matcher.reset(this.segments.get(i));
                expression.setLength(0);
                int end = 0;
                while (matcher.find()) {
                    expression.append(this.segments.get(i), end, matcher.start());
                    String computedField = matcher.group();
                    String[] splits = computedField.split(":");
                    String namePart = splits[0].substring(1);
                    String typePart = splits[1].substring(0, splits[1].length() - 1);
                    BuiltinType type = BuiltinTypeMap.getBuiltinType((String)typePart);
                    if (type == null) {
                        throw new CompilationException(ErrorCode.UNSUPPORTED_COMPUTED_FIELD_TYPE, new Serializable[]{typePart});
                    }
                    type = this.getUpdatedType((IAType)type);
                    this.validateSupported(type.getTypeTag());
                    this.validateConflictingFields(namePart, type.getTypeTag());
                    this.computedFieldNames.add(namePart);
                    this.computedFieldTypes.add((IAType)type);
                    this.computedFieldSegmentIndexes.add(i);
                    this.updateIndexToComputedFieldMap(i, namePart, (IAType)type);
                    List<String> nameParts = List.of(namePart.split("\\."));
                    this.addNameParts(nameParts, type.getTypeTag());
                    this.paths.add(ProjectionFiltrationTypeUtil.getPathRecordType(nameParts));
                    expression.append("(.+)");
                    end = matcher.end();
                }
                if (expression.length() <= 0) continue;
                expression.append(this.segments.get(i).substring(end));
                this.indexToComputedFieldsMap.get(i).setExpression(expression.toString());
            }
        }
    }

    private void addNameParts(List<String> nameParts, ATypeTag type) throws CompilationException {
        Object concat = "";
        for (int i = 0; i < nameParts.size() - 1; ++i) {
            ATypeTag existingType = this.computedFieldsParts.get(concat = (String)concat + nameParts.get(i));
            if (existingType != null && existingType != ATypeTag.OBJECT) {
                throw new CompilationException(ErrorCode.COMPUTED_FIELD_CONFLICTING_TYPE, new Serializable[]{concat, existingType});
            }
            this.computedFieldsParts.putIfAbsent((String)concat, ATypeTag.OBJECT);
            concat = (String)concat + ".";
        }
        concat = (String)concat + nameParts.get(nameParts.size() - 1);
        this.computedFieldsParts.put((String)concat, type);
    }

    private void validateConflictingFields(String name, ATypeTag type) throws CompilationException {
        ATypeTag existingType = this.computedFieldsParts.get(name);
        if (existingType != null) {
            if (existingType == ATypeTag.OBJECT) {
                throw new CompilationException(ErrorCode.COMPUTED_FIELD_CONFLICTING_TYPE, new Serializable[]{name, type});
            }
            throw new CompilationException(ErrorCode.DUPLICATE_FIELD_NAME, new Serializable[]{name});
        }
    }

    private void updateIndexToComputedFieldMap(int segmentIndex, String computedFieldName, IAType computedFieldType) {
        if (this.indexToComputedFieldsMap.containsKey(segmentIndex)) {
            PrefixSegment prefixSegment = this.indexToComputedFieldsMap.get(segmentIndex);
            prefixSegment.getComputedFieldNames().add(computedFieldName);
            prefixSegment.getComputedFieldTypes().add(computedFieldType);
        } else {
            PrefixSegment prefixSegment = new PrefixSegment();
            prefixSegment.getComputedFieldNames().add(computedFieldName);
            prefixSegment.getComputedFieldTypes().add(computedFieldType);
            this.indexToComputedFieldsMap.put(segmentIndex, prefixSegment);
        }
    }

    private void extractRoot() {
        if (this.computedFieldNames.isEmpty()) {
            this.root = this.original;
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.computedFieldSegmentIndexes.get(0); ++i) {
            builder.append(this.segments.get(i)).append("/");
        }
        this.root = builder.toString();
        this.root = this.root.isEmpty() ? this.root : this.root.substring(0, this.root.length() - 1);
        this.root = ExternalDataUtils.appendSlash(this.root, this.endsWithSlash);
    }

    private void validateSupported(ATypeTag type) throws CompilationException {
        if (!supportedTypes.contains(type)) {
            throw new CompilationException(ErrorCode.UNSUPPORTED_COMPUTED_FIELD_TYPE, new Serializable[]{type});
        }
    }

    public List<String> getValues(String key) {
        ArrayList<String> values = new ArrayList<String>();
        this.extractValues(ExternalDataPrefix.extractPrefixSegments(key), values);
        return values;
    }

    public boolean evaluate(String key, IExternalFilterEvaluator evaluator, IWarningCollector warningCollector) throws HyracksDataException {
        List<String> keySegments = ExternalDataPrefix.extractPrefixSegments(key);
        if (keySegments.size() <= this.segments.size()) {
            return false;
        }
        if (!this.hasComputedFields()) {
            return true;
        }
        for (int i = 0; i < this.segments.size(); ++i) {
            if (this.computedFieldSegmentIndexes.contains(i) || keySegments.get(i).equals(this.segments.get(i))) continue;
            return false;
        }
        ArrayList<String> values = new ArrayList<String>();
        boolean success = this.extractValues(keySegments, values);
        if (!success) {
            return false;
        }
        String computedFieldName = null;
        IAType computedFieldType = null;
        String computedFieldValue = null;
        try {
            for (int i = 0; i < this.computedFieldNames.size(); ++i) {
                computedFieldName = this.computedFieldNames.get(i);
                computedFieldType = this.computedFieldTypes.get(i);
                computedFieldValue = (String)values.get(i);
                ExternalDataPrefix.ensureParsable(computedFieldType, computedFieldValue);
                if (!evaluator.isComputedFieldUsed(i)) continue;
                evaluator.setValue(i, computedFieldValue);
            }
        }
        catch (NumberFormatException ex) {
            if (warningCollector.shouldWarn()) {
                warningCollector.warn(Warning.of(null, (IError)ErrorCode.FAILED_TO_EVALUATE_COMPUTED_FIELD, (Serializable[])new Serializable[]{LogRedactionUtil.userData((String)key), computedFieldName, computedFieldType, LogRedactionUtil.userData((String)computedFieldValue), LogRedactionUtil.userData((String)ex.toString())}));
            }
            return false;
        }
        return evaluator.evaluate();
    }

    private static void ensureParsable(IAType computedFieldType, String computedFieldValue) {
        switch (computedFieldType.getTypeTag()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                Long.parseLong(computedFieldValue);
                break;
            }
            case DOUBLE: {
                Double.parseDouble(computedFieldValue);
            }
        }
    }

    public String removeProtocolContainerPair(String path) {
        return path.replace(this.protocolContainerPair, "");
    }

    public static boolean containsComputedFields(Map<String, String> configuration) {
        String path = ExternalDataUtils.getDefinitionOrPath(configuration);
        return path != null && path.contains("{");
    }

    private boolean extractValues(List<String> keySegments, List<String> values) {
        for (Map.Entry<Integer, PrefixSegment> entry : this.indexToComputedFieldsMap.entrySet()) {
            int index = entry.getKey();
            String expression = entry.getValue().getExpression();
            String keySegment = keySegments.get(index);
            Matcher matcher = Pattern.compile(expression).matcher(keySegment);
            if (!matcher.find()) {
                return false;
            }
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                values.add(matcher.group(i));
            }
        }
        return true;
    }

    private IAType getUpdatedType(IAType type) {
        switch (type.getTypeTag()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: {
                return BuiltinType.AINT64;
            }
        }
        return type;
    }

    static {
        supportedTypes.add(ATypeTag.STRING);
        supportedTypes.add(ATypeTag.BIGINT);
        supportedTypes.add(ATypeTag.DOUBLE);
    }

    public static class PrefixSegment
    implements Serializable {
        private static final long serialVersionUID = 8788939199985336347L;
        private String expression;
        private final List<String> computedFieldNames = new ArrayList<String>();
        private final List<IAType> computedFieldTypes = new ArrayList<IAType>();

        public String getExpression() {
            return this.expression;
        }

        public List<String> getComputedFieldNames() {
            return this.computedFieldNames;
        }

        public List<IAType> getComputedFieldTypes() {
            return this.computedFieldTypes;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }
    }
}

