/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.asterix.cloud.IWriteBufferProvider;
import org.apache.asterix.cloud.clients.ICloudBufferedWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CloudResettableInputStream
extends InputStream {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int MIN_BUFFER_SIZE = 0x500000;
    private final IWriteBufferProvider bufferProvider;
    private ByteBuffer writeBuffer;
    private final ICloudBufferedWriter bufferedWriter;

    public CloudResettableInputStream(ICloudBufferedWriter bufferedWriter, IWriteBufferProvider bufferProvider) {
        this.bufferedWriter = bufferedWriter;
        this.bufferProvider = bufferProvider;
    }

    private void open() {
        if (this.writeBuffer == null) {
            this.writeBuffer = this.bufferProvider.getBuffer();
            this.writeBuffer.clear();
        }
    }

    @Override
    public void reset() {
        this.writeBuffer.reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.writeBuffer.mark();
    }

    public void write(ByteBuffer header, ByteBuffer page) throws HyracksDataException {
        this.write(header);
        this.write(page);
    }

    public int write(ByteBuffer page) throws HyracksDataException {
        this.open();
        return this.write(page.array(), 0, page.limit());
    }

    public void write(int b) throws HyracksDataException {
        if (this.writeBuffer.remaining() == 0) {
            this.uploadAndWait();
        }
        this.writeBuffer.put((byte)b);
    }

    public int write(byte[] b, int off, int len) throws HyracksDataException {
        this.open();
        if (this.writeBuffer.remaining() == 0) {
            this.uploadAndWait();
        }
        int offset = off;
        int pageRemaining = len;
        while (pageRemaining > 0) {
            if (this.writeBuffer.remaining() > pageRemaining) {
                this.writeBuffer.put(b, offset, pageRemaining);
                return len;
            }
            int remaining = this.writeBuffer.remaining();
            this.writeBuffer.put(b, offset, remaining);
            pageRemaining -= remaining;
            offset += remaining;
            this.uploadAndWait();
        }
        return len;
    }

    public void finish() throws HyracksDataException {
        this.open();
        try {
            if (this.writeBuffer.position() > 0 || this.bufferedWriter.isEmpty()) {
                this.uploadAndWait();
            }
            this.bufferedWriter.finish();
        }
        finally {
            this.returnBuffer();
        }
    }

    public void abort() throws HyracksDataException {
        try {
            this.bufferedWriter.abort();
        }
        finally {
            this.returnBuffer();
        }
    }

    private void uploadAndWait() throws HyracksDataException {
        this.writeBuffer.flip();
        try {
            this.bufferedWriter.upload(this, this.writeBuffer.limit());
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw HyracksDataException.create((Throwable)e);
        }
        this.writeBuffer.clear();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.writeBuffer.remaining() == 0) {
            return -1;
        }
        int length = Math.min(len, this.writeBuffer.remaining());
        this.writeBuffer.get(b, off, length);
        return length;
    }

    @Override
    public int read() throws IOException {
        return this.writeBuffer.get();
    }

    private void returnBuffer() {
        if (this.writeBuffer != null) {
            this.bufferProvider.recycle(this.writeBuffer);
            this.writeBuffer = null;
        }
    }
}

