/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.clause;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectRegular;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;

public class SelectClause
extends AbstractClause {
    private final List<List<String>> fieldExclusions = new ArrayList<List<String>>();
    private SelectElement selectElement;
    private SelectRegular selectRegular;
    private boolean distinct;

    public SelectClause(SelectElement selectElement, SelectRegular selectRegular, List<List<String>> fieldExclusions, boolean distinct) {
        if (selectElement != null && selectRegular != null) {
            throw new IllegalArgumentException("SELECT-ELEMENT and SELECT-REGULAR cannot both be specified.");
        }
        if (selectElement != null && fieldExclusions != null && !fieldExclusions.isEmpty()) {
            throw new IllegalArgumentException("SELECT-ELEMENT and EXCLUDE cannot both be specified.");
        }
        this.selectElement = selectElement;
        this.selectRegular = selectRegular;
        this.distinct = distinct;
        if (fieldExclusions != null) {
            this.fieldExclusions.addAll(fieldExclusions);
        }
    }

    public SelectClause(SelectElement selectElement, SelectRegular selectRegular, boolean distinct) {
        this(selectElement, selectRegular, null, distinct);
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return ((ISqlppVisitor)visitor).visit(this, arg);
    }

    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.SELECT_CLAUSE;
    }

    public void setSelectElement(SelectElement selectElement) throws CompilationException {
        if (!this.fieldExclusions.isEmpty() && selectElement != null) {
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, this.getSourceLocation(), new Serializable[]{"SELECT ELEMENT and EXCLUDE cannot coexist!"});
        }
        this.selectElement = selectElement;
        this.selectRegular = null;
    }

    public void setSelectRegular(SelectRegular selectRegular) {
        this.selectRegular = selectRegular;
        this.selectElement = null;
    }

    public SelectElement getSelectElement() {
        return this.selectElement;
    }

    public SelectRegular getSelectRegular() {
        return this.selectRegular;
    }

    public boolean selectElement() {
        return this.selectElement != null;
    }

    public boolean selectRegular() {
        return this.selectRegular != null;
    }

    public boolean distinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public List<List<String>> getFieldExclusions() {
        return this.fieldExclusions;
    }

    public String toString() {
        String distinctString = this.distinct ? "distinct " : "";
        Object valueString = this.selectElement() ? "element " + this.selectElement : String.valueOf((Object)this.selectRegular);
        Object exceptString = "";
        if (!this.fieldExclusions.isEmpty()) {
            Function<List, String> fieldBuilder = f -> String.join((CharSequence)".", f);
            exceptString = " exclude " + this.fieldExclusions.stream().map(fieldBuilder).collect(Collectors.joining(", "));
        }
        return String.format("select %s%s%s", distinctString, valueString, exceptString);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.distinct, this.selectElement, this.selectRegular, this.fieldExclusions});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SelectClause)) {
            return false;
        }
        SelectClause target = (SelectClause)((Object)object);
        return this.distinct == target.distinct && Objects.equals((Object)this.selectElement, (Object)target.selectElement) && Objects.equals((Object)this.selectRegular, (Object)target.selectRegular) && Objects.equals(this.fieldExclusions, target.fieldExclusions);
    }
}

