/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.api.IMetadataEntity;
import org.apache.asterix.metadata.entities.CompactionPolicy;
import org.apache.asterix.metadata.entities.Database;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.DatasourceAdapter;
import org.apache.asterix.metadata.entities.Datatype;
import org.apache.asterix.metadata.entities.Dataverse;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.FeedConnection;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entities.FullTextConfigMetadataEntity;
import org.apache.asterix.metadata.entities.FullTextFilterMetadataEntity;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.entities.Library;
import org.apache.asterix.metadata.entities.NodeGroup;
import org.apache.asterix.metadata.entities.Synonym;
import org.apache.asterix.metadata.utils.IndexUtil;
import org.apache.asterix.runtime.fulltext.FullTextConfigDescriptor;

public class MetadataCache {
    protected final Map<String, Database> databases = new HashMap<String, Database>();
    protected final Map<String, Map<DataverseName, Dataverse>> dataverses = new HashMap<String, Map<DataverseName, Dataverse>>();
    protected final Map<String, Map<DataverseName, Map<String, Dataset>>> datasets = new HashMap<String, Map<DataverseName, Map<String, Dataset>>>();
    protected final Map<String, Map<DataverseName, Map<String, Map<String, Index>>>> indexes = new HashMap<String, Map<DataverseName, Map<String, Map<String, Index>>>>();
    protected final Map<String, Map<DataverseName, Map<String, Datatype>>> datatypes = new HashMap<String, Map<DataverseName, Map<String, Datatype>>>();
    protected final Map<String, NodeGroup> nodeGroups = new HashMap<String, NodeGroup>();
    protected final Map<FunctionSignature, Function> functions = new HashMap<FunctionSignature, Function>();
    protected final Map<String, Map<DataverseName, Map<String, DatasourceAdapter>>> adapters = new HashMap<String, Map<DataverseName, Map<String, DatasourceAdapter>>>();
    protected final Map<String, Map<DataverseName, Map<String, FeedPolicyEntity>>> feedPolicies = new HashMap<String, Map<DataverseName, Map<String, FeedPolicyEntity>>>();
    protected final Map<String, Map<DataverseName, Map<String, Library>>> libraries = new HashMap<String, Map<DataverseName, Map<String, Library>>>();
    protected final Map<String, Map<DataverseName, Map<String, Feed>>> feeds = new HashMap<String, Map<DataverseName, Map<String, Feed>>>();
    protected final Map<String, Map<DataverseName, Map<String, CompactionPolicy>>> compactionPolicies = new HashMap<String, Map<DataverseName, Map<String, CompactionPolicy>>>();
    protected final Map<String, Map<DataverseName, Map<String, FeedConnection>>> feedConnections = new HashMap<String, Map<DataverseName, Map<String, FeedConnection>>>();
    protected final Map<String, Map<DataverseName, Map<String, Synonym>>> synonyms = new HashMap<String, Map<DataverseName, Map<String, Synonym>>>();
    protected final Map<String, Map<DataverseName, Map<String, FullTextFilterMetadataEntity>>> fullTextFilters = new HashMap<String, Map<DataverseName, Map<String, FullTextFilterMetadataEntity>>>();
    protected final Map<String, Map<DataverseName, Map<String, FullTextConfigMetadataEntity>>> fullTextConfigs = new HashMap<String, Map<DataverseName, Map<String, FullTextConfigMetadataEntity>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(MetadataTransactionContext ctx) {
        int logIx = 0;
        List<MetadataLogicalOperation> opLog = ctx.getOpLog();
        try {
            for (logIx = 0; logIx < opLog.size(); ++logIx) {
                this.doOperation(opLog.get(logIx));
            }
        }
        catch (Exception e) {
            try {
                for (int i = logIx - 1; i >= 0; --i) {
                    this.undoOperation(opLog.get(i));
                }
            }
            catch (Exception e2) {
                this.clear();
            }
        }
        finally {
            ctx.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Database> map = this.databases;
        synchronized (map) {
            Map<String, Map<DataverseName, Dataverse>> map2 = this.dataverses;
            synchronized (map2) {
                Map<String, NodeGroup> map3 = this.nodeGroups;
                synchronized (map3) {
                    Map<String, Map<DataverseName, Map<String, Dataset>>> map4 = this.datasets;
                    synchronized (map4) {
                        Map<String, Map<DataverseName, Map<String, Map<String, Index>>>> map5 = this.indexes;
                        synchronized (map5) {
                            Map<String, Map<DataverseName, Map<String, Datatype>>> map6 = this.datatypes;
                            synchronized (map6) {
                                Map<FunctionSignature, Function> map7 = this.functions;
                                synchronized (map7) {
                                    Map<String, Map<DataverseName, Map<String, FullTextConfigMetadataEntity>>> map8 = this.fullTextConfigs;
                                    synchronized (map8) {
                                        Map<String, Map<DataverseName, Map<String, FullTextFilterMetadataEntity>>> map9 = this.fullTextFilters;
                                        synchronized (map9) {
                                            Map<String, Map<DataverseName, Map<String, DatasourceAdapter>>> map10 = this.adapters;
                                            synchronized (map10) {
                                                Map<String, Map<DataverseName, Map<String, Library>>> map11 = this.libraries;
                                                synchronized (map11) {
                                                    Map<String, Map<DataverseName, Map<String, CompactionPolicy>>> map12 = this.compactionPolicies;
                                                    synchronized (map12) {
                                                        Map<String, Map<DataverseName, Map<String, Synonym>>> map13 = this.synonyms;
                                                        synchronized (map13) {
                                                            this.databases.clear();
                                                            this.dataverses.clear();
                                                            this.nodeGroups.clear();
                                                            this.datasets.clear();
                                                            this.indexes.clear();
                                                            this.datatypes.clear();
                                                            this.functions.clear();
                                                            this.fullTextConfigs.clear();
                                                            this.fullTextFilters.clear();
                                                            this.adapters.clear();
                                                            this.libraries.clear();
                                                            this.compactionPolicies.clear();
                                                            this.synonyms.clear();
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database addDatabaseIfNotExists(Database database) {
        Map<String, Database> map = this.databases;
        synchronized (map) {
            Map<String, Map<DataverseName, Dataverse>> map2 = this.dataverses;
            synchronized (map2) {
                Map<String, Map<DataverseName, Map<String, Dataset>>> map3 = this.datasets;
                synchronized (map3) {
                    Map<String, Map<DataverseName, Map<String, Datatype>>> map4 = this.datatypes;
                    synchronized (map4) {
                        String databaseName = database.getDatabaseName();
                        if (!this.databases.containsKey(databaseName)) {
                            this.dataverses.put(databaseName, new HashMap());
                            this.datasets.put(databaseName, new HashMap());
                            this.datatypes.put(databaseName, new HashMap());
                            this.adapters.put(databaseName, new HashMap());
                            return this.databases.put(databaseName, database);
                        }
                        return null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataverse addDataverseIfNotExists(Dataverse dataverse) {
        Map<String, Map<DataverseName, Dataverse>> map = this.dataverses;
        synchronized (map) {
            Map<String, Map<DataverseName, Map<String, Dataset>>> map2 = this.datasets;
            synchronized (map2) {
                Map<String, Map<DataverseName, Map<String, Datatype>>> map3 = this.datatypes;
                synchronized (map3) {
                    String databaseName = dataverse.getDatabaseName();
                    Map databaseDataverses = this.dataverses.computeIfAbsent(databaseName, k -> new HashMap());
                    DataverseName dataverseName = dataverse.getDataverseName();
                    if (!databaseDataverses.containsKey(dataverseName)) {
                        Map dataverseDatasets = this.datasets.computeIfAbsent(databaseName, k -> new HashMap());
                        dataverseDatasets.put(dataverseName, new HashMap());
                        Map dataverseDatatypes = this.datatypes.computeIfAbsent(databaseName, k -> new HashMap());
                        dataverseDatatypes.put(dataverseName, new HashMap());
                        Map dataverseAdapters = this.adapters.computeIfAbsent(databaseName, k -> new HashMap());
                        dataverseAdapters.put(dataverseName, new HashMap());
                        return databaseDataverses.put(dataverseName, dataverse);
                    }
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset addDatasetIfNotExists(Dataset dataset) {
        Map<String, Map<DataverseName, Map<String, Dataset>>> map = this.datasets;
        synchronized (map) {
            Map<String, Map<DataverseName, Map<String, Map<String, Index>>>> map2 = this.indexes;
            synchronized (map2) {
                Map databaseDataverses;
                Map dataverseDatasets;
                if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
                    Index index = IndexUtil.getPrimaryIndex(dataset);
                    this.addIndexIfNotExistsInternal(index);
                }
                if (!(dataverseDatasets = (databaseDataverses = this.datasets.computeIfAbsent(dataset.getDatabaseName(), k -> new HashMap())).computeIfAbsent(dataset.getDataverseName(), k -> new HashMap())).containsKey(dataset.getDatasetName())) {
                    return dataverseDatasets.put(dataset.getDatasetName(), dataset);
                }
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index addIndexIfNotExists(Index index) {
        Map<String, Map<DataverseName, Map<String, Map<String, Index>>>> map = this.indexes;
        synchronized (map) {
            return this.addIndexIfNotExistsInternal(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datatype addDatatypeIfNotExists(Datatype datatype) {
        Map<String, Map<DataverseName, Map<String, Datatype>>> map = this.datatypes;
        synchronized (map) {
            Map databaseDataverses = this.datatypes.computeIfAbsent(datatype.getDatabaseName(), k -> new HashMap());
            Map dataverseDatatypes = databaseDataverses.computeIfAbsent(datatype.getDataverseName(), k -> new HashMap());
            if (!dataverseDatatypes.containsKey(datatype.getDatatypeName())) {
                return dataverseDatatypes.put(datatype.getDatatypeName(), datatype);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeGroup addOrUpdateNodeGroup(NodeGroup nodeGroup) {
        Map<String, NodeGroup> map = this.nodeGroups;
        synchronized (map) {
            return this.nodeGroups.put(nodeGroup.getNodeGroupName(), nodeGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompactionPolicy addCompactionPolicyIfNotExists(CompactionPolicy compactionPolicy) {
        Map<String, Map<DataverseName, Map<String, CompactionPolicy>>> map = this.compactionPolicies;
        synchronized (map) {
            Map databaseDataverses = this.compactionPolicies.computeIfAbsent(compactionPolicy.getDatabaseName(), k -> new HashMap());
            Map dataverseCompactionPolicies = databaseDataverses.computeIfAbsent(compactionPolicy.getDataverseName(), k -> new HashMap());
            if (!dataverseCompactionPolicies.containsKey(compactionPolicy.getPolicyName())) {
                return dataverseCompactionPolicies.put(compactionPolicy.getPolicyName(), compactionPolicy);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database dropDatabase(Database database) {
        Map<String, Database> map = this.databases;
        synchronized (map) {
            Map<String, Map<DataverseName, Dataverse>> map2 = this.dataverses;
            synchronized (map2) {
                Map<String, Map<DataverseName, Map<String, Dataset>>> map3 = this.datasets;
                synchronized (map3) {
                    Map<String, Map<DataverseName, Map<String, Map<String, Index>>>> map4 = this.indexes;
                    synchronized (map4) {
                        Map<String, Map<DataverseName, Map<String, Datatype>>> map5 = this.datatypes;
                        synchronized (map5) {
                            Map<FunctionSignature, Function> map6 = this.functions;
                            synchronized (map6) {
                                Map<String, Map<DataverseName, Map<String, FullTextConfigMetadataEntity>>> map7 = this.fullTextConfigs;
                                synchronized (map7) {
                                    Map<String, Map<DataverseName, Map<String, FullTextFilterMetadataEntity>>> map8 = this.fullTextFilters;
                                    synchronized (map8) {
                                        Map<String, Map<DataverseName, Map<String, DatasourceAdapter>>> map9 = this.adapters;
                                        synchronized (map9) {
                                            Map<String, Map<DataverseName, Map<String, Library>>> map10 = this.libraries;
                                            synchronized (map10) {
                                                Map<String, Map<DataverseName, Map<String, Feed>>> map11 = this.feeds;
                                                synchronized (map11) {
                                                    Map<String, Map<DataverseName, Map<String, CompactionPolicy>>> map12 = this.compactionPolicies;
                                                    synchronized (map12) {
                                                        Map<String, Map<DataverseName, Map<String, Synonym>>> map13 = this.synonyms;
                                                        synchronized (map13) {
                                                            String databaseName = database.getDatabaseName();
                                                            this.synonyms.remove(databaseName);
                                                            this.compactionPolicies.remove(databaseName);
                                                            this.feeds.remove(databaseName);
                                                            this.libraries.remove(databaseName);
                                                            this.adapters.remove(databaseName);
                                                            this.fullTextFilters.remove(databaseName);
                                                            this.fullTextConfigs.remove(databaseName);
                                                            this.datatypes.remove(databaseName);
                                                            this.indexes.remove(databaseName);
                                                            this.datasets.remove(databaseName);
                                                            this.dataverses.remove(databaseName);
                                                            ArrayList<FunctionSignature> markedFunctionsForRemoval = new ArrayList<FunctionSignature>();
                                                            for (FunctionSignature signature : this.functions.keySet()) {
                                                                if (!signature.getDatabaseName().equals(databaseName)) continue;
                                                                markedFunctionsForRemoval.add(signature);
                                                            }
                                                            for (FunctionSignature signature : markedFunctionsForRemoval) {
                                                                this.functions.remove(signature);
                                                            }
                                                            return this.databases.remove(databaseName);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataverse dropDataverse(Dataverse dataverse) {
        Map<String, Map<DataverseName, Dataverse>> map = this.dataverses;
        synchronized (map) {
            Map<String, Map<DataverseName, Map<String, Dataset>>> map2 = this.datasets;
            synchronized (map2) {
                Map<String, Map<DataverseName, Map<String, Map<String, Index>>>> map3 = this.indexes;
                synchronized (map3) {
                    Map<String, Map<DataverseName, Map<String, Datatype>>> map4 = this.datatypes;
                    synchronized (map4) {
                        Map<FunctionSignature, Function> map5 = this.functions;
                        synchronized (map5) {
                            Map<String, Map<DataverseName, Map<String, FullTextConfigMetadataEntity>>> map6 = this.fullTextConfigs;
                            synchronized (map6) {
                                Map<String, Map<DataverseName, Map<String, FullTextFilterMetadataEntity>>> map7 = this.fullTextFilters;
                                synchronized (map7) {
                                    Map<String, Map<DataverseName, Map<String, DatasourceAdapter>>> map8 = this.adapters;
                                    synchronized (map8) {
                                        Map<String, Map<DataverseName, Map<String, Library>>> map9 = this.libraries;
                                        synchronized (map9) {
                                            Map<String, Map<DataverseName, Map<String, Feed>>> map10 = this.feeds;
                                            synchronized (map10) {
                                                Map<String, Map<DataverseName, Map<String, CompactionPolicy>>> map11 = this.compactionPolicies;
                                                synchronized (map11) {
                                                    Map<String, Map<DataverseName, Map<String, Synonym>>> map12 = this.synonyms;
                                                    synchronized (map12) {
                                                        Map<DataverseName, Dataverse> dv;
                                                        Map<DataverseName, Map<String, Synonym>> syn;
                                                        Map<DataverseName, Map<String, Feed>> fd;
                                                        Map<DataverseName, Map<String, Library>> lib;
                                                        Map<DataverseName, Map<String, FullTextFilterMetadataEntity>> ftf;
                                                        Map<DataverseName, Map<String, CompactionPolicy>> cp;
                                                        Map<DataverseName, Map<String, DatasourceAdapter>> ad;
                                                        Map<DataverseName, Map<String, Datatype>> dt;
                                                        Map<DataverseName, Map<String, Map<String, Index>>> idx;
                                                        String databaseName = dataverse.getDatabaseName();
                                                        DataverseName dataverseName = dataverse.getDataverseName();
                                                        Map<DataverseName, Map<String, Dataset>> ds = this.datasets.get(databaseName);
                                                        if (ds != null) {
                                                            ds.remove(dataverseName);
                                                        }
                                                        if ((idx = this.indexes.get(databaseName)) != null) {
                                                            idx.remove(dataverseName);
                                                        }
                                                        if ((dt = this.datatypes.get(databaseName)) != null) {
                                                            dt.remove(dataverseName);
                                                        }
                                                        if ((ad = this.adapters.get(databaseName)) != null) {
                                                            ad.remove(dataverseName);
                                                        }
                                                        if ((cp = this.compactionPolicies.get(databaseName)) != null) {
                                                            cp.remove(dataverseName);
                                                        }
                                                        ArrayList<FunctionSignature> markedFunctionsForRemoval = new ArrayList<FunctionSignature>();
                                                        for (FunctionSignature signature : this.functions.keySet()) {
                                                            if (!signature.getDatabaseName().equals(databaseName) || !signature.getDataverseName().equals((Object)dataverseName)) continue;
                                                            markedFunctionsForRemoval.add(signature);
                                                        }
                                                        for (FunctionSignature signature : markedFunctionsForRemoval) {
                                                            this.functions.remove(signature);
                                                        }
                                                        Map<DataverseName, Map<String, FullTextConfigMetadataEntity>> ftc = this.fullTextConfigs.get(databaseName);
                                                        if (ftc != null) {
                                                            ftc.remove(dataverseName);
                                                        }
                                                        if ((ftf = this.fullTextFilters.get(databaseName)) != null) {
                                                            ftf.remove(dataverseName);
                                                        }
                                                        if ((lib = this.libraries.get(databaseName)) != null) {
                                                            lib.remove(dataverseName);
                                                        }
                                                        if ((fd = this.feeds.get(databaseName)) != null) {
                                                            fd.remove(dataverseName);
                                                        }
                                                        if ((syn = this.synonyms.get(databaseName)) != null) {
                                                            syn.remove(dataverseName);
                                                        }
                                                        Dataverse dataverse2 = (dv = this.dataverses.get(databaseName)) == null ? null : dv.remove(dataverseName);
                                                        return dataverse2;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset dropDataset(Dataset dataset) {
        Map<String, Map<DataverseName, Map<String, Dataset>>> map = this.datasets;
        synchronized (map) {
            Map<String, Map<DataverseName, Map<String, Map<String, Index>>>> map2 = this.indexes;
            synchronized (map2) {
                Map<DataverseName, Map<String, Dataset>> dsDb;
                Map<String, Map<String, Index>> datasetMap;
                Map<DataverseName, Map<String, Map<String, Index>>> idxDb = this.indexes.get(dataset.getDatabaseName());
                if (idxDb != null && (datasetMap = idxDb.get(dataset.getDataverseName())) != null) {
                    datasetMap.remove(dataset.getDatasetName());
                }
                if ((dsDb = this.datasets.get(dataset.getDatabaseName())) == null) {
                    return null;
                }
                Map<String, Dataset> m = dsDb.get(dataset.getDataverseName());
                if (m == null) {
                    return null;
                }
                return m.remove(dataset.getDatasetName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index dropIndex(Index index) {
        Map<String, Map<DataverseName, Map<String, Map<String, Index>>>> map = this.indexes;
        synchronized (map) {
            Map<DataverseName, Map<String, Map<String, Index>>> databaseDataverses = this.indexes.get(index.getDatabaseName());
            if (databaseDataverses == null) {
                return null;
            }
            Map<String, Map<String, Index>> datasetMap = databaseDataverses.get(index.getDataverseName());
            if (datasetMap == null) {
                return null;
            }
            Map<String, Index> indexMap = datasetMap.get(index.getDatasetName());
            if (indexMap == null) {
                return null;
            }
            return indexMap.remove(index.getIndexName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datatype dropDatatype(Datatype datatype) {
        Map<String, Map<DataverseName, Map<String, Datatype>>> map = this.datatypes;
        synchronized (map) {
            Map<DataverseName, Map<String, Datatype>> databaseDataverses = this.datatypes.get(datatype.getDatabaseName());
            if (databaseDataverses == null) {
                return null;
            }
            Map<String, Datatype> m = databaseDataverses.get(datatype.getDataverseName());
            if (m == null) {
                return null;
            }
            return m.remove(datatype.getDatatypeName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompactionPolicy dropCompactionPolicy(CompactionPolicy compactionPolicy) {
        Map<String, Map<DataverseName, Map<String, CompactionPolicy>>> map = this.compactionPolicies;
        synchronized (map) {
            Map<DataverseName, Map<String, CompactionPolicy>> databaseDataverses = this.compactionPolicies.get(compactionPolicy.getDatabaseName());
            if (databaseDataverses == null) {
                return null;
            }
            Map<String, CompactionPolicy> p = databaseDataverses.get(compactionPolicy.getDataverseName());
            if (p != null && p.get(compactionPolicy.getPolicyName()) != null) {
                return p.remove(compactionPolicy.getPolicyName());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeGroup dropNodeGroup(NodeGroup nodeGroup) {
        Map<String, NodeGroup> map = this.nodeGroups;
        synchronized (map) {
            return this.nodeGroups.remove(nodeGroup.getNodeGroupName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database getDatabase(String databaseName) {
        Map<String, Database> map = this.databases;
        synchronized (map) {
            return this.databases.get(databaseName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataverse getDataverse(String databaseName, DataverseName dataverseName) {
        Map<String, Map<DataverseName, Dataverse>> map = this.dataverses;
        synchronized (map) {
            Map<DataverseName, Dataverse> db = this.dataverses.get(databaseName);
            return db == null ? null : db.get(dataverseName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset getDataset(String databaseName, DataverseName dataverseName, String datasetName) {
        Map<String, Map<DataverseName, Map<String, Dataset>>> map = this.datasets;
        synchronized (map) {
            Map<DataverseName, Map<String, Dataset>> db = this.datasets.get(databaseName);
            if (db == null) {
                return null;
            }
            Map<String, Dataset> dv = db.get(dataverseName);
            Dataset dataset = dv == null ? null : dv.get(datasetName);
            return dataset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index getIndex(String databaseName, DataverseName dataverseName, String datasetName, String indexName) {
        Map<String, Map<DataverseName, Map<String, Map<String, Index>>>> map = this.indexes;
        synchronized (map) {
            Map<DataverseName, Map<String, Map<String, Index>>> db = this.indexes.get(databaseName);
            if (db == null) {
                return null;
            }
            Map<String, Map<String, Index>> datasetMap = db.get(dataverseName);
            if (datasetMap == null) {
                return null;
            }
            Map<String, Index> indexMap = datasetMap.get(datasetName);
            if (indexMap == null) {
                return null;
            }
            return indexMap.get(indexName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datatype getDatatype(String databaseName, DataverseName dataverseName, String datatypeName) {
        Map<String, Map<DataverseName, Map<String, Datatype>>> map = this.datatypes;
        synchronized (map) {
            Map<DataverseName, Map<String, Datatype>> db = this.datatypes.get(databaseName);
            if (db == null) {
                return null;
            }
            Map<String, Datatype> m = db.get(dataverseName);
            if (m == null) {
                return null;
            }
            return m.get(datatypeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeGroup getNodeGroup(String nodeGroupName) {
        Map<String, NodeGroup> map = this.nodeGroups;
        synchronized (map) {
            return this.nodeGroups.get(nodeGroupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function getFunction(FunctionSignature functionSignature) {
        Map<FunctionSignature, Function> map = this.functions;
        synchronized (map) {
            return this.functions.get(functionSignature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullTextConfigMetadataEntity getFullTextConfig(String databaseName, DataverseName dataverseName, String configName) {
        Map<String, Map<DataverseName, Map<String, FullTextConfigMetadataEntity>>> map = this.fullTextConfigs;
        synchronized (map) {
            Map<DataverseName, Map<String, FullTextConfigMetadataEntity>> db = this.fullTextConfigs.get(databaseName);
            if (db == null) {
                return null;
            }
            Map<String, FullTextConfigMetadataEntity> m = db.get(dataverseName);
            if (m == null) {
                return null;
            }
            return m.get(configName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullTextFilterMetadataEntity getFullTextFilter(String databaseName, DataverseName dataverseName, String filterName) {
        Map<String, Map<DataverseName, Map<String, FullTextFilterMetadataEntity>>> map = this.fullTextFilters;
        synchronized (map) {
            Map<DataverseName, Map<String, FullTextFilterMetadataEntity>> db = this.fullTextFilters.get(databaseName);
            if (db == null) {
                return null;
            }
            Map<String, FullTextFilterMetadataEntity> m = db.get(dataverseName);
            if (m == null) {
                return null;
            }
            return m.get(filterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dataset> getDataverseDatasets(String databaseName, DataverseName dataverseName) {
        Map<String, Map<DataverseName, Map<String, Dataset>>> map = this.datasets;
        synchronized (map) {
            Map<DataverseName, Map<String, Dataset>> db = this.datasets.get(databaseName);
            if (db == null) {
                return Collections.emptyList();
            }
            Map<String, Dataset> m = db.get(dataverseName);
            if (m == null) {
                return Collections.emptyList();
            }
            return new ArrayList<Dataset>(m.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Index> getDatasetIndexes(String databaseName, DataverseName dataverseName, String datasetName) {
        Map<String, Map<DataverseName, Map<String, Map<String, Index>>>> map = this.indexes;
        synchronized (map) {
            Map<DataverseName, Map<String, Map<String, Index>>> db = this.indexes.get(databaseName);
            if (db == null) {
                return Collections.emptyList();
            }
            Map<String, Map<String, Index>> dv = db.get(dataverseName);
            if (dv == null) {
                return Collections.emptyList();
            }
            Map<String, Index> map2 = dv.get(datasetName);
            if (map2 == null) {
                return Collections.emptyList();
            }
            return new ArrayList<Index>(map2.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function addFunctionIfNotExists(Function function) {
        Map<FunctionSignature, Function> map = this.functions;
        synchronized (map) {
            FunctionSignature signature = new FunctionSignature(function.getDatabaseName(), function.getDataverseName(), function.getName(), function.getArity());
            Function fun = this.functions.get(signature);
            if (fun == null) {
                return this.functions.put(signature, function);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function dropFunction(Function function) {
        Map<FunctionSignature, Function> map = this.functions;
        synchronized (map) {
            FunctionSignature signature = new FunctionSignature(function.getDatabaseName(), function.getDataverseName(), function.getName(), function.getArity());
            Function fun = this.functions.get(signature);
            if (fun == null) {
                return null;
            }
            return this.functions.remove(signature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullTextFilterMetadataEntity addFullTextFilterIfNotExists(FullTextFilterMetadataEntity filter) {
        String databaseName = filter.getFullTextFilter().getDatabaseName();
        DataverseName dataverseName = filter.getFullTextFilter().getDataverseName();
        String filterName = filter.getFullTextFilter().getName();
        Map<String, Map<DataverseName, Map<String, FullTextFilterMetadataEntity>>> map = this.fullTextFilters;
        synchronized (map) {
            Map databaseDataverses = this.fullTextFilters.computeIfAbsent(databaseName, k -> new HashMap());
            HashMap<String, FullTextFilterMetadataEntity> m = (HashMap<String, FullTextFilterMetadataEntity>)databaseDataverses.get(dataverseName);
            if (m == null) {
                m = new HashMap<String, FullTextFilterMetadataEntity>();
                databaseDataverses.put(dataverseName, m);
            }
            if (!m.containsKey(filterName)) {
                return m.put(filterName, filter);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullTextFilterMetadataEntity dropFullTextFilter(FullTextFilterMetadataEntity filterMetadataEntity) {
        DataverseName dataverseName = filterMetadataEntity.getFullTextFilter().getDataverseName();
        String filterName = filterMetadataEntity.getFullTextFilter().getName();
        Map<String, Map<DataverseName, Map<String, FullTextFilterMetadataEntity>>> map = this.fullTextFilters;
        synchronized (map) {
            Map<DataverseName, Map<String, FullTextFilterMetadataEntity>> databaseDataverses = this.fullTextFilters.get(filterMetadataEntity.getFullTextFilter().getDatabaseName());
            if (databaseDataverses == null) {
                return null;
            }
            Map<String, FullTextFilterMetadataEntity> m = databaseDataverses.get(dataverseName);
            if (m == null) {
                return null;
            }
            return m.remove(filterName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullTextConfigMetadataEntity addFullTextConfigIfNotExists(FullTextConfigMetadataEntity configMetadataEntity) {
        FullTextConfigDescriptor config = configMetadataEntity.getFullTextConfig();
        String databaseName = config.getDatabaseName();
        DataverseName dataverseName = config.getDataverseName();
        String configName = config.getName();
        Map<String, Map<DataverseName, Map<String, FullTextConfigMetadataEntity>>> map = this.fullTextConfigs;
        synchronized (map) {
            Map databaseDataverses = this.fullTextConfigs.computeIfAbsent(databaseName, k -> new HashMap());
            HashMap<String, FullTextConfigMetadataEntity> m = (HashMap<String, FullTextConfigMetadataEntity>)databaseDataverses.get(dataverseName);
            if (m == null) {
                m = new HashMap<String, FullTextConfigMetadataEntity>();
                databaseDataverses.put(dataverseName, m);
            }
            if (!m.containsKey(configName)) {
                return m.put(configName, configMetadataEntity);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullTextConfigMetadataEntity dropFullTextConfig(FullTextConfigMetadataEntity configMetadataEntity) {
        FullTextConfigDescriptor config = configMetadataEntity.getFullTextConfig();
        DataverseName dataverseName = config.getDataverseName();
        String configName = config.getName();
        Map<String, Map<DataverseName, Map<String, FullTextConfigMetadataEntity>>> map = this.fullTextConfigs;
        synchronized (map) {
            Map<DataverseName, Map<String, FullTextConfigMetadataEntity>> databaseDataverses = this.fullTextConfigs.get(config.getDatabaseName());
            if (databaseDataverses == null) {
                return null;
            }
            Map<String, FullTextConfigMetadataEntity> m = databaseDataverses.get(dataverseName);
            if (m == null) {
                return null;
            }
            return m.remove(configName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addFeedPolicyIfNotExists(FeedPolicyEntity feedPolicy) {
        Map<String, Map<DataverseName, Map<String, FeedPolicyEntity>>> map = this.feedPolicies;
        synchronized (map) {
            Map databaseDataverses = this.feedPolicies.computeIfAbsent(feedPolicy.getDatabaseName(), k -> new HashMap());
            HashMap<String, FeedPolicyEntity> p = (HashMap<String, FeedPolicyEntity>)databaseDataverses.get(feedPolicy.getDataverseName());
            if (p == null) {
                p = new HashMap<String, FeedPolicyEntity>();
                p.put(feedPolicy.getPolicyName(), feedPolicy);
                databaseDataverses.put(feedPolicy.getDataverseName(), p);
            } else if (p.get(feedPolicy.getPolicyName()) == null) {
                p.put(feedPolicy.getPolicyName(), feedPolicy);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dropFeedPolicy(FeedPolicyEntity feedPolicy) {
        Map<String, Map<DataverseName, Map<String, FeedPolicyEntity>>> map = this.feedPolicies;
        synchronized (map) {
            Map<DataverseName, Map<String, FeedPolicyEntity>> databaseDataverses = this.feedPolicies.get(feedPolicy.getDatabaseName());
            if (databaseDataverses == null) {
                return null;
            }
            Map<String, FeedPolicyEntity> p = databaseDataverses.get(feedPolicy.getDataverseName());
            if (p != null && p.get(feedPolicy.getPolicyName()) != null) {
                return p.remove(feedPolicy.getPolicyName()).getPolicyName();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasourceAdapter addAdapterIfNotExists(DatasourceAdapter adapter) {
        Map<String, Map<DataverseName, Map<String, DatasourceAdapter>>> map = this.adapters;
        synchronized (map) {
            DatasourceAdapter adapterObject;
            Map databaseDataverses = this.adapters.computeIfAbsent(adapter.getAdapterIdentifier().getDatabaseName(), k -> new HashMap());
            HashMap<String, DatasourceAdapter> adaptersInDataverse = (HashMap<String, DatasourceAdapter>)databaseDataverses.get(adapter.getAdapterIdentifier().getDataverseName());
            if (adaptersInDataverse == null) {
                adaptersInDataverse = new HashMap<String, DatasourceAdapter>();
                databaseDataverses.put(adapter.getAdapterIdentifier().getDataverseName(), adaptersInDataverse);
            }
            if ((adapterObject = (DatasourceAdapter)adaptersInDataverse.get(adapter.getAdapterIdentifier().getName())) == null) {
                return adaptersInDataverse.put(adapter.getAdapterIdentifier().getName(), adapter);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatasourceAdapter dropAdapterIfExists(DatasourceAdapter adapter) {
        Map<String, Map<DataverseName, Map<String, DatasourceAdapter>>> map = this.adapters;
        synchronized (map) {
            Map<DataverseName, Map<String, DatasourceAdapter>> databaseDataverses = this.adapters.get(adapter.getAdapterIdentifier().getDatabaseName());
            if (databaseDataverses == null) {
                return null;
            }
            Map<String, DatasourceAdapter> adaptersInDataverse = databaseDataverses.get(adapter.getAdapterIdentifier().getDataverseName());
            if (adaptersInDataverse != null) {
                return adaptersInDataverse.remove(adapter.getAdapterIdentifier().getName());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Library addLibraryIfNotExists(Library library) {
        Map<String, Map<DataverseName, Map<String, Library>>> map = this.libraries;
        synchronized (map) {
            boolean needToAdd;
            Map databaseDataverses = this.libraries.computeIfAbsent(library.getDatabaseName(), k -> new HashMap());
            HashMap<String, Library> libsInDataverse = (HashMap<String, Library>)databaseDataverses.get(library.getDataverseName());
            boolean bl = needToAdd = libsInDataverse == null || libsInDataverse.get(library.getName()) != null;
            if (needToAdd) {
                if (libsInDataverse == null) {
                    libsInDataverse = new HashMap<String, Library>();
                    databaseDataverses.put(library.getDataverseName(), libsInDataverse);
                }
                return libsInDataverse.put(library.getName(), library);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Library dropLibrary(Library library) {
        Map<String, Map<DataverseName, Map<String, Library>>> map = this.libraries;
        synchronized (map) {
            Map<DataverseName, Map<String, Library>> databaseDataverses = this.libraries.get(library.getDatabaseName());
            if (databaseDataverses == null) {
                return null;
            }
            Map<String, Library> librariesInDataverse = databaseDataverses.get(library.getDataverseName());
            if (librariesInDataverse != null) {
                return librariesInDataverse.remove(library.getName());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeedConnection addFeedConnectionIfNotExists(FeedConnection feedConnection) {
        Map<String, Map<DataverseName, Map<String, FeedConnection>>> map = this.feedConnections;
        synchronized (map) {
            Map databaseDataverses = this.feedConnections.computeIfAbsent(feedConnection.getDatabaseName(), k -> new HashMap());
            HashMap<String, FeedConnection> feedConnsInDataverse = (HashMap<String, FeedConnection>)databaseDataverses.get(feedConnection.getDataverseName());
            if (feedConnsInDataverse == null) {
                feedConnsInDataverse = new HashMap<String, FeedConnection>();
                databaseDataverses.put(feedConnection.getDataverseName(), feedConnsInDataverse);
            }
            return feedConnsInDataverse.put(feedConnection.getConnectionId(), feedConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeedConnection dropFeedConnection(FeedConnection feedConnection) {
        Map<String, Map<DataverseName, Map<String, FeedConnection>>> map = this.feedConnections;
        synchronized (map) {
            Map<DataverseName, Map<String, FeedConnection>> databaseDataverses = this.feedConnections.get(feedConnection.getDatabaseName());
            if (databaseDataverses == null) {
                return null;
            }
            Map<String, FeedConnection> feedConnsInDataverse = databaseDataverses.get(feedConnection.getDataverseName());
            if (feedConnsInDataverse != null) {
                return feedConnsInDataverse.remove(feedConnection.getConnectionId());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feed addFeedIfNotExists(Feed feed) {
        Map<String, Map<DataverseName, Map<String, Feed>>> map = this.feeds;
        synchronized (map) {
            Map databaseDataverses = this.feeds.computeIfAbsent(feed.getDatabaseName(), k -> new HashMap());
            HashMap<String, Feed> feedsInDataverse = (HashMap<String, Feed>)databaseDataverses.get(feed.getDataverseName());
            if (feedsInDataverse == null) {
                feedsInDataverse = new HashMap<String, Feed>();
                databaseDataverses.put(feed.getDataverseName(), feedsInDataverse);
            }
            return feedsInDataverse.put(feed.getFeedName(), feed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feed dropFeedIfExists(Feed feed) {
        Map<String, Map<DataverseName, Map<String, Feed>>> map = this.feeds;
        synchronized (map) {
            Map<DataverseName, Map<String, Feed>> databaseDataverses = this.feeds.get(feed.getDatabaseName());
            if (databaseDataverses == null) {
                return null;
            }
            Map<String, Feed> feedsInDataverse = databaseDataverses.get(feed.getDataverseName());
            if (feedsInDataverse != null) {
                return feedsInDataverse.remove(feed.getFeedName());
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Synonym addSynonymIfNotExists(Synonym synonym) {
        Map<String, Map<DataverseName, Map<String, Synonym>>> map = this.synonyms;
        synchronized (map) {
            Map databaseDataverses = this.synonyms.computeIfAbsent(synonym.getDatabaseName(), k -> new HashMap());
            HashMap<String, Synonym> synonymsInDataverse = (HashMap<String, Synonym>)databaseDataverses.get(synonym.getDataverseName());
            if (synonymsInDataverse == null) {
                synonymsInDataverse = new HashMap<String, Synonym>();
                databaseDataverses.put(synonym.getDataverseName(), synonymsInDataverse);
            }
            return synonymsInDataverse.put(synonym.getSynonymName(), synonym);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Synonym dropSynonym(Synonym synonym) {
        Map<String, Map<DataverseName, Map<String, Synonym>>> map = this.synonyms;
        synchronized (map) {
            Map<DataverseName, Map<String, Synonym>> databaseDataverses = this.synonyms.get(synonym.getDatabaseName());
            if (databaseDataverses == null) {
                return null;
            }
            Map<String, Synonym> synonymsInDataverse = databaseDataverses.get(synonym.getDataverseName());
            if (synonymsInDataverse != null) {
                return synonymsInDataverse.remove(synonym.getSynonymName());
            }
            return null;
        }
    }

    private Index addIndexIfNotExistsInternal(Index index) {
        HashMap<String, Index> indexMap;
        Map databaseDataverses = this.indexes.computeIfAbsent(index.getDatabaseName(), k -> new HashMap());
        HashMap datasetMap = (HashMap)databaseDataverses.get(index.getDataverseName());
        if (datasetMap == null) {
            datasetMap = new HashMap();
            databaseDataverses.put(index.getDataverseName(), datasetMap);
        }
        if ((indexMap = (HashMap<String, Index>)datasetMap.get(index.getDatasetName())) == null) {
            indexMap = new HashMap<String, Index>();
            datasetMap.put(index.getDatasetName(), indexMap);
        }
        if (!indexMap.containsKey(index.getIndexName())) {
            return indexMap.put(index.getIndexName(), index);
        }
        return null;
    }

    protected void doOperation(MetadataLogicalOperation op) {
        if (op.isAdd) {
            op.entity.addToCache(this);
        } else {
            op.entity.dropFromCache(this);
        }
    }

    protected void undoOperation(MetadataLogicalOperation op) {
        if (!op.isAdd) {
            op.entity.addToCache(this);
        } else {
            op.entity.dropFromCache(this);
        }
    }

    protected static class MetadataLogicalOperation {
        public final IMetadataEntity<?> entity;
        public final boolean isAdd;

        public MetadataLogicalOperation(IMetadataEntity<?> entity, boolean isAdd) {
            this.entity = entity;
            this.isAdd = isAdd;
        }
    }
}

